/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.thread;

import com.luna.common.dto.ResultDTO;
import com.luna.common.dto.ResultDTOUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonThreadPoolUtil {
    private static final long KEEP_ALIVE_TIME = 0L;
    private static final Logger log = LoggerFactory.getLogger(CommonThreadPoolUtil.class);
    private static volatile int cacheCorePoolSize = 5;
    private static volatile int maxCorePoolSize = 50;
    private static volatile int blockingQueueWaitSize = 2000;
    private static volatile int incrementCorePoolSize = 4;
    private final ThreadLocal<List<Future<?>>> threadLocal = ThreadLocal.withInitial(ArrayList::new);
    private ThreadPoolExecutor threadPool = new ThreadPoolExecutor(CommonThreadPoolUtil.cacheCorePoolSize, CommonThreadPoolUtil.cacheCorePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());

    public CommonThreadPoolUtil(Integer cacheCorePoolSize) {
        if (cacheCorePoolSize != null) {
            this.setCacheCorePoolSize(cacheCorePoolSize);
        }
    }

    public static void main(String[] args) {
        CommonThreadPoolUtil commonThreadPoolUtil = new CommonThreadPoolUtil();
        commonThreadPoolUtil.setCacheCorePoolSize(20);
        for (int i = 0; i < 100; ++i) {
            commonThreadPoolUtil.dealTask(() -> {
                System.out.println("\u7ebf\u7a0b\u6c60\u6267\u884c\u4efb\u52a1");
                return "\u7ebf\u7a0b\u6c60\u6267\u884c\u4efb\u52a1";
            });
        }
        ResultDTO<Object> objectResultDTO = commonThreadPoolUtil.obtainTaskFuture();
        System.out.println(objectResultDTO);
    }

    public synchronized void refresh() {
        this.threadPool = new ThreadPoolExecutor(cacheCorePoolSize, maxCorePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public ResultDTO<Void> dealTask(Callable<?> callable) {
        try {
            this.dynamicTuningPoolSize();
            Future<?> result = this.threadPool.submit(callable);
            List<Future<?>> threadLocalResult = this.threadLocal.get();
            threadLocalResult.add(result);
            this.threadLocal.set(threadLocalResult);
        }
        catch (Exception e) {
            log.error("dealTask::callable = {} ", callable, (Object)e);
            return ResultDTOUtils.failure(9999, "\u7ebf\u7a0b\u6c60\u53d1\u751f\u5f02\u5e38-Future");
        }
        return ResultDTOUtils.success();
    }

    public ResultDTO<Void> dealTask(Runnable runnable) {
        try {
            this.dynamicTuningPoolSize();
            this.threadPool.execute(runnable);
        }
        catch (Exception e) {
            log.error("dealTask::runnable = {} ", (Object)runnable, (Object)e);
            return ResultDTOUtils.failure(9999, "\u7ebf\u7a0b\u6c60\u53d1\u751f\u5f02\u5e38");
        }
        return ResultDTOUtils.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultDTO<Object> obtainTaskFuture() {
        List<Future<?>> threadLocalResult = null;
        try {
            threadLocalResult = this.threadLocal.get();
            if (CollectionUtils.isEmpty(threadLocalResult)) {
                ResultDTO<Object> resultDTO = ResultDTOUtils.failure(9002, "\u83b7\u53d6\u7ebf\u7a0b\u6c60\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a", null);
                return resultDTO;
            }
            ResultDTO<Object> resultDTO = ResultDTOUtils.success(threadLocalResult);
            return resultDTO;
        }
        catch (Exception e) {
            ResultDTO<Object> resultDTO = ResultDTOUtils.failure(9999, "\u83b7\u53d6\u7ebf\u7a0b\u6c60\u6267\u884c\u7ed3\u679c\u53d1\u751f\u5f02\u5e38:" + e.getMessage(), null);
            return resultDTO;
        }
        finally {
            this.threadLocal.remove();
        }
    }

    private void dynamicTuningPoolSize() {
        int queueSize = this.threadPool.getQueue().size();
        if (queueSize >= blockingQueueWaitSize) {
            if (cacheCorePoolSize <= maxCorePoolSize) {
                int corePoolSize = this.threadPool.getCorePoolSize();
                int currentcorePoolSize = corePoolSize + incrementCorePoolSize;
                this.threadPool.setCorePoolSize(currentcorePoolSize);
                this.threadPool.setMaximumPoolSize(currentcorePoolSize);
                cacheCorePoolSize = currentcorePoolSize;
                log.warn("\u52a8\u6001\u6539\u53d8\u7ebf\u7a0b\u6c60\u5927\u5c0f====\u539f\u6838\u5fc3\u7ebf\u7a0b\u6c60\u6570\u76ee\u4e3a\uff1a" + corePoolSize + ";\u73b0\u7d2f\u52a0\u4e3a\uff1a" + currentcorePoolSize);
            } else {
                log.warn("\u52a8\u6001\u6539\u53d8\u7ebf\u7a0b\u6c60\u5927\u5c0f====\u6838\u5fc3\u7ebf\u7a0b\u6c60\u6570\u76ee\u5df2\u7d2f\u52a0\u4e3a\uff1a" + blockingQueueWaitSize + "\uff1b\u4e0d\u4f1a\u7ee7\u7eed\u65e0\u9650\u589e\u52a0");
            }
        }
    }

    public int getCacheCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    public void setCacheCorePoolSize(int cacheCorePoolSize) {
        this.threadPool.setCorePoolSize(cacheCorePoolSize);
        this.threadPool.setMaximumPoolSize(cacheCorePoolSize);
        CommonThreadPoolUtil.cacheCorePoolSize = cacheCorePoolSize;
    }

    @Generated
    public ThreadLocal<List<Future<?>>> getThreadLocal() {
        return this.threadLocal;
    }

    @Generated
    public void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonThreadPoolUtil)) {
            return false;
        }
        CommonThreadPoolUtil other = (CommonThreadPoolUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ThreadLocal<List<Future<?>>> this$threadLocal = this.getThreadLocal();
        ThreadLocal<List<Future<?>>> other$threadLocal = other.getThreadLocal();
        if (this$threadLocal == null ? other$threadLocal != null : !this$threadLocal.equals(other$threadLocal)) {
            return false;
        }
        ThreadPoolExecutor this$threadPool = this.getThreadPool();
        ThreadPoolExecutor other$threadPool = other.getThreadPool();
        return !(this$threadPool == null ? other$threadPool != null : !this$threadPool.equals(other$threadPool));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommonThreadPoolUtil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThreadLocal<List<Future<?>>> $threadLocal = this.getThreadLocal();
        result = result * 59 + ($threadLocal == null ? 43 : $threadLocal.hashCode());
        ThreadPoolExecutor $threadPool = this.getThreadPool();
        result = result * 59 + ($threadPool == null ? 43 : $threadPool.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CommonThreadPoolUtil(threadLocal=" + this.getThreadLocal() + ", threadPool=" + this.getThreadPool() + ")";
    }

    @Generated
    public CommonThreadPoolUtil() {
    }
}

