/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.thread;

import com.google.common.collect.Lists;
import com.luna.common.thread.NamedThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEngineUtils {
    private static final Logger log = LoggerFactory.getLogger(AsyncEngineUtils.class);
    private static final int CORE_POOL_SIZE = 200;
    private static final int MAX_POOL_SIZE = 200;
    private static final int KEEP_ALIVE_TIME = 300;
    private static final int QUEUE_CAPACITY = 1000;
    private static final long TIME_OUT = 300L;
    private static final int MONITOR_PERIOD = 5;
    private static final ExecutorService EXECUTOR;
    private static final Runnable MONITOR_TASK;

    @SafeVarargs
    public static <T> List<T> concurrentExecute(Callable<T> ... tasks) {
        if (tasks == null || tasks.length == 0) {
            return Lists.newArrayList();
        }
        return AsyncEngineUtils.concurrentExecute(-1L, null, Lists.newArrayList((Object[])tasks));
    }

    public static <T> List<T> concurrentExecute(List<Callable<T>> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return Lists.newArrayList();
        }
        return AsyncEngineUtils.concurrentExecute(-1L, null, tasks);
    }

    public static <T> List<T> concurrentExecute(long timeout, TimeUnit unit, List<Callable<T>> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        try {
            List<Future<T>> futures = timeout > 0L ? EXECUTOR.invokeAll(tasks, timeout, unit) : EXECUTOR.invokeAll(tasks);
            for (Future<T> future : futures) {
                Object t = null;
                try {
                    t = future.get(300L, TimeUnit.MILLISECONDS);
                }
                catch (CancellationException e) {
                    if (timeout > 0L) {
                        log.error("concurrentExecute some task timeout!");
                    }
                }
                catch (TimeoutException tt) {
                    log.error("future.get() TimeoutException ", (Throwable)tt);
                }
                catch (Throwable tt) {
                    log.error("future.get() Exception ", tt);
                }
                result.add(t);
            }
        }
        catch (InterruptedException e) {
            log.error("executor.invokeAll() Exception", (Throwable)e);
        }
        return result;
    }

    public static void execute(Runnable task) {
        if (task == null) {
            return;
        }
        EXECUTOR.submit(task);
    }

    public static void main(String[] args) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            list.add(() -> {
                System.out.println("hello");
                return null;
            });
        }
        List voids = AsyncEngineUtils.concurrentExecute(list);
        System.out.println(voids);
    }

    public static void destroy() {
        log.warn("start to stop thread pool");
        EXECUTOR.shutdown();
        log.warn("finish to stop thread pool");
    }

    static {
        MONITOR_TASK = new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadPoolExecutor threadPool = (ThreadPoolExecutor)EXECUTOR;
                    int activeCount = threadPool.getActiveCount();
                    long completedTaskCount = threadPool.getCompletedTaskCount();
                    long totalTaskCount = threadPool.getTaskCount();
                    int queueSize = threadPool.getQueue().size();
                    int coreSize = threadPool.getCorePoolSize();
                    log.info("total_task:{}, active_thread:{}, queue_size:{}, completed_thread:{}, coreSize:{}", new Object[]{totalTaskCount, activeCount, queueSize, completedTaskCount, coreSize});
                }
                catch (Exception e) {
                    log.error("[SYSTEM-SafeGuard]Monitor thread run fail", (Throwable)e);
                }
            }
        };
        EXECUTOR = new ThreadPoolExecutor(200, 200, 300L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        ScheduledExecutorService monitor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("AsyncEngine-Monitor", true));
        monitor.scheduleAtFixedRate(MONITOR_TASK, 5L, 5L, TimeUnit.SECONDS);
    }
}

