/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.text;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LineSplitUtils {
    private static final int SEPARATOR_LENGTH_LIMIT = 100;
    private static final String[] SEPARATOR_CHARS = new String[]{"\u3002", "\uff01", "\uff1f", "!", "?", "."};

    public static List<String> smartSplit(String line) {
        ArrayList<String> list = new ArrayList<String>();
        if (line.length() <= 100) {
            list.add(line);
            return list;
        }
        LineSplitUtils.splitAndAdd(list, line, 0);
        ArrayList<String> resultList = new ArrayList<String>();
        for (String item : list) {
            if (item.length() <= 100) {
                resultList.add(item);
                continue;
            }
            LineSplitUtils.slipByComma(resultList, item);
        }
        return resultList;
    }

    private static void splitAndAdd(List<String> list, String line, int charPosi) {
        String[] items;
        String mark = SEPARATOR_CHARS[charPosi];
        String[] var5 = items = StringUtils.split((String)line, (String)mark);
        int var6 = items.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            String item = var5[var7];
            if (items.length > 1 && LineSplitUtils.notEndWithSeparator(item)) {
                item = item + mark;
            }
            if (charPosi == SEPARATOR_CHARS.length - 1) {
                list.add(item);
                continue;
            }
            if (item.length() <= 100) {
                list.add(item);
                continue;
            }
            LineSplitUtils.splitAndAdd(list, item, charPosi + 1);
        }
    }

    private static void slipByComma(List<String> resultList, String item) {
        String[] subItems = StringUtils.split((String)item, (String)"\uff0c,");
        if (subItems.length == 1) {
            resultList.add(item);
        } else {
            String subRes = subItems[0] + "\uff0c";
            for (int i = 1; i < subItems.length; ++i) {
                String sub = subItems[i];
                if (sub.length() == 0) continue;
                if (LineSplitUtils.notEndWithSeparator(sub)) {
                    sub = sub + "\uff0c";
                }
                if (subRes.length() + sub.length() > 100) {
                    resultList.add(subRes);
                    subRes = sub;
                    continue;
                }
                subRes = subRes + sub;
            }
            if (subRes.length() > 0) {
                resultList.add(subRes);
            }
        }
    }

    private static boolean notEndWithSeparator(String str) {
        return !ArrayUtils.contains((Object[])SEPARATOR_CHARS, (Object)str.substring(str.length() - 1));
    }
}

