/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.text;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FeatureUtils {
    public static final String FEATURE_SEPERATOR = ";";
    public static final String KEY_VALUE_SEPERATOR = ":";

    public static String addOrUpdateAFeature(String origFeatures, String aKey, String aValue) {
        if (null == aKey || aKey.trim().isEmpty()) {
            return origFeatures;
        }
        if (null == aValue || aValue.trim().isEmpty()) {
            return origFeatures;
        }
        if (origFeatures == null || origFeatures.isEmpty()) {
            return aKey + KEY_VALUE_SEPERATOR + aValue;
        }
        List<String[]> featureList = FeatureUtils.convertToList(origFeatures);
        for (String[] sa : featureList) {
            if (!aKey.equals(sa[0])) continue;
            sa[1] = aValue;
            return FeatureUtils.convertFromCollection(featureList);
        }
        featureList.add(new String[]{aKey, aValue});
        return FeatureUtils.convertFromCollection(featureList);
    }

    public static String removeAFeature(String origFeatures, String aKey) {
        if (StringUtils.isBlank((CharSequence)origFeatures) || StringUtils.isBlank((CharSequence)aKey)) {
            return origFeatures;
        }
        List<String[]> featureList = FeatureUtils.convertToList(origFeatures);
        Iterator<String[]> itor = featureList.iterator();
        while (itor.hasNext()) {
            String[] sa = itor.next();
            if (!aKey.equals(sa[0])) continue;
            itor.remove();
            return FeatureUtils.convertFromCollection(featureList);
        }
        return origFeatures;
    }

    public static String getAFeature(String featureStr, String key) {
        if (StringUtils.isBlank((CharSequence)featureStr)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(featureStr, FEATURE_SEPERATOR);
        while (st.hasMoreTokens()) {
            String k;
            String kv = st.nextToken();
            int kvSeperatorIndex = kv.indexOf(KEY_VALUE_SEPERATOR);
            if (kvSeperatorIndex <= 0 || !(k = kv.substring(0, kvSeperatorIndex)).equals(key)) continue;
            String value = null;
            value = kvSeperatorIndex + 1 < kv.length() ? kv.substring(kvSeperatorIndex + 1) : "";
            return value;
        }
        return null;
    }

    public static Long getAFeatureLong(String featureStr, String key) {
        String value = FeatureUtils.getAFeature(featureStr, key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    public static Map<String, String> convertToMap(String featureStr) {
        if (StringUtils.isBlank((CharSequence)featureStr)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> featureMap = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(featureStr, FEATURE_SEPERATOR);
        while (st.hasMoreTokens()) {
            String kv = st.nextToken();
            int kvSeperatorIndex = kv.indexOf(KEY_VALUE_SEPERATOR);
            if (kvSeperatorIndex <= 0) continue;
            String key = kv.substring(0, kvSeperatorIndex);
            String value = null;
            value = kvSeperatorIndex + 1 < kv.length() ? kv.substring(kvSeperatorIndex + 1) : "";
            featureMap.put(key, value);
        }
        return featureMap;
    }

    public static Map<String, String> convertToMap(String featureStr, String seperator) {
        if (StringUtils.isBlank((CharSequence)featureStr)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> featureMap = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(featureStr, seperator);
        while (st.hasMoreTokens()) {
            String kv = st.nextToken();
            int kvSeperatorIndex = kv.indexOf(KEY_VALUE_SEPERATOR);
            if (kvSeperatorIndex <= 0) continue;
            String key = kv.substring(0, kvSeperatorIndex);
            String value = null;
            value = kvSeperatorIndex + 1 < kv.length() ? kv.substring(kvSeperatorIndex + 1) : "";
            featureMap.put(key, value);
        }
        return featureMap;
    }

    public static String convertFromMap(Map<String, String> featureMap) {
        if (featureMap == null) {
            return null;
        }
        if (featureMap.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> e : featureMap.entrySet()) {
            if (!first) {
                sb.append(FEATURE_SEPERATOR);
            } else {
                first = false;
            }
            sb.append(e.getKey()).append(KEY_VALUE_SEPERATOR).append(e.getValue());
        }
        return sb.toString();
    }

    public static String convertFromCollection(Collection<String[]> featureCollection) {
        if (featureCollection == null) {
            return null;
        }
        if (featureCollection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String[] sa : featureCollection) {
            if (!first) {
                sb.append(FEATURE_SEPERATOR);
            } else {
                first = false;
            }
            sb.append(sa[0]).append(KEY_VALUE_SEPERATOR).append(sa[1]);
        }
        return sb.toString();
    }

    public static List<String[]> convertToList(String featureStr) {
        if (StringUtils.isBlank((CharSequence)featureStr)) {
            return new ArrayList<String[]>();
        }
        ArrayList<String[]> featureList = new ArrayList<String[]>();
        StringTokenizer st = new StringTokenizer(featureStr, FEATURE_SEPERATOR);
        while (st.hasMoreTokens()) {
            String kv = st.nextToken();
            int kvSeperatorIndex = kv.indexOf(KEY_VALUE_SEPERATOR);
            if (kvSeperatorIndex <= 0) continue;
            String key = kv.substring(0, kvSeperatorIndex);
            String value = null;
            value = kvSeperatorIndex + 1 < kv.length() ? kv.substring(kvSeperatorIndex + 1) : "";
            featureList.add(new String[]{key, value});
        }
        return featureList;
    }

    public static String convertList2Str(List<?> interList) {
        if (CollectionUtils.isEmpty(interList)) {
            return "";
        }
        return StringUtils.join(interList, (String)",");
    }

    public static List<Long> convertStr2LongList(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(StringUtils.split((String)str, (String)",")).map(Long::parseLong).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        HashMap<String, String> stepPrice = new HashMap<String, String>();
        stepPrice.put("stepPrice", "1:100:65*1:200:45");
        System.out.print(FeatureUtils.convertFromMap(stepPrice));
    }
}

