/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.text;

import com.luna.common.anno.Filter;
import com.luna.common.file.FileTools;
import com.luna.common.os.OSinfo;
import com.luna.common.text.ASCIIStrCache;
import com.luna.common.text.StringTools;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public class CharsetUtil {
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String GBK = "GBK";
    public static final Charset CHARSET_ISO_8859_1 = StandardCharsets.ISO_8859_1;
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;
    public static final Charset CHARSET_GBK;

    public static Charset charset(String charsetName) throws UnsupportedCharsetException {
        return StringTools.isBlank((CharSequence)charsetName) ? Charset.defaultCharset() : Charset.forName(charsetName);
    }

    public static Charset parse(String charsetName) {
        return CharsetUtil.parse(charsetName, Charset.defaultCharset());
    }

    public static Charset parse(String charsetName, Charset defaultCharset) {
        Charset result;
        if (StringTools.isBlank((CharSequence)charsetName)) {
            return defaultCharset;
        }
        try {
            result = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            result = defaultCharset;
        }
        return result;
    }

    public static String convert(String source, String srcCharset, String destCharset) {
        return CharsetUtil.convert(source, Charset.forName(srcCharset), Charset.forName(destCharset));
    }

    public static String convert(String source, Charset srcCharset, Charset destCharset) {
        if (null == srcCharset) {
            srcCharset = StandardCharsets.ISO_8859_1;
        }
        if (null == destCharset) {
            destCharset = StandardCharsets.UTF_8;
        }
        if (StringTools.isBlank((CharSequence)source) || srcCharset.equals(destCharset)) {
            return source;
        }
        return new String(source.getBytes(srcCharset), destCharset);
    }

    public static File convert(File file, Charset srcCharset, Charset destCharset) {
        String str = FileTools.readFileToString(file, srcCharset);
        FileTools.writeStringToFile(file, str, destCharset);
        return file;
    }

    public static String systemCharsetName() {
        return CharsetUtil.systemCharset().name();
    }

    public static Charset systemCharset() {
        return OSinfo.isWindows() ? CHARSET_GBK : CharsetUtil.defaultCharset();
    }

    public static String defaultCharsetName() {
        return CharsetUtil.defaultCharset().name();
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String utf8Str(Object obj) {
        return CharsetUtil.str(obj, CHARSET_UTF_8);
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return CharsetUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return CharsetUtil.str(obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return CharsetUtil.str(obj, charset);
        }
        if (null != obj && obj.getClass().isArray()) {
            return StringTools.toString(obj);
        }
        return obj.toString();
    }

    public static String filter(CharSequence str, Filter<Character> filter) {
        if (str == null || filter == null) {
            return CharsetUtil.str(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!filter.accept(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String cleanBlank(CharSequence str) {
        return CharsetUtil.filter(str, c -> !Character.isWhitespace(c.charValue()) || Character.isSpaceChar(c.charValue()) || c.charValue() == '\ufeff' || c.charValue() == '\u202a' || c.charValue() == '\u0000');
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isLetter(char ch) {
        return CharsetUtil.isLetterUpper(ch) || CharsetUtil.isLetterLower(ch);
    }

    public static boolean isLetterUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLetterLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isHexChar(char c) {
        return CharsetUtil.isNumber(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean isLetterOrNumber(char ch) {
        return CharsetUtil.isLetter(ch) || CharsetUtil.isNumber(ch);
    }

    public static String toString(char c) {
        return ASCIIStrCache.toString(c);
    }

    public static boolean isCharClass(Class<?> clazz) {
        return clazz == Character.class || clazz == Character.TYPE;
    }

    public static boolean isChar(Object value) {
        return value instanceof Character || value.getClass() == Character.TYPE;
    }

    public static boolean isBlankChar(char c) {
        return CharsetUtil.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0 || c == 12644 || c == 10240 || c == 6158;
    }

    public static boolean isEmoji(char c) {
        return !(c == '\u0000' || c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u100000' && c <= '\u10ffff');
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static boolean equals(char c1, char c2, boolean caseInsensitive) {
        if (caseInsensitive) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static int getType(int c) {
        return Character.getType(c);
    }

    public static int digit16(int b) {
        return Character.digit(b, 16);
    }

    public static char toCloseChar(char c) {
        int result = c;
        if (c >= 49 && c <= 57) {
            result = 9312 + c - 49;
        } else if (c >= 65 && c <= 90) {
            result = 9398 + c - 65;
        } else if (c >= 97 && c <= 122) {
            result = 9424 + c - 97;
        }
        return (char)result;
    }

    public static char toCloseByNumber(int number) {
        if (number > 20) {
            throw new IllegalArgumentException("Number must be [1-20]");
        }
        return (char)(9312 + number - 1);
    }

    static {
        Charset _CHARSET_GBK = null;
        try {
            _CHARSET_GBK = Charset.forName(GBK);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        CHARSET_GBK = _CHARSET_GBK;
    }
}

