/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.swing;

import com.luna.common.exception.UtilException;
import com.luna.common.file.FileTools;
import com.luna.common.img.ImgUtil;
import com.luna.common.swing.ClipboardUtil;
import com.luna.common.swing.ScreenUtil;
import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;
import org.apache.commons.lang3.ArrayUtils;

public class RobotUtil {
    private static Robot ROBOT;
    private static int delay;

    public static void main(String[] args) {
        RobotUtil.captureScreen(0, 0, 200, 300, FileTools.touch("/Users/weidian/Downloads/2.jpg"));
    }

    public static Robot getRobot() {
        return ROBOT;
    }

    public static int getDelay() {
        return delay;
    }

    public static void setDelay(int delayMillis) {
        delay = delayMillis;
    }

    public static void mouseMove(int x, int y) {
        ROBOT.mouseMove(x, y);
    }

    public static void click() {
        ROBOT.mousePress(16);
        ROBOT.mouseRelease(16);
        RobotUtil.delay();
    }

    public static void rightClick() {
        ROBOT.mousePress(4);
        ROBOT.mouseRelease(4);
        RobotUtil.delay();
    }

    public static void mouseWheel(int wheelAmt) {
        ROBOT.mouseWheel(wheelAmt);
        RobotUtil.delay();
    }

    public static void keyClick(int ... keyCodes) {
        for (int keyCode : keyCodes) {
            ROBOT.keyPress(keyCode);
            ROBOT.keyRelease(keyCode);
        }
        RobotUtil.delay();
    }

    public static void keyPressString(String str) {
        ClipboardUtil.setStr(str);
        RobotUtil.keyPressWithCtrl(86);
        RobotUtil.delay();
    }

    public static void keyPressWithShift(int key) {
        ROBOT.keyPress(16);
        ROBOT.keyPress(key);
        ROBOT.keyRelease(key);
        ROBOT.keyRelease(16);
        RobotUtil.delay();
    }

    public static void keyPressWithCtrl(int key) {
        ROBOT.keyPress(17);
        ROBOT.keyPress(key);
        ROBOT.keyRelease(key);
        ROBOT.keyRelease(17);
        RobotUtil.delay();
    }

    public static void keyPressWithAlt(int key) {
        ROBOT.keyPress(18);
        ROBOT.keyPress(key);
        ROBOT.keyRelease(key);
        ROBOT.keyRelease(18);
        RobotUtil.delay();
    }

    public static BufferedImage captureScreen() {
        return RobotUtil.captureScreen(ScreenUtil.getRectangle());
    }

    public static File captureScreen(File outFile) {
        ImgUtil.write(RobotUtil.captureScreen(), outFile);
        return outFile;
    }

    public static BufferedImage captureScreen(Rectangle screenRect) {
        return ROBOT.createScreenCapture(screenRect);
    }

    public static Robot getRobot(GraphicsDevice graphicsDevice) {
        try {
            return new Robot(graphicsDevice);
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage captureScreen(Robot robot, Rectangle screenRect) {
        return robot.createScreenCapture(screenRect);
    }

    public static File captureScreen(Rectangle screenRect, File outFile) {
        ImgUtil.write(RobotUtil.captureScreen(screenRect), outFile);
        return outFile;
    }

    public static File captureScreen(int x1, int y1, int x2, int y2, File outFile) {
        Rectangle rectangle = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        ImgUtil.write(RobotUtil.captureScreen(rectangle), outFile);
        return outFile;
    }

    public static void delay() {
        if (delay > 0) {
            ROBOT.delay(delay);
        }
    }

    public static Robot getRobot(Integer i) {
        GraphicsDevice screenDevice = RobotUtil.getScreenDevice(i);
        return RobotUtil.getRobot(screenDevice);
    }

    public static GraphicsDevice getScreenDevice(Integer i) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] screenDevices = ge.getScreenDevices();
        if (ArrayUtils.isEmpty((Object[])screenDevices)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u5c4f\u5e55\u8bbe\u5907");
        }
        return screenDevices[i];
    }

    static {
        try {
            ROBOT = new Robot();
        }
        catch (AWTException e) {
            throw new UtilException(e);
        }
    }
}

