/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.swing;

import com.luna.common.text.StringTools;
import java.awt.Desktop;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;

public class DesktopUtil {
    public static List<GraphicsDevice> getScreenDevices() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        return Arrays.asList(gs);
    }

    public static Desktop getDsktop() {
        return Desktop.getDesktop();
    }

    public static void browse(String url) {
        try {
            DesktopUtil.browse(new URI(StringTools.trim((String)url)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void browse(URI uri) {
        Desktop dsktop = DesktopUtil.getDsktop();
        try {
            dsktop.browse(uri);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void open(File file) {
        Desktop dsktop = DesktopUtil.getDsktop();
        try {
            dsktop.open(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void edit(File file) {
        Desktop dsktop = DesktopUtil.getDsktop();
        try {
            dsktop.edit(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void print(File file) {
        Desktop dsktop = DesktopUtil.getDsktop();
        try {
            dsktop.print(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void mail(String mailAddress) {
        Desktop dsktop = DesktopUtil.getDsktop();
        try {
            URI uri = new URI(StringTools.trim((String)mailAddress));
            dsktop.mail(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

