/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.sensitive;

import com.luna.common.sensitive.Convert;
import com.luna.common.sensitive.FieldConfig;
import com.luna.common.sensitive.FieldType;
import com.luna.common.sensitive.Sensitive;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensitiveUtil<T> {
    private static final Pattern PATTERN = Pattern.compile("((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17([1-3]|[5-9]))|(18[0,5-9]))\\d{8}");
    private final T data;
    private final Map<FieldType, FieldConfig> config;

    private SensitiveUtil(T data, Map<FieldType, FieldConfig> config) {
        this.data = data;
        this.config = config;
    }

    public static <T> void apply(T data, Map<FieldType, FieldConfig> config) {
        new SensitiveUtil<T>(data, config).convert();
    }

    public static <T> void apply(T data) {
        new SensitiveUtil<T>(data, new HashMap<FieldType, FieldConfig>()).convert();
    }

    public static <T> void parse(T data, Map<FieldType, FieldConfig> config, Function<String, FieldType> fieldTypeFunction) {
        WithoutAnnotationUtil.create(data, config, fieldTypeFunction).convert();
    }

    public static <T> void parse(T data, Map<FieldType, FieldConfig> config) {
        WithoutAnnotationUtil.create(data, config, FieldType::parseFieldType).convert();
    }

    public static <T> void parse(T data, Function<String, FieldType> fieldTypeFunction) {
        WithoutAnnotationUtil.create(data, new HashMap<FieldType, FieldConfig>(), fieldTypeFunction).convert();
    }

    public static <T> void parse(T data) {
        WithoutAnnotationUtil.create(data, new HashMap<FieldType, FieldConfig>(), FieldType::parseFieldType).convert();
    }

    public static String regexReplaceTelPhone(String string) {
        Matcher matcher = PATTERN.matcher(string);
        String temp = string;
        while (matcher.find()) {
            String group = matcher.group();
            temp = temp.replace(group, Convert.mobile(group));
        }
        return temp;
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        String data = "{\"addTime\":1676269173000,\"attributes\":{\"cnl\":\"xiaochengxu\",\"1ys_c_fans_order\":\"y\",\"v_a_id\":\"extWxBuye\",\"1ns_c_must_online_pay_channel\":\"y\",\"sub_cnl\":\"thirdApp\",\"1ys_c_mall_order\":\"y\",\"1ys_c_fans_biztype\":\"1\",\"c_reward_type\":\"1\",\"1ys_c_mall_new_order\":\"y\",\"source\":\"CART\",\"c_mini_program_scene\":\"0\",\"c_ip\":\"112.3.205.244\",\"c_tax_type\":\"1547154012384894978\",\"page_cnl\":\"shop_menu_cart\",\"1yl_c_createid\":\"30314065413391\",\"c_uid\":\"1743008060\",\"1ys_c_settle_biz_flag\":\"fans\",\"1ys_c_fans1_id\":\"1580171905\",\"1ys_c_fans1_type\":\"1\",\"plat\":\"android\",\"1ns_c_support_express_insurance\":\"y\"},\"buyerAddress\":\"\u6c5f\u82cf\u7701 \u82cf\u5dde\u5e02 \u76f8\u57ce\u533a \u5143\u548c\u8857\u9053 \u9b45\u529b\u82b1\u56ed9-510\",\"buyerId\":\"1743008060\",\"buyerInfo\":{\"city\":\"\u82cf\u5dde\",\"province\":\"\u6c5f\u82cf\"},\"buyerName\":\"\u5e84\u5e84\",\"buyerTelephone\":\"18816293764\",\"encryptOrderId\":\"9zp3a9lNTgVI1SF%2F0qznOg%3D%3D\",\"expressFee\":0,\"expressType\":0,\"extend\":\",,,,,,,,,,,,,,,,,,,cnl:xiaochengxu;1ys_c_fans_order:y;v_a_id:extWxBuye;1ns_c_must_online_pay_channel:y;sub_cnl:thirdApp;1ys_c_mall_order:y;1ys_c_fans_biztype:1;c_reward_type:1;1ys_c_mall_new_order:y;source:CART;c_mini_program_scene:0;c_ip:112.3.205.244;c_tax_type:1547154012384894978;page_cnl:shop_menu_cart;1yl_c_createid:30314065413391;c_uid:1743008060;1ys_c_settle_biz_flag:fans;1ys_c_fans1_id:1580171905;1ys_c_fans1_type:1;plat:android;1ns_c_support_express_insurance:y;,,,,,,,,,,\",\"fSellerId\":0,\"flag\":2,\"flagBin\":536870920,\"flagBinL\":2216739995656,\"fxFee\":0,\"imgHead\":\"https://si.geilicdn.com/pcitem1575265323-0d780000017e8664972d0a20e2c5_800_800.jpg?w=110&h=110&cp=1\",\"isShow\":1,\"orderCommissionDTOList\":[{\"bizType\":3,\"extend\":\"{\\\"commissionType\\\":1,\\\"delayMinutes\\\":21600,\\\"rate\\\":\\\"30.0\\\",\\\"reqNo\\\":\\\"712207271183\\\",\\\"roleType\\\":\\\"5\\\",\\\"taxRate\\\":\\\"0.069\\\"}\",\"extendObject\":{\"commissionType\":1,\"delayMinutes\":21600,\"rate\":\"30.0\",\"reqNo\":\"712207271183\",\"taxRate\":\"0.069\"},\"fee\":747,\"feeType\":30,\"feeTypeDesc\":\"\u5546\u57ce\u63a8\u5e7f\u5458\u4f63\u91d1\",\"fundAccount\":\"334544046\",\"gmtCreate\":1676269174000,\"gmtUpdate\":1676269191000,\"id\":50334,\"orderId\":820539069129999,\"refundFee\":0,\"status\":1,\"subOrderId\":630162500969743,\"userId\":\"1580171905\"},{\"bizType\":3,\"extend\":\"{\\\"commissionType\\\":1,\\\"delayMinutes\\\":21600,\\\"rate\\\":\\\"30.0\\\",\\\"reqNo\\\":\\\"712207271183\\\",\\\"roleType\\\":\\\"5\\\",\\\"taxRate\\\":\\\"0.069\\\"}\",\"extendObject\":{\"commissionType\":1,\"delayMinutes\":21600,\"rate\":\"30.0\",\"reqNo\":\"712207271183\",\"taxRate\":\"0.069\"},\"fee\":1797,\"feeType\":30,\"feeTypeDesc\":\"\u5546\u57ce\u63a8\u5e7f\u5458\u4f63\u91d1\",\"fundAccount\":\"334544046\",\"gmtCreate\":1676269174000,\"gmtUpdate\":1676269191000,\"id\":50333,\"orderId\":820539069129999,\"refundFee\":0,\"status\":1,\"subOrderId\":630170103153935,\"userId\":\"1580171905\"},{\"bizType\":3,\"extend\":\"{\\\"commissionType\\\":1,\\\"delayMinutes\\\":21600,\\\"rate\\\":\\\"30.0\\\",\\\"reqNo\\\":\\\"712207271183\\\",\\\"roleType\\\":\\\"5\\\",\\\"taxRate\\\":\\\"0.069\\\"}\",\"extendObject\":{\"commissionType\":1,\"delayMinutes\":21600,\"rate\":\"30.0\",\"reqNo\":\"712207271183\",\"taxRate\":\"0.069\"},\"fee\":897,\"feeType\":30,\"feeTypeDesc\":\"\u5546\u57ce\u63a8\u5e7f\u5458\u4f63\u91d1\",\"fundAccount\":\"334544046\",\"gmtCreate\":1676269174000,\"gmtUpdate\":1676269191000,\"id\":50335,\"orderId\":820539069129999,\"refundFee\":0,\"status\":1,\"subOrderId\":630170103170319,\"userId\":\"1580171905\"}],\"orderFlagInfo\":[\"\u7c89\u4e1d\u63a8\u5e7f\u8ba2\u5355\"],\"orderId\":820539069129999,\"orderSource\":0,\"orderStatus\":20,\"payTime\":1676269190000,\"refundStatus\":0,\"sellerId\":1871859650,\"sellerInfoDTOList\":[{\"id\":1871859650,\"type\":101}],\"sellerInfos\":[{\"id\":1871859650,\"type\":101}],\"subOrderInfoDTOs\":[{\"addTime\":1676269173000,\"attributes\":{\"orig_price\":\"59.9\",\"merchant_code\":\"01\",\"weight_orig_price\":\"59.9\",\"1ns_c_fans1_rate\":\"30.0\",\"1ns_c_fans1_money\":\"1797\",\"1ys_c_category_id\":\"123216051\",\"1yl_sx_cp_flag\":\"0\",\"1ns_c_member_price_bonus_type\":\"1\",\"stock_id\":\"1638259693847981\"},\"buyerId\":\"1743008060\",\"cpsFee\":0,\"id\":630170103153935,\"imgHead\":\"pcitem1575265323-0d780000017e8664972d0a20e2c5_800_800.jpg\",\"itemId\":4405257645,\"itemSkuId\":0,\"itemTitle\":\"\u90bb\u829d\u827e\u7078\u5b9d \u827e\u7ed2\u6696\u5bab\u62a4\u8170\u70ed\u6577\u888b\u6e29\u7078\u7406\u7597 \u591a\u6863\u63a7\u6e29 \u5bb6\u7528\u529e\u516c\u53ef\u7528 \u65e0\u70df\u827e\u7078\u5305\u90ae\",\"orderId\":820539069129999,\"price\":5990,\"quantity\":1,\"refundStatus\":0,\"status\":0,\"totalPrice\":5990},{\"addTime\":1676269173000,\"attributes\":{\"orig_price\":\"24.9\",\"weight_orig_price\":\"24.9\",\"1ns_c_fans1_rate\":\"30.0\",\"1ns_c_fans1_money\":\"747\",\"1ys_c_category_id\":\"2102\",\"1yl_sx_cp_flag\":\"0\",\"1ns_c_member_price_bonus_type\":\"1\",\"stock_id\":\"1678371857106823\"},\"buyerId\":\"1743008060\",\"cpsFee\":0,\"id\":630162500969743,\"imgHead\":\"pcitem901649049667-3083000001850faa612f0a813276_800_800.jpg\",\"itemId\":4441106311,\"itemSkuId\":49581748508,\"itemSkuTitle\":\"\u827e\u8349\u8db3\u8d34\uff08\u5305\u88c5\u968f\u673a\u53d1\uff09\",\"itemTitle\":\"\u90bb\u829d\u827e\u8349\u8db3\u8d34  \u8db3\u90e8\u62a4\u7406 \u517b\u751f\u8db3\u8d34 \u5305\u90ae\uff0850\u8d34/\u76d2\uff09\",\"orderId\":820539069129999,\"price\":2490,\"quantity\":1,\"refundStatus\":0,\"status\":0,\"totalPrice\":2490},{\"addTime\":1676269173000,\"attributes\":{\"orig_price\":\"29.9\",\"weight_orig_price\":\"29.9\",\"1ns_c_fans1_rate\":\"30.0\",\"1ns_c_fans1_money\":\"897\",\"1ys_c_category_id\":\"2102\",\"1yl_sx_cp_flag\":\"0\",\"1ns_c_member_price_bonus_type\":\"1\",\"stock_id\":\"1657608251737024\"},\"buyerId\":\"1743008060\",\"cpsFee\":0,\"id\":630170103170319,\"imgHead\":\"pcitem901649049667-1e0f000001850f63eff30a231418_800_800.jpg\",\"itemId\":4441908160,\"itemSkuId\":0,\"itemTitle\":\"\u90bb\u829d\u827e\u7ed2\u809a\u8110\u8d34  \u6696\u5bab\u5065\u4f53 \u61d2\u4eba\u4fdd\u5065\u795e\u5668 \u5305\u90ae\uff0830\u7c92\uff0c30\u5f20\u8110\u8d34\uff09\",\"orderId\":820539069129999,\"price\":2990,\"quantity\":1,\"refundStatus\":0,\"status\":0,\"totalPrice\":2990}],\"totalFee\":0,\"totalPrice\":11470,\"unPayCloseTime\":1676441973000,\"updateTime\":1676269191000}";
        for (int i = 0; i < 1; ++i) {
            SensitiveUtil.regexReplaceTelPhone(data);
        }
        System.out.println(System.currentTimeMillis() - startTime);
    }

    public void convert() {
        try {
            this.convert(this.data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void convert(T data) throws Exception {
        if (data == null) {
            return;
        }
        if (data instanceof Collection) {
            Collection collection = (Collection)data;
            if (collection != null && !collection.isEmpty()) {
                for (Object item : collection) {
                    this.convert(item);
                }
            }
        } else if (data instanceof Map) {
            Map map = (Map)data;
            if (map != null && !map.isEmpty()) {
                for (Object key : map.keySet()) {
                    this.convert(map.get(key));
                }
            }
        } else {
            this.convertObject(data);
        }
    }

    private <T> void convertObject(T data) throws Exception {
        Field[] fields;
        if (data == null) {
            return;
        }
        Class<?> clazz = data.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Object obj;
            DataMethods methods = null;
            if (field.getType().isPrimitive()) continue;
            if (field.getType().equals(String.class)) {
                Sensitive fieldType = field.getAnnotation(Sensitive.class);
                if (fieldType == null || (methods = DataMethods.init(data, field)).isNull()) continue;
                String value = (String)methods.getMethod.invoke(data, new Object[0]);
                if (value != null && !value.isEmpty() && !value.trim().equals("")) {
                    FieldType type = fieldType.value();
                    methods.setMethod.invoke(data, type.convert(value, this.config.get((Object)type)));
                }
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection collection;
                methods = DataMethods.init(data, field);
                if (methods.isNull() || (collection = (Collection)methods.getMethod.invoke(data, new Object[0])) == null || collection.isEmpty()) continue;
                for (Object item : collection) {
                    this.convert(item);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                Map map;
                methods = DataMethods.init(data, field);
                if (methods.isNull() || (map = (Map)methods.getMethod.invoke(data, new Object[0])) == null || map.isEmpty()) continue;
                for (Object key : map.keySet()) {
                    this.convert(map.get(key));
                }
                continue;
            }
            if (field.getType().getName().startsWith("java.") || (methods = DataMethods.init(data, field)).isNull() || null == (obj = methods.getMethod.invoke(data, new Object[0]))) continue;
            this.convertObject(obj);
        }
    }

    public static class WithoutAnnotationUtil<T> {
        private final T data;
        private final Map<FieldType, FieldConfig> config;
        private final Function<String, FieldType> fieldTypeFunction;

        private WithoutAnnotationUtil(T data, Map<FieldType, FieldConfig> config, Function<String, FieldType> fieldTypeFunction) {
            this.data = data;
            this.fieldTypeFunction = fieldTypeFunction;
            this.config = config;
        }

        public static <T> WithoutAnnotationUtil<T> create(T data, Map<FieldType, FieldConfig> config, Function<String, FieldType> fieldTypeFunction) {
            return new WithoutAnnotationUtil<T>(data, config, fieldTypeFunction);
        }

        public void convert() {
            try {
                this.convert(this.data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private <T> void convert(T data) throws Exception {
            if (data == null) {
                return;
            }
            if (data instanceof Collection) {
                Collection collection = (Collection)data;
                if (!collection.isEmpty()) {
                    for (Object item : collection) {
                        this.convert(item);
                    }
                }
            } else if (data instanceof Map) {
                Map map = (Map)data;
                if (!map.isEmpty()) {
                    for (Object key : map.keySet()) {
                        Object value = map.get(key);
                        if (key instanceof String && value instanceof String) {
                            FieldType fieldType = this.fieldTypeFunction.apply((String)key);
                            if (fieldType == null) continue;
                            map.put(key, fieldType.convert((String)value, this.config.get((Object)fieldType)));
                            continue;
                        }
                        this.convert(map.get(key));
                    }
                }
            } else {
                this.convertObject(data);
            }
        }

        private <T> void convertObject(T data) throws Exception {
            Method[] methods;
            Class<?> clazz = data.getClass();
            for (Method method : methods = clazz.getMethods()) {
                Object obj;
                method.setAccessible(true);
                boolean isZeroParameter = method.getParameterCount() == 0;
                boolean isGetMethod = method.getName().startsWith("get");
                boolean isReturnVoid = method.getReturnType().getName().equals("void");
                boolean isPrimitiveReturn = method.getReturnType().isPrimitive();
                if (!isZeroParameter || !isGetMethod || isReturnVoid || isPrimitiveReturn) continue;
                if (method.getReturnType().equals(String.class)) {
                    String value;
                    FieldType fieldType = this.fieldTypeFunction.apply(method.getName().replace("get", "").toLowerCase());
                    if (fieldType == null || (value = (String)method.invoke(data, new Object[0])) == null || value.isEmpty()) continue;
                    Method setMethod = clazz.getMethod(method.getName().replace("get", "set"), String.class);
                    setMethod.invoke(data, fieldType.convert(value, this.config.get((Object)fieldType)));
                    continue;
                }
                if (Collection.class.isAssignableFrom(method.getReturnType())) {
                    Collection collection = (Collection)method.invoke(data, new Object[0]);
                    if (collection == null || collection.isEmpty()) continue;
                    for (Object item : collection) {
                        this.convert(item);
                    }
                    continue;
                }
                if (Map.class.isAssignableFrom(method.getReturnType())) {
                    Map map = (Map)method.invoke(data, new Object[0]);
                    if (map == null || map.isEmpty()) continue;
                    for (Object key : map.keySet()) {
                        Object value = map.get(key);
                        if (key instanceof String && value instanceof String) {
                            FieldType fieldType = this.fieldTypeFunction.apply((String)key);
                            if (fieldType != null) {
                                map.put(key, fieldType.convert((String)value, this.config.get((Object)fieldType)));
                            }
                        } else {
                            this.convert(map.get(key));
                        }
                        this.convert(map.get(key));
                    }
                    continue;
                }
                if (method.getReturnType().getPackage() == null || method.getReturnType().getPackage().getName().startsWith("java.") || null == (obj = method.invoke(data, new Object[0]))) continue;
                this.convertObject(obj);
            }
        }
    }

    private static class DataMethods {
        Method getMethod;
        Method setMethod;

        private DataMethods() {
        }

        public static <T> DataMethods init(T data, Field field) {
            DataMethods dataMethods = new DataMethods();
            for (Method method : data.getClass().getMethods()) {
                method.setAccessible(true);
                if (!method.getName().startsWith("get") && !method.getName().startsWith("set")) continue;
                if (method.getName().equalsIgnoreCase("get" + field.getName()) && method.getParameterCount() == 0) {
                    dataMethods.getMethod = method;
                }
                if (!method.getName().equalsIgnoreCase("set" + field.getName()) || method.getParameterCount() != 1) continue;
                dataMethods.setMethod = method;
            }
            return dataMethods;
        }

        public boolean isNull() {
            return this.getMethod == null || this.setMethod == null;
        }
    }
}

