/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.regex;

import com.luna.common.text.StringTools;

public class DesensitizedUtil {
    public static String desensitized(CharSequence str, DesensitizedType desensitizedType) {
        if (StringTools.isBlank((CharSequence)str)) {
            return "";
        }
        String newStr = String.valueOf(str);
        switch (desensitizedType) {
            case USER_ID: {
                newStr = String.valueOf(DesensitizedUtil.userId());
                break;
            }
            case CHINESE_NAME: {
                newStr = DesensitizedUtil.chineseName(String.valueOf(str));
                break;
            }
            case ID_CARD: {
                newStr = DesensitizedUtil.idCardNum(String.valueOf(str), 1, 2);
                break;
            }
            case FIXED_PHONE: {
                newStr = DesensitizedUtil.fixedPhone(String.valueOf(str));
                break;
            }
            case MOBILE_PHONE: {
                newStr = DesensitizedUtil.mobilePhone(String.valueOf(str));
                break;
            }
            case ADDRESS: {
                newStr = DesensitizedUtil.address(String.valueOf(str), 8);
                break;
            }
            case EMAIL: {
                newStr = DesensitizedUtil.email(String.valueOf(str));
                break;
            }
            case PASSWORD: {
                newStr = DesensitizedUtil.password(String.valueOf(str));
                break;
            }
            case CAR_LICENSE: {
                newStr = DesensitizedUtil.carLicense(String.valueOf(str));
                break;
            }
            case BANK_CARD: {
                newStr = DesensitizedUtil.bankCard(String.valueOf(str));
                break;
            }
        }
        return newStr;
    }

    public static Long userId() {
        return 0L;
    }

    public static String chineseName(String fullName) {
        if (StringTools.isBlank((CharSequence)fullName)) {
            return "";
        }
        return StringTools.hide(fullName, 1, fullName.length());
    }

    public static String idCardNum(String idCardNum, int front, int end) {
        if (StringTools.isBlank((CharSequence)idCardNum)) {
            return "";
        }
        if (front + end > idCardNum.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return StringTools.hide(idCardNum, front, idCardNum.length() - end);
    }

    public static String fixedPhone(String num) {
        if (StringTools.isBlank((CharSequence)num)) {
            return "";
        }
        return StringTools.hide(num, 4, num.length() - 2);
    }

    public static String mobilePhone(String num) {
        if (StringTools.isBlank((CharSequence)num)) {
            return "";
        }
        return StringTools.hide(num, 3, num.length() - 4);
    }

    public static String address(String address, int sensitiveSize) {
        if (StringTools.isBlank((CharSequence)address)) {
            return "";
        }
        int length = address.length();
        return StringTools.hide(address, length - sensitiveSize, length);
    }

    public static String email(String email) {
        if (StringTools.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringTools.indexOf((CharSequence)email, (int)64);
        if (index <= 1) {
            return email;
        }
        return StringTools.hide(email, 1, index);
    }

    public static String password(String password) {
        if (StringTools.isBlank((CharSequence)password)) {
            return "";
        }
        return StringTools.repeat((char)'*', (int)password.length());
    }

    public static String carLicense(String carLicense) {
        if (StringTools.isBlank((CharSequence)carLicense)) {
            return "";
        }
        if (carLicense.length() == 7) {
            carLicense = StringTools.hide(carLicense, 3, 6);
        } else if (carLicense.length() == 8) {
            carLicense = StringTools.hide(carLicense, 3, 7);
        }
        return carLicense;
    }

    public static String bankCard(String bankCardNo) {
        if (StringTools.isBlank((CharSequence)bankCardNo)) {
            return bankCardNo;
        }
        if ((bankCardNo = StringTools.trim((String)bankCardNo)).length() < 9) {
            return bankCardNo;
        }
        int length = bankCardNo.length();
        int midLength = length - 8;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append('*');
        }
        buf.append(' ').append(bankCardNo, length - 4, length);
        return buf.toString();
    }

    public static enum DesensitizedType {
        USER_ID,
        CHINESE_NAME,
        ID_CARD,
        FIXED_PHONE,
        MOBILE_PHONE,
        ADDRESS,
        EMAIL,
        PASSWORD,
        CAR_LICENSE,
        BANK_CARD;

    }
}

