/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.page;

import java.io.Serializable;
import java.util.List;

public class Page<T>
implements Serializable {
    public int offsize = 2;
    private long currentpage;
    private long total;
    private int size;
    private int next;
    private List<?> list;
    private int last;
    private int lpage;
    private int rpage;
    private long start;

    public Page() {
    }

    public Page(long total, int currentpage, int pagesize, int offsize) {
        this.offsize = offsize;
        this.initPage(total, currentpage, pagesize);
    }

    public Page(long total, int currentpage, int pagesize) {
        this.initPage(total, currentpage, pagesize);
    }

    public void setCurrentpage(long currentpage, long total, long pagesize) {
        int totalPages;
        long pagecount = total / pagesize;
        this.last = totalPages = (int)(total % pagesize == 0L ? total / pagesize : total / pagesize + 1L);
        this.currentpage = currentpage > (long)totalPages ? (long)totalPages : currentpage;
        this.start = (this.currentpage - 1L) * pagesize;
    }

    public long getUpper() {
        return this.currentpage > 1L ? this.currentpage - 1L : this.currentpage;
    }

    public void initPage(long total, int currentpage, int pagesize) {
        this.total = total;
        this.size = pagesize;
        this.setCurrentpage(currentpage, total, pagesize);
        int leftcount = this.offsize;
        int rightcount = this.offsize;
        this.lpage = currentpage;
        this.rpage = currentpage;
        this.lpage = currentpage - leftcount;
        this.rpage = currentpage + rightcount;
        int topdiv = this.last - this.rpage;
        this.lpage = topdiv < 0 ? this.lpage + topdiv : this.lpage;
        this.rpage = this.lpage <= 0 ? this.rpage + this.lpage * -1 + 1 : this.rpage;
        this.lpage = this.lpage <= 0 ? 1 : this.lpage;
        this.rpage = this.rpage > this.last ? this.last : this.rpage;
    }

    public long getNext() {
        return this.currentpage < (long)this.last ? this.currentpage + 1L : (long)this.last;
    }

    public void setNext(int next) {
        this.next = next;
    }

    public long getCurrentpage() {
        return this.currentpage;
    }

    public void setCurrentpage(long currentpage) {
        this.currentpage = currentpage;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getLast() {
        return this.last;
    }

    public void setLast(int last) {
        this.last = (int)(this.total % (long)this.size == 0L ? this.total / (long)this.size : this.total / (long)this.size + 1L);
    }

    public long getLpage() {
        return this.lpage;
    }

    public void setLpage(int lpage) {
        this.lpage = lpage;
    }

    public long getRpage() {
        return this.rpage;
    }

    public void setRpage(int rpage) {
        this.rpage = rpage;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public List<?> getList() {
        return this.list;
    }

    public void setList(List<?> list) {
        this.list = list;
    }
}

