/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.os;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;

public class SystemInfoUtil {
    private static final SystemInfo SI = new SystemInfo();
    private static InetAddress localHost = null;

    public static List<OSProcess> getProcesses() {
        return SI.getOperatingSystem().getProcesses();
    }

    public static InetAddress getLocalHost() {
        try {
            if (localHost == null) {
                localHost = InetAddress.getLocalHost();
            }
            return localHost;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static String getIP() {
        return SystemInfoUtil.getLocalHost().getHostAddress();
    }

    public static String getIpv4() {
        return Objects.requireNonNull(SystemInfoUtil.getAllIpv4()).stream().findFirst().orElse(null);
    }

    public static List<String> getAllIpv4() {
        List<String> allIpAddress = SystemInfoUtil.getAllIpAddress();
        if (CollectionUtils.isEmpty(allIpAddress)) {
            return new ArrayList<String>();
        }
        return allIpAddress.stream().filter(e -> !e.contains(":")).collect(Collectors.toList());
    }

    public static String getNoLoopbackIP() {
        return SystemInfoUtil.getAddress().getHostAddress();
    }

    public static List<String> getAllIpAddress() {
        try {
            return SystemInfoUtil.getInetAddress(false).stream().map(InetAddress::getHostAddress).collect(Collectors.toList());
        }
        catch (SocketException e) {
            return new ArrayList<String>();
        }
    }

    public static InetAddress getAddress() {
        try {
            return SystemInfoUtil.getInetAddress(true).stream().findFirst().orElse(SystemInfoUtil.getLocalHost());
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws SocketException {
        System.out.println(SystemInfoUtil.getNoLoopbackIP());
        System.out.println(SystemInfoUtil.getInetAddress(false));
        System.out.println(SystemInfoUtil.getMacList());
        System.out.println(SystemInfoUtil.getAllIpAddress());
        System.out.println(SystemInfoUtil.getAddress());
    }

    public static String getHostName() {
        return SystemInfoUtil.getLocalHost().getHostName();
    }

    public static String getMac(InetAddress addr) {
        try {
            NetworkInterface byInetAddress = NetworkInterface.getByInetAddress(addr);
            byte[] hardwareAddress = byInetAddress.getHardwareAddress();
            return SystemInfoUtil.getMacFromBytes(hardwareAddress);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMac() {
        return SystemInfoUtil.getMac(SystemInfoUtil.getLocalHost());
    }

    public static List<String> getMacList() {
        try {
            ArrayList macList = Lists.newArrayList();
            List<InetAddress> inetAddress = SystemInfoUtil.getInetAddress(false);
            for (InetAddress address : inetAddress) {
                String mac = SystemInfoUtil.getMac(address);
                if (!StringUtils.isNotBlank((CharSequence)mac)) continue;
                macList.add(mac);
            }
            return macList;
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRandomMac() {
        List<String> macList = SystemInfoUtil.getMacList();
        return macList.get(RandomUtils.nextInt((int)0, (int)(macList.size() - 1)));
    }

    public static List<InetAddress> getInetAddress(Boolean filterLoopback) throws SocketException {
        ArrayList<InetAddress> ipList = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (filterLoopback.booleanValue() && (address.isLinkLocalAddress() || address.isLoopbackAddress() || address.isMulticastAddress())) continue;
                ipList.add(address);
            }
        }
        return ipList;
    }

    public static String getSystemName() {
        Properties sysProperty = System.getProperties();
        return sysProperty.getProperty("os.name");
    }

    private static String getMacFromBytes(byte[] bytes) {
        StringBuffer mac = new StringBuffer();
        boolean first = false;
        for (byte b : bytes) {
            if (first) {
                mac.append("-");
            }
            byte currentByte = (byte)((b & 0xF0) >> 4);
            mac.append(Integer.toHexString(currentByte));
            currentByte = (byte)(b & 0xF);
            mac.append(Integer.toHexString(currentByte));
            first = true;
        }
        return mac.toString().toUpperCase();
    }

    public String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }
}

