/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.os;

import com.luna.common.exception.BaseException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;

public class ProcessUtils {
    private static final SystemInfo SI = new SystemInfo();

    public static List<OSProcess> getProcesses() {
        return SI.getOperatingSystem().getProcesses();
    }

    public static List<OSProcess> getProcessesByFileName(String fileName) {
        String fileNameWithoutExtension = ProcessUtils.removeExtension(fileName);
        List<OSProcess> osProcessList = ProcessUtils.getProcesses();
        List<OSProcess> result = osProcessList.stream().filter(osProcess -> StringUtils.equals((CharSequence)ProcessUtils.removeExtension(osProcess.getName()), (CharSequence)fileNameWithoutExtension)).collect(Collectors.toList());
        return result;
    }

    public static List<OSProcess> getProcessesByPath(String path) {
        List<OSProcess> osProcessList = ProcessUtils.getProcesses();
        List<OSProcess> result = osProcessList.stream().filter(osProcess -> ProcessUtils.formatPath(osProcess.getPath()).startsWith(ProcessUtils.formatPath(path))).collect(Collectors.toList());
        return result;
    }

    public static String formatPath(String path) {
        return path.replace("\\", "/");
    }

    public static String removeExtension(String filename) {
        int idx = filename.lastIndexOf(".");
        if (idx == -1) {
            return filename;
        }
        return filename.substring(0, idx);
    }

    public static void killProcessGracefully(Process process, String fileName) {
        boolean hasTerminated = false;
        process.destroy();
        try {
            hasTerminated = process.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (hasTerminated) {
            return;
        }
        process.destroyForcibly();
        try {
            hasTerminated = process.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (hasTerminated) {
            return;
        }
        ProcessUtils.osKill(fileName);
        try {
            hasTerminated = process.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!hasTerminated) {
            throw new BaseException(9999, "system error");
        }
    }

    public static void osKill(String fileName) {
        List<OSProcess> osProcessList = ProcessUtils.getProcessesByFileName(fileName);
        osProcessList.forEach(osProcess -> ProcessUtils.osKill(osProcess.getProcessID()));
    }

    public static void osKill(int processId) {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                Runtime.getRuntime().exec("taskkill /F /T /PID " + processId);
                return;
            }
            if (SystemUtils.IS_OS_LINUX) {
                Runtime.getRuntime().exec("kill -9 " + processId);
                return;
            }
            if (SystemUtils.IS_OS_MAC) {
                Runtime.getRuntime().exec("kill -9 " + processId);
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new BaseException(9999, "\u5e73\u53f0\u4e0d\u652f\u6301");
    }

    public static void getProcessesAndKill(String path) {
        List<OSProcess> osProcessList = ProcessUtils.getProcessesByPath(path);
        osProcessList.forEach(osProcess -> ProcessUtils.osKill(osProcess.getProcessID()));
    }
}

