/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.os;

import com.luna.common.os.EPlatform;

public class OSinfo {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final OSinfo INSTANCE = new OSinfo();
    private EPlatform platform;

    private OSinfo() {
    }

    public static boolean isLinux() {
        return OS.contains("linux");
    }

    public static boolean isMacOS() {
        return OS.contains("mac") && OS.contains("os") && !OS.contains("x");
    }

    public static boolean isMacOSX() {
        return OS.contains("mac") && OS.contains("os") && OS.contains("x");
    }

    public static boolean isWindows() {
        return OS.contains("windows");
    }

    public static boolean isOS2() {
        return OS.contains("os/2");
    }

    public static boolean isSolaris() {
        return OS.contains("solaris");
    }

    public static boolean isSunOS() {
        return OS.contains("sunos");
    }

    public static boolean isMPEiX() {
        return OS.contains("mpe/ix");
    }

    public static boolean isHPUX() {
        return OS.contains("hp-ux");
    }

    public static boolean isAix() {
        return OS.contains("aix");
    }

    public static boolean isOS390() {
        return OS.contains("os/390");
    }

    public static boolean isFreeBSD() {
        return OS.contains("freebsd");
    }

    public static boolean isIrix() {
        return OS.contains("irix");
    }

    public static boolean isDigitalUnix() {
        return OS.contains("digital") && OS.contains("unix");
    }

    public static boolean isNetWare() {
        return OS.contains("netware");
    }

    public static boolean isOSF1() {
        return OS.contains("osf1");
    }

    public static boolean isOpenVMS() {
        return OS.contains("openvms");
    }

    public static EPlatform getOSname() {
        OSinfo.INSTANCE.platform = OSinfo.isAix() ? EPlatform.AIX : (OSinfo.isDigitalUnix() ? EPlatform.Digital_Unix : (OSinfo.isFreeBSD() ? EPlatform.FreeBSD : (OSinfo.isHPUX() ? EPlatform.HP_UX : (OSinfo.isIrix() ? EPlatform.Irix : (OSinfo.isLinux() ? EPlatform.Linux : (OSinfo.isMacOS() ? EPlatform.Mac_OS : (OSinfo.isMacOSX() ? EPlatform.Mac_OS_X : (OSinfo.isMPEiX() ? EPlatform.MPEiX : (OSinfo.isNetWare() ? EPlatform.NetWare_411 : (OSinfo.isOpenVMS() ? EPlatform.OpenVMS : (OSinfo.isOS2() ? EPlatform.OS2 : (OSinfo.isOS390() ? EPlatform.OS390 : (OSinfo.isOSF1() ? EPlatform.OSF1 : (OSinfo.isSolaris() ? EPlatform.Solaris : (OSinfo.isSunOS() ? EPlatform.SunOS : (OSinfo.isWindows() ? EPlatform.Windows : EPlatform.Others))))))))))))))));
        return OSinfo.INSTANCE.platform;
    }
}

