/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net.sse;

import com.google.common.base.Splitter;
import com.luna.common.io.IoUtil;
import com.luna.common.net.sse.Event;
import com.luna.common.text.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;

public class SseEntity
extends AbstractHttpEntity {
    private final StringBuilder allEvent = new StringBuilder();
    private BlockingQueue<Event> events = new ArrayBlockingQueue<Event>(100);
    private StringBuilder currentEvent = new StringBuilder();
    private int newLineCount = 0;
    private String lastEventId;

    public SseEntity(ContentType contentType) {
        super(contentType, CharsetUtil.defaultCharsetName());
    }

    public StringBuilder getAllEvent() {
        return this.allEvent;
    }

    public void pushBuffer(CharBuffer buf, boolean endOfStream) {
        while (buf.hasRemaining()) {
            this.processChar(buf.get());
        }
    }

    private void processChar(char nextChar) {
        this.newLineCount = nextChar == '\n' ? ++this.newLineCount : 0;
        if (this.newLineCount > 1) {
            this.processCurrentEvent();
            this.currentEvent = new StringBuilder();
        } else {
            this.currentEvent.append(nextChar);
        }
    }

    private void processCurrentEvent() {
        String rawEvent = this.currentEvent.toString();
        String id = "";
        String event = "";
        int retry = 0;
        StringBuilder data = new StringBuilder();
        List list = Splitter.on((String)"\n").splitToList((CharSequence)rawEvent);
        for (String[] lineTokens : list.stream().map(s -> s.split(":", 2)).collect(Collectors.toList())) {
            switch (lineTokens[0]) {
                case "id": {
                    id = lineTokens[1].trim();
                    break;
                }
                case "event": {
                    event = lineTokens[1].trim();
                    break;
                }
                case "retry": {
                    retry = Integer.parseInt(lineTokens[1].trim());
                    break;
                }
                case "data": {
                    data.append(lineTokens[1].trim());
                }
            }
        }
        this.events.offer(new Event(id, event, data.toString(), retry));
        this.currentEvent = new StringBuilder();
        this.allEvent.append(rawEvent);
        this.newLineCount = 0;
        this.lastEventId = id;
    }

    public BlockingQueue<Event> getEvents() {
        return this.events;
    }

    public void setEvents(BlockingQueue<Event> events) {
        this.events = events;
    }

    public boolean hasMoreEvents() {
        return this.events.size() > 0;
    }

    public String getLastEventId() {
        return this.lastEventId;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.allEvent.length();
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return IoUtil.toStream(this.allEvent.toString(), Charset.defaultCharset());
    }

    public void writeTo(OutputStream outStream) throws IOException {
        IoUtil.writeObjects(outStream, true, this.allEvent);
    }

    public boolean isStreaming() {
        return true;
    }

    public void close() throws IOException {
    }
}

