/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net.high;

import com.luna.common.net.HttpUtils;
import com.luna.common.net.high.HttpStreamListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.bootstrap.HttpRequester;
import org.apache.hc.core5.http.impl.bootstrap.RequesterBootstrap;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHighLevelUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpHighLevelUtil.class);
    public static final RequesterBootstrap BOOTSTRAP = RequesterBootstrap.bootstrap();
    public static HttpRequester HTTP_REQUESTER;

    public static void init() {
        HTTP_REQUESTER = BOOTSTRAP.setStreamListener((Http1StreamListener)new HttpStreamListener()).setMaxTotal(HttpUtils.MAX_CONN).setDefaultMaxPerRoute(HttpUtils.MAX_ROUTE).create();
    }

    public static void setProxy(int port) {
        HttpHighLevelUtil.setProxy("", port);
    }

    public static void setProxy(String hostname, int port) {
        SocketConfig.Builder custom = SocketConfig.custom();
        custom.setSoTimeout(HttpUtils.SOCKET_TIME_OUT, TimeUnit.SECONDS);
        if (StringUtils.isNotBlank((CharSequence)hostname)) {
            custom.setSocksProxyAddress((SocketAddress)new InetSocketAddress(hostname, port));
            BOOTSTRAP.setSocketConfig(custom.build());
        }
        custom.setSocksProxyAddress((SocketAddress)new InetSocketAddress(port));
        BOOTSTRAP.setSocketConfig(custom.build());
        HTTP_REQUESTER = BOOTSTRAP.create();
    }

    public static HttpHost getHost(String host) {
        try {
            return HttpHost.create((String)host);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T doGet(String host, String path, Map<String, String> headers, Map<String, String> queries, HttpClientResponseHandler<T> responseHandler) {
        HttpHost httpHost = HttpHighLevelUtil.getHost(host);
        HttpGet request = new HttpGet(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)request);
        return HttpHighLevelUtil.doRequest(responseHandler, httpHost, (HttpUriRequestBase)request);
    }

    public static <T> T doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, HttpClientResponseHandler<T> responseHandler) {
        HttpHost httpHost = HttpHighLevelUtil.getHost(host);
        HttpPost request = new HttpPost(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)request);
        return HttpHighLevelUtil.doRequest(responseHandler, httpHost, (HttpUriRequestBase)request);
    }

    public static <T> T doDelete(String host, String path, Map<String, String> headers, Map<String, String> queries, HttpClientResponseHandler<T> responseHandler) {
        HttpHost httpHost = HttpHighLevelUtil.getHost(host);
        HttpDelete request = new HttpDelete(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)request);
        return HttpHighLevelUtil.doRequest(responseHandler, httpHost, (HttpUriRequestBase)request);
    }

    public static <T> T doPut(String host, String path, Map<String, String> headers, Map<String, String> queries, HttpClientResponseHandler<T> responseHandler) {
        HttpHost httpHost = HttpHighLevelUtil.getHost(host);
        HttpPut request = new HttpPut(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)request);
        return HttpHighLevelUtil.doRequest(responseHandler, httpHost, (HttpUriRequestBase)request);
    }

    public static <T> T doRequest(HttpClientResponseHandler<T> responseHandler, HttpHost httpHost, HttpUriRequestBase httpUriRequestBase) {
        try {
            return (T)HTTP_REQUESTER.execute(httpHost, (ClassicHttpRequest)httpUriRequestBase, Timeout.ofSeconds((long)HttpUtils.CONNECT_TIMEOUT), (HttpContext)HttpUtils.CLIENT_CONTEXT, responseHandler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        HttpHighLevelUtil.init();
    }
}

