/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net.download;

import com.google.common.collect.ImmutableMap;
import com.luna.common.net.HttpUtils;
import com.luna.common.net.download.DownloadThreadEvent;
import com.luna.common.net.download.DownloadThreadListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadThread
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadThread.class);
    String url;
    long startPosition;
    long endPosition;
    boolean isRange;
    File file;
    DownloadThreadListener listener;
    long downloaded;
    CloseableHttpClient httpClient;

    public DownloadThread(String url, long startPosition, long endPosition, boolean isRange, File file, DownloadThreadListener listener, long downloaded, CloseableHttpClient httpClient) {
        this.url = url;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.isRange = isRange;
        this.file = file;
        this.listener = listener;
        this.downloaded = downloaded;
        this.httpClient = httpClient;
    }

    void addDownloadListener(DownloadThreadListener listener) {
        this.listener = listener;
    }

    public long getdownLoaded() {
        return this.downloaded;
    }

    DownloadThread(String url, long startPosition, long endPosition, File file) {
        this.url = url;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.isRange = true;
        this.file = file;
        this.downloaded = 0L;
    }

    DownloadThread(String url, long startPosition, long endPosition, File file, boolean isRange) {
        this.url = url;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.isRange = isRange;
        this.file = file;
        this.downloaded = 0L;
    }

    @Override
    public void run() {
        try {
            CloseableHttpResponse response;
            int statusCode;
            HttpGet httpGet = new HttpGet(this.url);
            if (this.isRange) {
                httpGet.addHeader("Range", (Object)("bytes=" + this.startPosition + "-" + this.endPosition));
            }
            if ((statusCode = (response = this.httpClient == null ? (CloseableHttpResponse)HttpUtils.doGet(this.url, (Map<String, String>)ImmutableMap.of((Object)"Range", (Object)("bytes=" + this.startPosition + "-" + this.endPosition))) : this.httpClient.execute((ClassicHttpRequest)httpGet)).getCode()) == 206 || statusCode == 200 && !this.isRange) {
                InputStream inputStream = response.getEntity().getContent();
                RandomAccessFile outputStream = new RandomAccessFile(this.file, "rw");
                outputStream.seek(this.startPosition);
                int count = 0;
                byte[] buffer = new byte[10240];
                while ((count = inputStream.read(buffer, 0, buffer.length)) > 0) {
                    outputStream.write(buffer, 0, count);
                    this.downloaded += (long)count;
                    this.listener.afterPerDown(new DownloadThreadEvent(this, count));
                }
                outputStream.close();
            }
            httpGet.abort();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.listener.downCompleted(new DownloadThreadEvent(this, this.endPosition));
            log.info("End:" + this.startPosition + "-" + this.endPosition);
            try {
                if (this.httpClient != null) {
                    this.httpClient.close();
                }
            }
            catch (IOException e) {
                log.error("run:: ", (Throwable)e);
            }
        }
    }
}

