/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net.base;

import com.luna.common.file.FileTools;
import com.luna.common.io.IoUtil;
import com.luna.common.net.HttpUtils;
import com.luna.common.text.CharsetUtil;
import com.luna.common.utils.ObjectUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBaseUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpBaseUtils.class);
    private static final Integer CONN_TIME_OUT = 5000;
    private static final Integer READ_TIME_OUT = 5000;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static volatile HttpURLConnection conn = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpURLConnection getConn(String url) {
        try {
            URL realUrl = new URL(url);
            if (conn != null) return conn;
            Class<HttpURLConnection> clazz = HttpURLConnection.class;
            synchronized (HttpURLConnection.class) {
                if (conn != null) return conn;
                conn = (HttpURLConnection)realUrl.openConnection();
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return conn;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream doURL(String host, String path, String method, Map<String, String> headers, Map<String, String> queries, String body) {
        try {
            HttpURLConnection conn = HttpBaseUtils.getConnection(host, path, method, headers, queries);
            if (!Objects.isNull(body)) {
                conn.setDoOutput(true);
                IoUtil.write(conn.getOutputStream(), CharsetUtil.defaultCharsetName(), true, body);
            }
            return conn.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream doURL(String host, String path, String method, Map<String, String> headers, Map<String, String> queries, byte[] file) {
        try {
            HttpURLConnection conn = HttpBaseUtils.getConnection(host, path, method, headers, queries);
            if (!ObjectUtils.isEmpty((Object)file)) {
                conn.setDoOutput(true);
                IOUtils.write((byte[])file, (OutputStream)conn.getOutputStream());
            }
            return conn.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doURLWithByte(String host, String path, String method, Map<String, String> headers, Map<String, String> queries, File file) {
        return HttpBaseUtils.readWithByte(HttpBaseUtils.doURL(host, path, method, headers, queries, FileTools.read(file.getAbsolutePath())));
    }

    public static String doURLWithString(String host, String path, String method, Map<String, String> headers, Map<String, String> queries, File file) {
        return HttpBaseUtils.readWithString(HttpBaseUtils.doURL(host, path, method, headers, queries, FileTools.read(file.getAbsolutePath())));
    }

    public static byte[] doURLWithByte(String host, String path, String method, Map<String, String> headers, Map<String, String> queries, String body) {
        return HttpBaseUtils.readWithByte(HttpBaseUtils.doURL(host, path, method, headers, queries, body));
    }

    public static String doURLWithString(String host, String path, String method, Map<String, String> headers, Map<String, String> queries, String body) {
        return HttpBaseUtils.readWithString(HttpBaseUtils.doURL(host, path, method, headers, queries, body));
    }

    public static void download(String url, String path) {
        try {
            InputStream is = new URL(url).openStream();
            byte[] bytes = HttpBaseUtils.readWithByte(is);
            FileTools.write(bytes, path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readWithByte(InputStream inputStream, int bufferSize) {
        try {
            int l;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] tmp = new byte[bufferSize];
            while ((l = inputStream.read(tmp)) != -1) {
                buffer.write(tmp, 0, l);
            }
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readWithString(InputStream inputStream, int bufferSize) {
        try {
            int cp;
            StringBuilder sb = new StringBuilder();
            char[] tmp = new char[bufferSize];
            while ((cp = inputStream.read()) != -1) {
                sb.append(tmp, 0, cp);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readWithReader(Reader rd) {
        try {
            int cp;
            StringBuilder sb = new StringBuilder();
            while ((cp = rd.read()) != -1) {
                sb.append((char)cp);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readWithString(InputStream inputStream, String charsetName) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charsetName));
            return HttpBaseUtils.readWithReader(reader);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readWithString(InputStream inputStream) {
        return HttpBaseUtils.readWithString(inputStream, 4096);
    }

    public static byte[] readWithByte(InputStream inputStream) {
        return HttpBaseUtils.readWithByte(inputStream, 4096);
    }

    private static HttpURLConnection getConnection(String host, String path, String method, Map<String, String> headers, Map<String, String> queries) {
        String url = HttpUtils.buildUrl(host, path, queries);
        HttpURLConnection conn = HttpBaseUtils.getConn(url);
        conn.setConnectTimeout(CONN_TIME_OUT);
        conn.setReadTimeout(READ_TIME_OUT);
        try {
            conn.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return conn;
    }

    public static CookieStore setCookieManager() {
        CookieManager manager = new CookieManager();
        manager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        CookieHandler.setDefault(manager);
        return manager.getCookieStore();
    }

    public static void printCookie(CookieStore cookieStore) {
        List<HttpCookie> listCookie = cookieStore.getCookies();
        listCookie.forEach(httpCookie -> {
            System.out.println("--------------------------------------");
            System.out.println("class      : " + httpCookie.getClass());
            System.out.println("comment    : " + httpCookie.getComment());
            System.out.println("commentURL : " + httpCookie.getCommentURL());
            System.out.println("discard    : " + httpCookie.getDiscard());
            System.out.println("domain     : " + httpCookie.getDomain());
            System.out.println("maxAge     : " + httpCookie.getMaxAge());
            System.out.println("name       : " + httpCookie.getName());
            System.out.println("path       : " + httpCookie.getPath());
            System.out.println("portlist   : " + httpCookie.getPortlist());
            System.out.println("secure     : " + httpCookie.getSecure());
            System.out.println("value      : " + httpCookie.getValue());
            System.out.println("version    : " + httpCookie.getVersion());
            System.out.println("httpCookie : " + httpCookie);
        });
    }
}

