/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.img;

import com.luna.common.check.Assert;
import com.luna.common.encrypt.Base64Util;
import com.luna.common.file.FileNameUtil;
import com.luna.common.file.FileTools;
import com.luna.common.img.BackgroundRemoval;
import com.luna.common.img.ColorUtil;
import com.luna.common.img.FontUtil;
import com.luna.common.img.GraphicsUtil;
import com.luna.common.img.Img;
import com.luna.common.io.IoUtil;
import com.luna.common.math.NumberUtil;
import com.luna.common.text.StringTools;
import com.luna.common.utils.ObjectUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;

public class ImgUtil {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(File srcImageFile, File destImageFile, float scale) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcImageFile);
            ImgUtil.scale((Image)image, destImageFile, scale);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(InputStream srcStream, OutputStream destStream, float scale) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.scale((Image)image, destStream, scale);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.scale((Image)image, destStream, scale);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void scale(Image srcImg, File destFile, float scale) throws RuntimeException {
        Img.from(srcImg).setTargetImageType(FileNameUtil.extName(destFile)).scale(scale).write(destFile);
    }

    public static void scale(Image srcImg, OutputStream out, float scale) throws RuntimeException {
        ImgUtil.scale(srcImg, ImgUtil.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImg, ImageOutputStream destImageStream, float scale) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.scale(srcImg, scale), destImageStream);
    }

    public static Image scale(Image srcImg, float scale) {
        return Img.from(srcImg).scale(scale).getImg();
    }

    public static Image scale(Image srcImg, int width, int height) {
        return Img.from(srcImg).scale(width, height).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws RuntimeException {
        Img img = null;
        try {
            img = Img.from(srcImageFile);
            img.setTargetImageType(FileNameUtil.extName(destImageFile)).scale(width, height, fixedColor).write(destImageFile);
        }
        finally {
            IoUtil.flush(img);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws RuntimeException {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.scale(image, ImgUtil.getImageOutputStream(destStream), width, height, fixedColor);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws RuntimeException {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.scale(image, destStream, width, height, fixedColor);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return Img.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcImgFile);
            ImgUtil.cut((Image)image, destImgFile, rectangle);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.cut((Image)image, destStream, rectangle);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.cut((Image)image, destStream, rectangle);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws RuntimeException {
        ImgUtil.write(ImgUtil.cut(srcImage, rectangle), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws RuntimeException {
        ImgUtil.cut(srcImage, ImgUtil.getImageOutputStream(out), rectangle);
    }

    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.cut(srcImage, rectangle), destImageStream);
    }

    public static Image cut(Image srcImage, Rectangle rectangle) {
        return Img.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(Image srcImage, int x, int y) {
        return ImgUtil.cut(srcImage, x, y, -1);
    }

    public static Image cut(Image srcImage, int x, int y, int radius) {
        return Img.from(srcImage).cut(x, y, radius).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcImageFile);
            ImgUtil.slice(image, descDir, destWidth, destHeight);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        if (srcWidth < destWidth) {
            destWidth = srcWidth;
        }
        if (srcHeight < destHeight) {
            destHeight = srcHeight;
        }
        int cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor((double)srcWidth / (double)destWidth) + 1;
        int rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor((double)srcHeight / (double)destHeight) + 1;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = ImgUtil.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                ImgUtil.write(tag, FileTools.file(descDir, "_r" + i + "_c" + j + ".jpg"));
            }
        }
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) {
        ImgUtil.sliceByRowsAndCols(srcImageFile, destDir, IMAGE_TYPE_JPEG, rows, cols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sliceByRowsAndCols(File srcImageFile, File destDir, String format, int rows, int cols) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcImageFile);
            ImgUtil.sliceByRowsAndCols(image, destDir, format, rows, cols);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, int rows, int cols) {
        ImgUtil.sliceByRowsAndCols(srcImage, destDir, IMAGE_TYPE_JPEG, rows, cols);
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, String format, int rows, int cols) {
        if (!destDir.exists()) {
            FileTools.mkdir(destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        if (rows <= 0 || rows > 20) {
            rows = 2;
        }
        if (cols <= 0 || cols > 20) {
            cols = 2;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        int destWidth = NumberUtil.partValue(srcWidth, cols);
        int destHeight = NumberUtil.partValue(srcHeight, rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = ImgUtil.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                ImgUtil.write(tag, new File(destDir, "_r" + i + "_c" + j + "." + format));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) {
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isTrue(!srcImageFile.equals(destImageFile), "Src file is equals to dest file!");
        String srcExtName = FileNameUtil.extName(srcImageFile);
        String destExtName = FileNameUtil.extName(destImageFile);
        if (StringTools.equalsIgnoreCase((CharSequence)srcExtName, (CharSequence)destExtName)) {
            try {
                FileTools.copy(srcImageFile, destImageFile, true, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Img img = null;
        try {
            img = Img.from(srcImageFile);
            img.write(destImageFile);
        }
        finally {
            IoUtil.flush(img);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.write((Image)image, formatName, ImgUtil.getImageOutputStream(destStream));
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream) {
        Img.from(srcImage).setTargetImageType(formatName).write(destImageStream);
    }

    @Deprecated
    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        ImgUtil.convert(srcImage, formatName, destImageStream);
    }

    public static void gray(File srcImageFile, File destImageFile) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcImageFile);
            ImgUtil.gray((Image)image, destImageFile);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void gray(InputStream srcStream, OutputStream destStream) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.gray((Image)image, destStream);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.gray((Image)image, destStream);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void gray(Image srcImage, File outFile) {
        ImgUtil.write(ImgUtil.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) {
        ImgUtil.gray(srcImage, ImgUtil.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.gray(srcImage), destImageStream);
    }

    public static Image gray(Image srcImage) {
        return Img.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File destImageFile) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcImageFile);
            ImgUtil.binary(image, destImageFile);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.binary((Image)image, ImgUtil.getImageOutputStream(destStream), imageType);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.binary((Image)image, destStream, imageType);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void binary(Image srcImage, File outFile) {
        ImgUtil.write(ImgUtil.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) {
        ImgUtil.binary(srcImage, ImgUtil.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws RuntimeException {
        ImgUtil.write(ImgUtil.binary(srcImage), imageType, destImageStream);
    }

    public static Image binary(Image srcImage) {
        return Img.from(srcImage).binary().getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(imageFile);
            ImgUtil.pressText((Image)image, destFile, pressText, color, font, x, y, alpha);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.pressText((Image)image, ImgUtil.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.pressText((Image)image, destStream, pressText, color, font, x, y, alpha);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws RuntimeException {
        ImgUtil.write(ImgUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws RuntimeException {
        ImgUtil.pressText(srcImage, ImgUtil.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return Img.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcImageFile);
            ImgUtil.pressImage((Image)image, destImageFile, pressImg, x, y, alpha);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImg, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.pressImage((Image)image, ImgUtil.getImageOutputStream(destStream), pressImg, x, y, alpha);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImg, int x, int y, float alpha) throws RuntimeException {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(srcStream);
            ImgUtil.pressImage((Image)image, destStream, pressImg, x, y, alpha);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) throws RuntimeException {
        ImgUtil.write(ImgUtil.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImg, int x, int y, float alpha) throws RuntimeException {
        ImgUtil.pressImage(srcImage, ImgUtil.getImageOutputStream(out), pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImg, int x, int y, float alpha) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.pressImage(srcImage, pressImg, x, y, alpha), destImageStream);
    }

    public static Image pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, x, y, alpha).getImg();
    }

    public static Image pressImage(Image srcImage, Image pressImg, Rectangle rectangle, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, rectangle, alpha).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotate(File imageFile, int degree, File outFile) throws RuntimeException {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(imageFile);
            ImgUtil.rotate((Image)image, degree, outFile);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void rotate(Image image, int degree, File outFile) throws RuntimeException {
        ImgUtil.write(ImgUtil.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.rotate(image, degree), ImgUtil.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.rotate(image, degree), out);
    }

    public static Image rotate(Image image, int degree) {
        return Img.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws RuntimeException {
        BufferedImage image = null;
        try {
            image = ImgUtil.read(imageFile);
            ImgUtil.flip((Image)image, outFile);
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void flip(Image image, File outFile) throws RuntimeException {
        ImgUtil.write(ImgUtil.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws RuntimeException {
        ImgUtil.flip(image, ImgUtil.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws RuntimeException {
        ImgUtil.writeJpg(ImgUtil.flip(image), out);
    }

    public static Image flip(Image image) {
        return Img.from(image).flip().getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File imageFile, File outFile, float quality) throws RuntimeException {
        Img img = null;
        try {
            img = Img.from(imageFile);
            img.setQuality(quality).write(outFile);
        }
        finally {
            IoUtil.flush(img);
        }
    }

    @Deprecated
    public static RenderedImage toRenderedImage(Image img) {
        return ImgUtil.castToRenderedImage(img, IMAGE_TYPE_JPG);
    }

    @Deprecated
    public static BufferedImage toBufferedImage(Image img) {
        return ImgUtil.castToBufferedImage(img, IMAGE_TYPE_JPG);
    }

    public static RenderedImage castToRenderedImage(Image img, String imageType) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return ImgUtil.toBufferedImage(img, imageType);
    }

    public static BufferedImage castToBufferedImage(Image img, String imageType) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImgUtil.toBufferedImage(img, imageType);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        return ImgUtil.toBufferedImage(image, imageType, null);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType, Color backgroundColor) {
        int type = IMAGE_TYPE_PNG.equalsIgnoreCase(imageType) ? 2 : 1;
        return ImgUtil.toBufferedImage(image, type, backgroundColor);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImgUtil.copyImage(image, imageType);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImgUtil.copyImage(image, imageType);
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image, int imageType, Color backgroundColor) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImgUtil.copyImage(image, imageType, backgroundColor);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImgUtil.copyImage(image, imageType, backgroundColor);
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image img, int imageType) {
        return ImgUtil.copyImage(img, imageType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage copyImage(Image img, int imageType, Color backgroundColor) {
        img = new ImageIcon(img).getImage();
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = GraphicsUtil.createGraphics(bimage, backgroundColor);
        try {
            bGr.drawImage(img, 0, 0, null);
        }
        finally {
            bGr.dispose();
        }
        return bimage;
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) throws HeadlessException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage toImage(String base64) throws RuntimeException {
        return ImgUtil.toImage(Base64Util.decodeBase64(base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws RuntimeException {
        return ImgUtil.read(new ByteArrayInputStream(imageBytes));
    }

    public static ByteArrayInputStream toStream(Image image, String imageType) {
        return IoUtil.toStream(ImgUtil.toBytes(image, imageType));
    }

    public static String toBase64DataUri(Image image, String imageType) {
        return ImgUtil.getDataUri("image/" + imageType, null, "base64", ImgUtil.toBase64(image, imageType));
    }

    public static String toBase64(Image image, String imageType) {
        return Base64Util.encodeBase64(ImgUtil.toBytes(image, imageType));
    }

    public static byte[] toBytes(Image image, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImgUtil.write(image, imageType, out);
        return out.toByteArray();
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws RuntimeException {
        ImgUtil.writePng((Image)ImgUtil.createImage(str, font, backgroundColor, fontColor, 2), out);
    }

    public static void createTransparentImage(String str, Font font, Color fontColor, ImageOutputStream out) throws RuntimeException {
        ImgUtil.writePng((Image)ImgUtil.createImage(str, font, null, fontColor, 2), out);
    }

    public static BufferedImage createImage(String str, Font font, Color backgroundColor, Color fontColor, int imageType) throws RuntimeException {
        Rectangle2D r = ImgUtil.getRectangle(str, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics g = image.getGraphics();
        if (null != backgroundColor) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(ObjectUtils.defaultIfNull(fontColor, Color.BLACK));
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        return image;
    }

    public static Rectangle2D getRectangle(String str, Font font) {
        return font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static Font createFont(File fontFile) {
        return FontUtil.createFont(fontFile);
    }

    public static Font createFont(InputStream fontStream) {
        return FontUtil.createFont(fontStream);
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        return GraphicsUtil.createGraphics(image, color);
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws RuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_JPG, destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws RuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_PNG, destImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws RuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_JPG, out);
    }

    public static void writePng(Image image, OutputStream out) throws RuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_PNG, out);
    }

    public static void write(ImageInputStream srcStream, String formatName, ImageOutputStream destStream) {
        ImgUtil.write((Image)ImgUtil.read(srcStream), formatName, destStream);
    }

    public static void write(Image image, String imageType, OutputStream out) throws RuntimeException {
        ImgUtil.write(image, imageType, ImgUtil.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws RuntimeException {
        return ImgUtil.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws RuntimeException {
        return ImgUtil.write(image, imageType, destImageStream, quality, null);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality, Color backgroundColor) throws RuntimeException {
        if (StringTools.isBlank((CharSequence)imageType)) {
            imageType = IMAGE_TYPE_JPG;
        }
        BufferedImage bufferedImage = ImgUtil.toBufferedImage(image, imageType, backgroundColor);
        ImageWriter writer = ImgUtil.getWriter(bufferedImage, imageType);
        return ImgUtil.write((Image)bufferedImage, writer, destImageStream, quality);
    }

    public static void write(Image image, File targetFile) throws RuntimeException {
        FileTools.touch(targetFile);
        ImageOutputStream out = null;
        try {
            out = ImgUtil.getImageOutputStream(targetFile);
            ImgUtil.write(image, FileNameUtil.extName(targetFile), out);
        }
        finally {
            IoUtil.close(out);
        }
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImgUtil.castToRenderedImage(image, IMAGE_TYPE_JPG);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImgUtil.read(FileTools.file(imageFilePath));
    }

    public static BufferedImage read(File imageFile) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + imageFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static Image getImage(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public static BufferedImage read(InputStream imageStream) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(URL imageUrl) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of [" + imageUrl + "] is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws RuntimeException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws RuntimeException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + outFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws RuntimeException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageWriter getWriter(Image img, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(ImgUtil.toBufferedImage(img, formatName));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(Color color) {
        return ColorUtil.toHex(color);
    }

    public static String toHex(int r, int g, int b) {
        return ColorUtil.toHex(r, g, b);
    }

    public static Color hexToColor(String hex) {
        return ColorUtil.hexToColor(hex);
    }

    public static Color getColor(int rgb) {
        return ColorUtil.getColor(rgb);
    }

    public static Color getColor(String colorName) {
        return ColorUtil.getColor(colorName);
    }

    public static Color randomColor() {
        return ColorUtil.randomColor();
    }

    public static Color randomColor(Random random) {
        return ColorUtil.randomColor(random);
    }

    public static Point getPointBaseCentre(Rectangle rectangle, int backgroundWidth, int backgroundHeight) {
        return new Point(rectangle.x + Math.abs(backgroundWidth - rectangle.width) / 2, rectangle.y + Math.abs(backgroundHeight - rectangle.height) / 2);
    }

    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        return ColorUtil.getMainColor(image, rgbFilters);
    }

    public static boolean backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(inputPath, outputPath, tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(input, output, tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(input, output, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(bufferedImage, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(outputStream, override, tolerance);
    }

    public static BufferedImage colorConvert(ColorSpace colorSpace, BufferedImage image) {
        return ImgUtil.filter(new ColorConvertOp(colorSpace, null), image);
    }

    public static BufferedImage transform(AffineTransform xform, BufferedImage image) {
        return ImgUtil.filter(new AffineTransformOp(xform, null), image);
    }

    public static BufferedImage filter(BufferedImageOp op, BufferedImage image) {
        return op.filter(image, null);
    }

    public static Image filter(ImageFilter filter, Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
    }

    public static void flush(Image image) {
        if (null != image) {
            image.flush();
        }
    }

    public static String getDataUri(String mimeType, Charset charset, String encoding, String data) {
        StringBuilder builder = new StringBuilder("data:");
        if (StringTools.isNotBlank((CharSequence)mimeType)) {
            builder.append(mimeType);
        }
        if (null != charset) {
            builder.append(";charset=").append(charset.name());
        }
        if (StringTools.isNotBlank((CharSequence)encoding)) {
            builder.append(';').append(encoding);
        }
        builder.append(',').append(data);
        return builder.toString();
    }
}

