/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.file;

import com.luna.common.check.Assert;
import com.luna.common.io.IoUtil;
import com.luna.common.math.ComputeIter;
import com.luna.common.utils.IterableIter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;

public class LineIter
extends ComputeIter<String>
implements IterableIter<String>,
Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BufferedReader bufferedReader;

    public LineIter(InputStream in, Charset charset) throws IllegalArgumentException {
        this(IoUtil.getReader(in, charset));
    }

    public LineIter(Reader reader) throws IllegalArgumentException {
        Assert.notNull((Object)reader, "Reader must not be null");
        this.bufferedReader = IoUtil.getReader(reader);
    }

    @Override
    protected String computeNext() {
        try {
            String line;
            do {
                if ((line = this.bufferedReader.readLine()) != null) continue;
                return null;
            } while (!this.isValidLine(line));
            return line;
        }
        catch (IOException ioe) {
            this.close();
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void close() {
        super.finish();
        IoUtil.close(this.bufferedReader);
    }

    protected boolean isValidLine(String line) {
        return true;
    }
}

