/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.file;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.luna.common.check.Assert;
import com.luna.common.exception.BaseException;
import com.luna.common.file.FileNameUtil;
import com.luna.common.file.PathUtil;
import com.luna.common.file.visitor.MoveVisitor;
import com.luna.common.io.IoUtil;
import com.luna.common.os.OSinfo;
import com.luna.common.text.CharsetUtil;
import com.luna.common.text.StringTools;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FileTools {
    public static String getTmpDirPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTmpDir() {
        return new File(FileTools.getTmpDirPath());
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File getUserHomeDir() {
        return new File(FileTools.getUserHomePath());
    }

    public static List<String> readAllLines(String fileName) {
        Objects.requireNonNull(fileName, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            return Files.readAllLines(Paths.get(fileName, new String[0]), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteIfExists(String file) {
        Objects.requireNonNull(file, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Files.deleteIfExists(Paths.get(file, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isExists(String fileName) {
        return Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0]);
    }

    public static boolean notExists(String fileName) {
        return !FileTools.isExists(fileName);
    }

    public static void write(byte[] bytes, String fileName) {
        Objects.requireNonNull(fileName, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Files.write(Paths.get(fileName, new String[0]), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File write(InputStream in, File file, boolean isCloseIn) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IoUtil.copy(in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(out);
                if (isCloseIn) {
                    IoUtil.close(in);
                }
                throw throwable;
            }
        }
        IoUtil.close(out);
        if (isCloseIn) {
            IoUtil.close(in);
        }
        return file;
    }

    public static File write(InputStream in, String file, boolean isCloseIn) throws IOException {
        return FileTools.write(in, new File(file), isCloseIn);
    }

    public static void write(String content, String fileName) {
        Objects.requireNonNull(fileName, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Files.write(Paths.get(fileName, new String[0]), content.getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] read(String fileName) {
        Objects.requireNonNull(fileName, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            return Files.readAllBytes(Paths.get(fileName, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long count(String filePath) {
        Objects.requireNonNull(filePath, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(filePath));
            long skip = ((LineNumberReader)reader).skip(Long.MAX_VALUE);
            long l = ((LineNumberReader)reader).getLineNumber();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                assert (reader != null);
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> read(String filePath, int skip, int row) {
        Objects.requireNonNull(filePath, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        BufferedReader reader = null;
        if (skip < 0) {
            skip = 0;
        }
        if (row < 0) {
            row = 1;
        }
        try {
            String s;
            ArrayList list = Lists.newArrayList();
            reader = new LineNumberReader(new FileReader(filePath));
            ((LineNumberReader)reader).setLineNumber(0);
            while ((s = ((LineNumberReader)reader).readLine()) != null) {
                if (((LineNumberReader)reader).getLineNumber() <= skip) continue;
                list.add(s);
                for (int i = 0; i < row - 1; ++i) {
                    list.add(((LineNumberReader)reader).readLine());
                }
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                assert (reader != null);
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void download(String url, String file) {
        Objects.requireNonNull(file, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(url, "\u7f51\u7edc\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            FileUtils.copyURLToFile((URL)new URL(url), (File)new File(file), (int)5000, (int)5000);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void downloadWithRetry(String url, String file, int maxRetry) {
        for (int i = 0; i < maxRetry - 1; ++i) {
            try {
                FileTools.download(url, file);
                return;
            }
            catch (Exception exception) {
                continue;
            }
        }
        FileTools.download(url, file);
    }

    public static void writeStringToFile(String path, String content) {
        FileTools.writeStringToFile(path, content, CharsetUtil.defaultCharset(), true);
    }

    public static void createDirectory(String pathDir) {
        try {
            Path path = Paths.get(pathDir, new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                path = path.getParent();
            }
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeStringToFile(String path, String content, Charset destCharset, boolean override) {
        try {
            Path filePath = Paths.get(path, new String[0]);
            if (Files.notExists(filePath, new LinkOption[0])) {
                if (!override) {
                    throw new FileNotFoundException();
                }
                Files.createFile(filePath, new FileAttribute[0]);
            }
            FileUtils.writeStringToFile((File)new File(path), (String)content, (Charset)destCharset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeStringToFile(File file, String content, Charset destCharset, boolean override) {
        String path = file.getAbsolutePath();
        FileTools.writeStringToFile(path, content, destCharset, override);
    }

    public static void writeStringToFile(File file, String content, Charset destCharset) {
        FileTools.writeStringToFile(file, content, destCharset, false);
    }

    public static String readFileToString(String path) {
        return FileTools.readFileToString(path, Charset.defaultCharset());
    }

    public static String readFileToString(String path, Charset destCharset) {
        return FileTools.readFileToString(new File(path), destCharset);
    }

    public static String readFileToString(File file, Charset destCharset) {
        try {
            return FileUtils.readFileToString((File)file, (Charset)destCharset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File rename(File file, String newName, boolean isOverride) {
        return FileTools.rename(file, newName, false, isOverride);
    }

    public static File rename(File file, String newName, boolean isRetainExt, boolean isOverride) {
        String extName;
        if (isRetainExt && StringUtils.isNotBlank((CharSequence)(extName = FileNameUtil.extName(file)))) {
            newName = newName.concat(".").concat(extName);
        }
        return FileTools.rename(file.toPath(), newName, isOverride).toFile();
    }

    public static Path rename(Path path, String newName, boolean isOverride) {
        return FileTools.move(path, path.resolveSibling(newName), isOverride);
    }

    public static Path move(Path src, Path target, boolean isOverride) {
        CopyOption[] options;
        CopyOption[] copyOptionArray;
        Assert.notNull((Object)src, "Src path must be not null !");
        Assert.notNull((Object)target, "Target path must be not null !");
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = options = new CopyOption[]{};
        }
        if (Files.isDirectory(target, new LinkOption[0])) {
            target = target.resolve(src.getFileName());
        }
        FileTools.createDirectory(target.toString());
        try {
            return Files.move(src, target, options);
        }
        catch (IOException e) {
            try {
                Files.walkFileTree(src, new MoveVisitor(src, target, options));
                PathUtil.del(src);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return target;
        }
    }

    public static void cleanDirectory(String path) {
        FileTools.cleanDirectory(new File(path), false);
    }

    public static void cleanDirectory(String path, boolean parent) {
        FileTools.cleanDirectory(new File(path), parent);
    }

    public static void cleanDirectory(File file, boolean parent) {
        try {
            if (file.isFile()) {
                if (!parent) {
                    throw new BaseException("\u6587\u4ef6\u4e0d\u662f\u76ee\u5f55");
                }
                file = file.getParentFile();
            }
            FileUtils.cleanDirectory((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getName(Path path) {
        if (null == path) {
            return null;
        }
        return path.getFileName().toString();
    }

    public static BufferedOutputStream getOutputStream(File file) {
        OutputStream out;
        try {
            out = Files.newOutputStream(FileTools.touch(file).toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return IoUtil.toBuffered(out);
    }

    public static File touch(String path) throws RuntimeException {
        if (path == null) {
            return null;
        }
        return FileTools.touch(FileTools.file(path));
    }

    public static File touch(File file) {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            try {
                Files.createFile(file.toPath(), new FileAttribute[0]);
                file.createNewFile();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    public static File file(String path) {
        if (null == path) {
            return null;
        }
        return new File(path);
    }

    public static File file(File parent, String path) {
        if (StringTools.isBlank((CharSequence)path)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileTools.checkSlip(parent, FileTools.buildFile(parent, path));
    }

    public static BufferedInputStream getInputStream(File file) {
        return IoUtil.toBuffered(IoUtil.toStream(file));
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileTools.touch(file), isAppend), charset));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedReader getReader(File file, Charset charset) {
        return IoUtil.getReader((InputStream)FileTools.getInputStream(file), charset);
    }

    public static boolean equals(Path file1, Path file2) throws RuntimeException {
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean equals(File file1, File file2) throws RuntimeException {
        Assert.notNull(file1);
        Assert.notNull(file2);
        if (!file1.exists() || !file2.exists()) {
            return false == file1.exists() && false == file2.exists() && FileTools.pathEquals(file1, file2);
        }
        return FileTools.equals(file1.toPath(), file2.toPath());
    }

    public static boolean pathEquals(File file1, File file2) {
        block8: {
            if (OSinfo.isWindows()) {
                try {
                    if (StringTools.equalsIgnoreCase((CharSequence)file1.getCanonicalPath(), (CharSequence)file2.getCanonicalPath())) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (StringTools.equalsIgnoreCase((CharSequence)file1.getAbsolutePath(), (CharSequence)file2.getAbsolutePath())) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (StringTools.equals((CharSequence)file1.getCanonicalPath(), (CharSequence)file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!StringTools.equals((CharSequence)file1.getAbsolutePath(), (CharSequence)file2.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        if (null != parentFile && null != file && !FileTools.isSub(parentFile, file)) {
            throw new IllegalArgumentException("New file is outside of the parent dir: " + file.getName());
        }
        return file;
    }

    public static boolean isSub(File parent, File sub) {
        Assert.notNull(parent);
        Assert.notNull(sub);
        return FileTools.isSub(parent.toPath(), sub.toPath());
    }

    public static boolean isSub(Path parent, Path sub) {
        return PathUtil.toAbsNormal(sub).startsWith(PathUtil.toAbsNormal(parent));
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!OSinfo.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List pathParts = Splitter.on((char)'/').splitToList((CharSequence)fileName);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, (String)pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = (String)pathParts.get(lastPartIndex);
        }
        return new File(outFile, fileName);
    }

    public static boolean mkdirsSafely(File dir, int tryCount, long sleepMillis) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        for (int i = 1; i <= tryCount; ++i) {
            dir.mkdirs();
            if (dir.exists()) {
                return true;
            }
            try {
                Thread.sleep(sleepMillis);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return dir.exists();
    }

    public static File mkParentDirs(File file) {
        if (null == file) {
            return null;
        }
        return FileTools.mkdir(FileTools.getParent(file, 1));
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileTools.getParent(parentFile, level - 1);
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            FileTools.mkdirsSafely(dir, 5, 1L);
        }
        return dir;
    }

    public static void copy(File src, File dest) {
        try {
            FileTools.copy(src, dest, false, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copy(File src, File dest, Boolean isOverride, Boolean isCopyAttributes) throws IOException {
        Assert.notNull((Object)src, "Source File is null !");
        if (!src.exists()) {
            throw new RuntimeException("File not exist: " + src);
        }
        Assert.notNull((Object)dest, "Destination File or directiory is null !");
        if (FileTools.equals(src, dest)) {
            return;
        }
        ArrayList<StandardCopyOption> optionList = new ArrayList<StandardCopyOption>(2);
        if (isOverride.booleanValue()) {
            optionList.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (isCopyAttributes.booleanValue()) {
            optionList.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        if (src.isDirectory()) {
            throw new RuntimeException();
        }
        Files.copy(src.toPath(), dest.toPath(), optionList.toArray(new CopyOption[0]));
    }
}

