/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.file;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.luna.common.file.FileTools;
import com.luna.common.regex.ReUtil;
import com.luna.common.text.CharsetUtil;
import com.luna.common.text.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class FileNameUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";
    public static final String EXT_JAVA = ".java";
    public static final String EXT_CLASS = ".class";
    public static final String EXT_JAR = ".jar";
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|]");
    private static final Pattern PATTERN_PATH_ABSOLUTE = Pattern.compile("^[a-zA-Z]:([/\\\\].*)?");

    public static String getName(File file) {
        return null != file ? file.getName() : null;
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return null;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (CharsetUtil.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!CharsetUtil.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static String getSuffix(File file) {
        return FileNameUtil.extName(file);
    }

    public static String getSuffix(String fileName) {
        return FileNameUtil.extName(fileName);
    }

    public static String getPrefix(File file) {
        return FileNameUtil.mainName(file);
    }

    public static String getPrefix(String fileName) {
        return FileNameUtil.mainName(fileName);
    }

    public static String mainName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileNameUtil.mainName(file.getName());
    }

    public static String mainName(String fileName) {
        if (null == fileName) {
            return null;
        }
        int len = fileName.length();
        if (0 == len) {
            return fileName;
        }
        if (CharsetUtil.isFileSeparator(fileName.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        int end = len;
        for (int i = len - 1; i >= 0; --i) {
            char c = fileName.charAt(i);
            if (len == end && '.' == c) {
                end = i;
            }
            if (!CharsetUtil.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return fileName.substring(begin, end);
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileNameUtil.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return StringTools.containsAny((CharSequence)ext, '/', '\\') ? "" : ext;
    }

    public static String cleanInvalid(String fileName) {
        return StringTools.isBlank((CharSequence)fileName) ? fileName : ReUtil.delAll(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)fileName);
    }

    public static boolean containsInvalid(String fileName) {
        return !StringTools.isBlank((CharSequence)fileName) && ReUtil.contains(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)fileName);
    }

    public static boolean isType(String fileName, String ... extNames) {
        return StringTools.equalsAnyIgnoreCase((CharSequence)FileNameUtil.extName(fileName), (CharSequence[])extNames);
    }

    public static String subPath(String dirPath, String filePath) {
        if (StringTools.isNotEmpty((CharSequence)dirPath) && StringTools.isNotEmpty((CharSequence)filePath)) {
            dirPath = StringTools.removeSuffix(FileNameUtil.normalize(dirPath), "/");
            filePath = FileNameUtil.normalize(filePath);
            String result = StringTools.substringAfter((String)filePath, (String)dirPath);
            return StringTools.removeStart((String)result, (String)"/");
        }
        return filePath;
    }

    public static String subPath(String rootDir, File file) {
        try {
            return FileNameUtil.subPath(rootDir, file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        String pathToUse = StringTools.substringBefore((String)path, (String)CLASSPATH_URL_PREFIX);
        if (StringTools.startWith((CharSequence)(pathToUse = StringTools.substringBefore((String)pathToUse, (String)FILE_URL_PREFIX)), '~')) {
            pathToUse = FileTools.getUserHomePath() + pathToUse.substring(1);
        }
        pathToUse = pathToUse.replaceAll("[/\\\\]+", "/");
        pathToUse = StringTools.trimLeadingWhitespace(pathToUse);
        if (path.startsWith("\\\\")) {
            pathToUse = "\\" + pathToUse;
        }
        String prefix = "";
        int prefixIndex = pathToUse.indexOf(58);
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (StringTools.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List pathList = Splitter.on((char)'/').splitToList((CharSequence)pathToUse);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = (String)pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && StringTools.isEmpty((CharSequence)prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return prefix + Joiner.on((String)"/").join(pathElements);
    }

    public static boolean isAbsolutePath(String path) {
        if (StringTools.isEmpty((CharSequence)path)) {
            return false;
        }
        return '/' == path.charAt(0) || ReUtil.isMatch(PATTERN_PATH_ABSOLUTE, (CharSequence)path);
    }
}

