/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.exception;

public class BaseException
extends RuntimeException {
    public static final BaseException SYSTEM_ERROR = new BaseException(100000, "\u7cfb\u7edf\u5f02\u5e38");
    public static final BaseException UNKNOWN = new BaseException(600000, "\u7cfb\u7edf\u9519\u8bef");
    public static final BaseException PARAMETER_ERROR = new BaseException(600001, "\u53c2\u6570\u9519\u8bef");
    public static final BaseException MISSING = new BaseException(600002, "\u4fe1\u606f\u4e0d\u5b58\u5728");
    public static final BaseException PARAMETER_OVERFLOW = new BaseException(600003, "\u53c2\u6570\u4e2a\u6570\u8d85\u9650");
    public static final BaseException REPEAT_OPERATION = new BaseException(600004, "\u91cd\u590d\u64cd\u4f5c(\u5e42\u7b49\u6821\u9a8c\u5931\u8d25)");
    public static final BaseException UN_SUPPORT_ENCRYPT_TYPE = new BaseException(600005, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u52a0\u5bc6\u7c7b\u578b");
    private int code;
    private String message;

    public BaseException(BaseException baseException, String ... extendMessage) {
        this(baseException.getCode(), String.format(baseException.getMessage(), extendMessage));
    }

    public BaseException(int status, String msg, Throwable throwable) {
        super(throwable);
        this.code = status;
        this.message = msg;
    }

    public BaseException(String msg, Throwable throwable) {
        super(throwable);
        this.message = msg;
    }

    public BaseException(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public BaseException(int status, Throwable throwable) {
        super(throwable);
        this.code = status;
    }

    public BaseException(String message) {
        super(message);
        this.code = 9002;
        this.message = message;
    }

    public BaseException(Throwable cause) {
        super(cause);
    }

    public BaseException(Throwable cause, int code) {
        super(cause);
        this.code = code;
    }

    public BaseException() {
    }

    public static boolean isBaseException(Throwable t) {
        return t instanceof BaseException;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

