/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.encrypt.security;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class Blowfish {
    public static final String CIPHER_NAME = "Blowfish/CFB8/NoPadding";
    public static final String CHARSET = "GBK";
    public static final int KEY_LENGTH = 8;

    public static String encrypt(String input, String key) {
        try {
            return Blowfish.encrypt(input.getBytes(CHARSET), key.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String input, String key) {
        try {
            return Blowfish.decrypt(input.getBytes(CHARSET), key.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(byte[] input, byte[] key) {
        Preconditions.checkNotNull((Object)input, (Object)"input can't be null");
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null");
        Cipher cipher = Blowfish.newCipher(1, key);
        try {
            byte[] enBytes = cipher.doFinal(input);
            byte[] base64Bytes = Base64.encodeBase64URLSafe((byte[])enBytes);
            return new String(base64Bytes, CHARSET);
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(byte[] input, byte[] key) {
        Preconditions.checkNotNull((Object)input, (Object)"input can't be null");
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null");
        Cipher cipher = Blowfish.newCipher(2, key);
        try {
            byte[] base64Bytes = Base64.decodeBase64((byte[])input);
            byte[] deBytes = cipher.doFinal(base64Bytes);
            return new String(deBytes, CHARSET);
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    private static IvParameterSpec generateParamSpec(byte[] key) {
        String md5Key = DigestUtils.md5Hex((byte[])key);
        byte[] keyBytes = md5Key.getBytes();
        byte[] ivKeyBytes = new byte[8];
        System.arraycopy(keyBytes, 0, ivKeyBytes, 0, 8);
        return new IvParameterSpec(ivKeyBytes);
    }

    private static Cipher newCipher(int mode, byte[] key) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "Blowfish");
        IvParameterSpec ivParameterSpec = Blowfish.generateParamSpec(key);
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }
}

