/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.encrypt;

import com.luna.common.encrypt.HashUtils;
import com.luna.common.reflect.ConvertUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignUtil {
    public static final String MD5 = "MD5";
    public static final String FIELD_SIGN = "sign";

    public static String generateSignedXml(Map<String, String> data, String key) throws Exception {
        return SignUtil.generateSignedXml(data, key, SignType.MD5);
    }

    public static String generateSignedXml(Map<String, String> data, String key, SignType signType) throws Exception {
        String sign = SignUtil.generateSignature(data, key, signType);
        data.put(FIELD_SIGN, sign);
        return ConvertUtil.mapToXml(data);
    }

    public static boolean isSignatureValid(String xmlStr, String key) throws Exception {
        Map<String, String> data = ConvertUtil.xmlToMap(xmlStr);
        if (!data.containsKey(FIELD_SIGN)) {
            return false;
        }
        String sign = data.get(FIELD_SIGN);
        return SignUtil.generateSignature(data, key).equals(sign);
    }

    public static boolean isSignatureValid(Map<String, String> data, String key) throws Exception {
        return SignUtil.isSignatureValid(data, key, SignType.MD5);
    }

    public static boolean isSignatureValid(Map<String, String> data, String key, SignType signType) throws Exception {
        if (!data.containsKey(FIELD_SIGN)) {
            return false;
        }
        String sign = data.get(FIELD_SIGN);
        return SignUtil.generateSignature(data, key, signType).equals(sign);
    }

    public static String generateSignature(Map<String, String> data, String key) throws Exception {
        return SignUtil.generateSignature(data, key, SignType.MD5);
    }

    public static String generateSignature(Map<String, String> data, String key, SignType signType) throws Exception {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals(FIELD_SIGN) || data.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(data.get(k).trim()).append("&");
        }
        sb.append("key=").append(key);
        if (SignType.MD5.equals((Object)signType)) {
            return HashUtils.md5(sb.toString()).toUpperCase();
        }
        if (SignType.HMACSHA256.equals((Object)signType)) {
            return SignUtil.hmacsha256(sb.toString(), key);
        }
        throw new Exception(String.format("Invalid sign_type: %s", new Object[]{signType}));
    }

    public static String hmacsha256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100), 1, 3);
        }
        return sb.toString().toUpperCase();
    }

    public static enum SignType {
        MD5,
        HMACSHA256;

    }
}

