/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.encrypt;

import com.luna.common.encrypt.EncryptUtils;
import com.luna.common.encrypt.HashMode;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class HashTools {
    public static String md5(String data) {
        return EncryptUtils.encryptByCommonIo(data, HashMode.MODE_0.getName());
    }

    public static String md5WithFile(String path, String charset) {
        return HashTools.md5(IOUtils.toInputStream((String)path, (String)charset));
    }

    public static String md5WithFile(String path) {
        return HashTools.md5WithFile(path, "UTF-8");
    }

    public static String md5(InputStream inputStream) {
        return EncryptUtils.encryptByCommonIo(inputStream, HashMode.MODE_0.getName());
    }

    public static String sha512(InputStream inputStream) {
        return EncryptUtils.encryptByCommonIo(inputStream, HashMode.MODE_2.getName());
    }

    public static String sha512(String data) {
        return EncryptUtils.encryptByCommonIo(data, HashMode.MODE_2.getName());
    }

    public static String sha512WithFile(String path, String charset) {
        return HashTools.sha512(IOUtils.toInputStream((String)path, (String)charset));
    }

    public static String sha512WithFile(String path) {
        return HashTools.sha512WithFile(path, "UTF-8");
    }

    public static String sha256(String data) {
        return EncryptUtils.encryptByCommonIo(data, HashMode.MODE_1.getName());
    }

    public static String sha256WithFile(String path, String charset) {
        return HashTools.sha256(IOUtils.toInputStream((String)path, (String)charset));
    }

    public static String sha256WithFile(String path) {
        return HashTools.sha256WithFile(path, "UTF-8");
    }

    public static String sha256(InputStream inputStream) {
        return EncryptUtils.encryptByCommonIo(inputStream, HashMode.MODE_1.getName());
    }

    public static boolean checkFileWithSHA256(InputStream path, String sha256) {
        return StringUtils.equals((CharSequence)HashTools.sha256(path), (CharSequence)sha256);
    }

    public static boolean checkFileWithSHA256(String path, String md5) {
        return StringUtils.equals((CharSequence)HashTools.sha256WithFile(path), (CharSequence)md5);
    }

    public static boolean checkFileWithMd5(InputStream path, String md5) {
        return StringUtils.equals((CharSequence)HashTools.md5(path), (CharSequence)md5);
    }

    public static boolean checkFileWithMd5(String path, String md5) {
        return StringUtils.equals((CharSequence)HashTools.md5WithFile(path), (CharSequence)md5);
    }
}

