/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.encrypt;

import com.luna.common.encrypt.Base64Util;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AesUtil.class);
    public static final String CHARSET = "UTF-8";
    public static final String CIPHER_ALGIROTHM = "AesUtil/CBC/PKCS5Padding";
    private static final String ALGORITHM = "AES";
    private static final int KEY_SIZE = 128;

    public static String generateKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            String key = Base64Util.encodeBase64(secretKey.getEncoded());
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("generateKey:: ", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String data, String key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(CHARSET), ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGIROTHM);
            cipher.init(1, secretKeySpec);
            byte[] encryptedBytes = cipher.doFinal(data.getBytes(CHARSET));
            return Base64Util.encodeBase64(encryptedBytes);
        }
        catch (Exception e) {
            log.error("encrypt::data = {}, key = {} ", new Object[]{data, key, e});
            return null;
        }
    }

    public static String decrypt(String encryptedData, String key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(CHARSET), ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGIROTHM);
            cipher.init(2, secretKeySpec);
            byte[] encryptedBytes = Base64Util.decodeBase64(encryptedData);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes, CHARSET);
        }
        catch (Exception e) {
            log.error("decrypt::encryptedData = {}, key = {} ", new Object[]{encryptedData, key, e});
            return null;
        }
    }

    public static void main(String[] args) {
        String key = AesUtil.generateKey();
        String dbPassword = "10090909091";
        String encryptDbPwd = AesUtil.encrypt(key, dbPassword);
        System.out.println("encrypt: " + encryptDbPwd);
        System.out.println("encrypt length: " + encryptDbPwd.length());
        String decrypt = AesUtil.decrypt(key, encryptDbPwd);
        System.out.println("decrypt:" + decrypt);
    }
}

