/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.dto;

import com.luna.common.dto.ResultDTO;
import java.util.Objects;

public class ResultDTOUtils<T> {
    public static <T> T checkResultAndGetData(ResultDTO<T> resultDTO) {
        if (Objects.isNull(resultDTO) || !resultDTO.isSuccess()) {
            throw new RuntimeException("code=" + resultDTO.getCode() + ", message=" + resultDTO.getMessage());
        }
        return resultDTO.getData();
    }

    public static ResultDTO<Void> success() {
        return new ResultDTO<Void>(true, 1, "success");
    }

    public static <T> ResultDTO<T> success(T object) {
        return new ResultDTO<T>(true, 1, "success", object);
    }

    public static ResultDTO<Void> success(int code, String message) {
        return new ResultDTO<Void>(true, code, message);
    }

    public static <T> ResultDTO<T> success(int code, String message, T object) {
        return new ResultDTO<T>(true, code, message, object);
    }

    public static <T> ResultDTO<T> failure(T object) {
        return new ResultDTO<T>(false, 9999, "system error", object);
    }

    public static ResultDTO<Void> failure() {
        return new ResultDTO<Void>(false, 9999, "system error");
    }

    public static ResultDTO<Void> failure(int code, String message) {
        return new ResultDTO<Void>(false, code, message);
    }

    public static <T> ResultDTO<T> failure(int code, String message, T object) {
        return new ResultDTO<T>(false, code, message, object);
    }
}

