/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.cron;

import com.luna.common.cron.CronExpression;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class CronUtil {
    public static String getCronAfterMinutes(int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, minute);
        Date scheduleTime = calendar.getTime();
        return CronUtil.getCron(scheduleTime);
    }

    public static String getCronAfterSeconds(int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, second);
        Date scheduleTime = calendar.getTime();
        return CronUtil.getCron(scheduleTime);
    }

    public static String getCron(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return CronUtil.formatDateByPattern(date, dateFormat);
    }

    private static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static String getCronEveryXMinutes(int x) {
        return String.format("0 0/%d * * * ? *", x);
    }

    public static Date formatDateByCron(String cron, long time) {
        try {
            if (CronUtil.checkCronOneTime(cron)) {
                return CronUtil.getOnceTime(cron);
            }
            return CronUtil.getLoopTime(cron, time);
        }
        catch (Exception e) {
            throw new RuntimeException("cron:" + cron, e);
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(TimeUnit.MINUTES.toMicros(20L));
        Date nextDate = null;
        for (int i = 0; i < 10; ++i) {
            long nextTime;
            long time = System.currentTimeMillis();
            if (nextDate != null && time < (nextTime = nextDate.getTime())) {
                time = nextTime;
            }
            String expreTime = "10 0 0 * * ? *";
            nextDate = CronUtil.formatDateByCron(expreTime, time);
            System.out.println(nextDate);
        }
    }

    private static Date getOnceTime(String cron) throws ParseException {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.parse(cron);
    }

    private static Date getLoopTime(String cron, long time) throws ParseException {
        CronExpression cronExpression = new CronExpression(cron);
        return cronExpression.getNextValidTimeAfter(new Date(time));
    }

    public static boolean checkCronOneTime(String cron) throws RuntimeException {
        if (StringUtils.isBlank((CharSequence)cron)) {
            return false;
        }
        String[] items = cron.split(" ");
        int length = items.length;
        if (items.length < 6) {
            throw new RuntimeException("error cron expression format");
        }
        boolean result = true;
        for (int i = 0; i < length; ++i) {
            result &= !CronUtil.containsCommonChar(items[i]);
        }
        return result;
    }

    private static boolean containsCommonChar(String cron) {
        char[] invalidCharList = new char[]{',', '-', '*', '/'};
        if (cron == null) {
            return false;
        }
        for (char chr : invalidCharList) {
            if (cron.indexOf(chr) <= -1) continue;
            return true;
        }
        return false;
    }
}

