/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.command;

import com.google.common.collect.ImmutableMap;
import com.luna.common.exception.BaseException;
import com.luna.common.os.SystemInfoUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import oshi.software.os.OSProcess;

public class ProcessUtils {
    private static final String PARAM_PHONE_REGEX = "\\$\\{\\w+\\}";

    public static void runCommand(List<String> commands) {
        commands.forEach(ProcessUtils::runCommand);
    }

    public static String processBuild(String template, Map<String, Object> params) {
        Matcher m = Pattern.compile(PARAM_PHONE_REGEX).matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 1));
            m.appendReplacement(sb, Objects.isNull(value) ? "" : value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String mkdir(String filePath) {
        return ProcessUtils.runCommand(ProcessUtils.processBuild("mkdir ${filePath}", (Map<String, Object>)ImmutableMap.of((Object)"filePath", (Object)filePath)));
    }

    public static String touch(String fileName) {
        return ProcessUtils.runCommand(ProcessUtils.processBuild("touch ${fileName}", (Map<String, Object>)ImmutableMap.of((Object)"fileName", (Object)fileName)));
    }

    public static String delete(String filePath) {
        return ProcessUtils.runCommand(ProcessUtils.processBuild("rm -rf ${filePath}", (Map<String, Object>)ImmutableMap.of((Object)"filePath", (Object)filePath)));
    }

    public static String zip(String fileName, String filePath) {
        return ProcessUtils.runCommand(ProcessUtils.processBuild("zip -q -r ${fileName} ${filePath}", (Map<String, Object>)ImmutableMap.of((Object)"fileName", (Object)fileName, (Object)"filePath", (Object)filePath)));
    }

    public static String unzip(String fileName, String filePath) {
        return ProcessUtils.runCommand(ProcessUtils.processBuild("unzip ${fileName} -d ${filePath}", (Map<String, Object>)ImmutableMap.of((Object)"fileName", (Object)fileName, (Object)"filePath", (Object)filePath)));
    }

    public static String winDelDir(String filePath) {
        return ProcessUtils.runCommand(ProcessUtils.processBuild("rd/s/q ${filePath}", (Map<String, Object>)ImmutableMap.of((Object)"filePath", (Object)filePath)));
    }

    public static String winDelFile(String fileName) {
        return ProcessUtils.runCommand(ProcessUtils.processBuild("del/f/s/q ${fileName}", (Map<String, Object>)ImmutableMap.of((Object)"filePath", (Object)fileName)));
    }

    public static String runCommand(String command) {
        try {
            String line;
            StringBuilder stringBuilder = new StringBuilder();
            Process process = Runtime.getRuntime().exec(command);
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (!StringUtils.isBlank((CharSequence)(line = input.readLine()))) {
                stringBuilder.append(line).append("\n");
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new BaseException(9999, "\u547d\u4ee4\u884c\u6267\u884c\u5f02\u5e38");
        }
    }

    public static List<OSProcess> getProcessesByFileName(String fileName) {
        String fileNameWithoutExtension = ProcessUtils.removeExtension(fileName);
        List<OSProcess> osProcessList = SystemInfoUtil.getProcesses();
        return osProcessList.stream().filter(osProcess -> StringUtils.equals((CharSequence)ProcessUtils.removeExtension(osProcess.getName()), (CharSequence)fileNameWithoutExtension)).collect(Collectors.toList());
    }

    public static List<OSProcess> getProcessesByPath(String path) {
        List<OSProcess> osProcessList = SystemInfoUtil.getProcesses();
        return osProcessList.stream().filter(osProcess -> ProcessUtils.formatPath(osProcess.getPath()).startsWith(ProcessUtils.formatPath(path))).collect(Collectors.toList());
    }

    public static String formatPath(String path) {
        return path.replace("\\", "/");
    }

    public static String removeExtension(String filename) {
        int idx = filename.lastIndexOf(".");
        if (idx == -1) {
            return filename;
        }
        return filename.substring(0, idx);
    }

    public static void killProcessGracefully(Process process, String fileName) {
        boolean hasTerminated = false;
        process.destroy();
        try {
            hasTerminated = process.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (hasTerminated) {
            return;
        }
        process.destroyForcibly();
        try {
            hasTerminated = process.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (hasTerminated) {
            return;
        }
        ProcessUtils.osKill(fileName);
        try {
            hasTerminated = process.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!hasTerminated) {
            throw new BaseException(9999, "system error");
        }
    }

    public static void osKill(String fileName) {
        List<OSProcess> osProcessList = ProcessUtils.getProcessesByFileName(fileName);
        osProcessList.forEach(osProcess -> ProcessUtils.osKill(osProcess.getProcessID()));
    }

    public static void osKill(int processId) {
        if (SystemUtils.IS_OS_WINDOWS) {
            ProcessUtils.runCommand(ProcessUtils.processBuild("taskkill /F /T /PID ${processId}", (Map<String, Object>)ImmutableMap.of((Object)"processId", (Object)processId)));
            return;
        }
        if (SystemUtils.IS_OS_LINUX) {
            ProcessUtils.runCommand(ProcessUtils.processBuild("kill -9 ${processId}", (Map<String, Object>)ImmutableMap.of((Object)"processId", (Object)processId)));
            return;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            ProcessUtils.runCommand(ProcessUtils.processBuild("kill -9 ${processId}", (Map<String, Object>)ImmutableMap.of((Object)"processId", (Object)processId)));
        }
    }

    public static void getProcessesAndKill(String path) {
        List<OSProcess> osProcessList = ProcessUtils.getProcessesByPath(path);
        osProcessList.forEach(osProcess -> ProcessUtils.osKill(osProcess.getProcessID()));
    }
}

