/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.check;

import com.luna.common.check.Assert;
import com.luna.common.exception.BaseException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AssertUtil {
    private AssertUtil() {
    }

    public static void notNull(Object object, BaseException baseException, String ... extendInfos) {
        AssertUtil.isTrue(object != null, baseException, extendInfos);
    }

    public static void notEmpty(Collection collection, BaseException baseException, String ... extendInfos) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)collection), baseException, extendInfos);
    }

    public static void notEmpty(Map map, BaseException baseException, String ... extendInfos) {
        AssertUtil.isTrue(MapUtils.isNotEmpty((Map)map), baseException, extendInfos);
    }

    public static void notBlank(String str, BaseException baseException, String ... extendInfos) {
        if (StringUtils.isBlank((CharSequence)str)) {
            AssertUtil.isTrue(false, baseException, extendInfos);
        }
    }

    public static void isFalse(boolean condition, BaseException baseException, String ... extendInfos) {
        if (condition) {
            AssertUtil.fail(baseException, extendInfos);
        }
    }

    public static void isTrue(boolean condition, BaseException baseException, String ... extendInfos) {
        if (!condition) {
            AssertUtil.fail(baseException, extendInfos);
        }
    }

    public static void fail(BaseException baseException, String ... extendInfos) {
        Assert.notNull(baseException);
        throw new BaseException(baseException, extendInfos);
    }
}

