/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.calendarist.pojo;

import com.luna.common.calendarist.pojo.CalendaristDate;
import com.luna.common.calendarist.utils.CalendaristUtils;

public class CycleDate
extends CalendaristDate {
    private String eraYear;
    private String eraMonth;
    private String eraDay;
    private String eraHour;
    private String zodiac;

    public CycleDate() {
    }

    public CycleDate(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0);
    }

    public CycleDate(int year, int month, int day, int hour, int minute, int second, int millis) {
        super(year, month, day, hour, minute, second, millis);
        this.eraYear = CalendaristUtils.ganZhi(year);
        this.eraMonth = CalendaristUtils.ganZhi(month);
        this.eraDay = CalendaristUtils.ganZhi(day);
        this.eraHour = CalendaristUtils.hourGanZhi(day, hour);
        this.zodiac = CalendaristUtils.getZodiac(year + 1864);
    }

    public String getEraYear() {
        return this.eraYear;
    }

    public void setEraYear(String eraYear) {
        this.eraYear = eraYear;
    }

    public String getEraMonth() {
        return this.eraMonth;
    }

    public void setEraMonth(String eraMonth) {
        this.eraMonth = eraMonth;
    }

    public String getEraDay() {
        return this.eraDay;
    }

    public void setEraDay(String eraDay) {
        this.eraDay = eraDay;
    }

    public String getEraHour() {
        return this.eraHour;
    }

    public void setEraHour(String eraHour) {
        this.eraHour = eraHour;
    }

    public String getZodiac() {
        return this.zodiac;
    }

    public void setZodiac(String zodiac) {
        this.zodiac = zodiac;
    }

    @Override
    public String toString() {
        String sb = "CycleDate{year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", millis=" + this.millis + ", timestamp=" + this.timestamp + ", eraYear=" + this.eraYear + ", eraMonth=" + this.eraMonth + ", eraDay=" + this.eraDay + ", eraHour=" + this.eraHour + ", zodiac=" + this.zodiac + '}';
        return sb;
    }
}

