/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class URLPathEncoder {
    private static boolean[] safe;
    private static final char[] hexadecimal;

    public static String encodePath(String path) {
        OutputStreamWriter writer;
        StringBuilder encodedPath = new StringBuilder(path.length() * 2);
        ByteArrayOutputStream utf8bytes = new ByteArrayOutputStream(10);
        try {
            writer = new OutputStreamWriter((OutputStream)utf8bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (safe[c]) {
                encodedPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                utf8bytes.reset();
                continue;
            }
            byte[] charBytes = utf8bytes.toByteArray();
            for (int j = 0; j < charBytes.length; ++j) {
                byte b = charBytes[j];
                int low = b & 0xF;
                int high = (b & 0xF0) >> 4;
                encodedPath.append('%');
                encodedPath.append(hexadecimal[high]);
                encodedPath.append(hexadecimal[low]);
            }
            utf8bytes.reset();
        }
        return encodedPath.toString();
    }

    static {
        int i;
        safe = new boolean[256];
        for (i = 97; i <= 122; ++i) {
            URLPathEncoder.safe[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            URLPathEncoder.safe[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            URLPathEncoder.safe[i] = true;
        }
        URLPathEncoder.safe[43] = true;
        URLPathEncoder.safe[46] = true;
        URLPathEncoder.safe[95] = true;
        URLPathEncoder.safe[45] = true;
        URLPathEncoder.safe[36] = true;
        URLPathEncoder.safe[44] = true;
        URLPathEncoder.safe[41] = true;
        URLPathEncoder.safe[40] = true;
        URLPathEncoder.safe[39] = true;
        URLPathEncoder.safe[42] = true;
        URLPathEncoder.safe[33] = true;
        URLPathEncoder.safe[47] = true;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

