/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.Context;
import android.graphics.ColorFilter;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StyleUtils {
    private static final int INVALID = 0;

    public static boolean checkStyleValidity(int resource) {
        return resource != 0;
    }

    public static boolean checkTextValidity(String text) {
        return !TextUtils.isEmpty((CharSequence)text);
    }

    public static int getFormatCount(String text) {
        String pattern = "%[^%]*\\d";
        Pattern compile = Pattern.compile(pattern);
        Matcher matcher = compile.matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean checkSizeValidity(int size) {
        return size > 0;
    }

    public static boolean checkArrayValidity(int[] array) {
        return array != null && array.length > 0;
    }

    public static ColorFilter getColorFilter(Context context, int color2) {
        return BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)context, (int)color2), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
    }
}

