/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.Context;
import android.os.Environment;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import java.io.File;
import java.util.HashMap;

public final class FileDirMap {
    private static final HashMap<Integer, String> dirMap = new HashMap();

    public static void init(Context context) {
        String path;
        File externalFilesDir;
        if (!ActivityCompatHelper.assertValidRequest(context)) {
            return;
        }
        if (null == dirMap.get(1)) {
            externalFilesDir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
            path = externalFilesDir != null && externalFilesDir.exists() ? externalFilesDir.getPath() : context.getCacheDir().getPath();
            dirMap.put(1, path);
        }
        if (null == dirMap.get(2)) {
            externalFilesDir = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            path = externalFilesDir != null && externalFilesDir.exists() ? externalFilesDir.getPath() : context.getCacheDir().getPath();
            dirMap.put(2, path);
        }
        if (null == dirMap.get(3)) {
            externalFilesDir = context.getExternalFilesDir(Environment.DIRECTORY_MUSIC);
            path = externalFilesDir != null && externalFilesDir.exists() ? externalFilesDir.getPath() : context.getCacheDir().getPath();
            dirMap.put(3, path);
        }
    }

    public static String getFileDirPath(Context context, int type) {
        String dir = dirMap.get(type);
        if (null == dir) {
            FileDirMap.init(context);
            dir = dirMap.get(type);
        }
        return dir;
    }

    public static void clear() {
        dirMap.clear();
    }
}

