/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.player;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.player.IMediaPlayer;
import com.luck.picture.lib.player.VideoTextureView;

public class VideoMediaPlayer
extends FrameLayout
implements TextureView.SurfaceTextureListener,
IMediaPlayer {
    private VideoTextureView textureView;
    private MediaPlayer mediaPlayer;
    private int mVideoRotation = 0;

    public VideoMediaPlayer(@NonNull Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.textureView = new VideoTextureView(this.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        layoutParams.gravity = 17;
        this.textureView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.textureView);
    }

    @Override
    public void initMediaPlayer() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new MediaPlayer();
        }
        this.textureView.setSurfaceTextureListener(this);
    }

    @Override
    public void setDataSource(Context context, String path, boolean isLoopAutoPlay) {
        try {
            if (this.mediaPlayer == null) {
                return;
            }
            if (PictureMimeType.isContent(path)) {
                this.mediaPlayer.setDataSource(context, Uri.parse((String)path));
            } else {
                this.mediaPlayer.setDataSource(path);
            }
            this.mediaPlayer.setLooping(isLoopAutoPlay);
            this.mediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCurrentPosition() {
        return this.mediaPlayer != null ? (long)this.mediaPlayer.getCurrentPosition() : 0L;
    }

    @Override
    public long getDuration() {
        return this.mediaPlayer != null ? (long)this.mediaPlayer.getDuration() : 0L;
    }

    @Override
    public void seekTo(int speed) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.seekTo(speed);
        }
    }

    @Override
    public void start() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
    }

    @Override
    public void resume() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
    }

    @Override
    public void pause() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.pause();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.mediaPlayer != null && this.mediaPlayer.isPlaying();
    }

    @Override
    public void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    @Override
    public void reset() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.reset();
        }
    }

    @Override
    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
        this.textureView.setSurfaceTextureListener(null);
    }

    @Override
    public void setOnInfoListener(IMediaPlayer.OnInfoListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnInfoListener((mp, what, extra) -> {
                listener.onInfo(this, what, extra);
                if (what == 10001) {
                    this.mVideoRotation = extra;
                }
                return false;
            });
        } else {
            this.mediaPlayer.setOnInfoListener(null);
        }
    }

    @Override
    public void setOnErrorListener(IMediaPlayer.OnErrorListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnErrorListener((mp, what, extra) -> {
                listener.onError(this, what, extra);
                return false;
            });
        } else {
            this.mediaPlayer.setOnErrorListener(null);
        }
    }

    @Override
    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnPreparedListener(mp -> listener.onPrepared(this));
        } else {
            this.mediaPlayer.setOnPreparedListener(null);
        }
    }

    @Override
    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnCompletionListener(mp -> listener.onCompletion(this));
        } else {
            this.mediaPlayer.setOnCompletionListener(null);
        }
    }

    @Override
    public void setOnVideoSizeChangedListener(IMediaPlayer.OnVideoSizeChangedListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnVideoSizeChangedListener((mp, width, height) -> {
                this.textureView.adjustVideoSize(width, height, this.mVideoRotation);
                listener.onVideoSizeChanged(this, width, height);
            });
        } else {
            this.mediaPlayer.setOnVideoSizeChangedListener(null);
        }
    }

    public void onSurfaceTextureAvailable(@NonNull SurfaceTexture surface, int width, int height) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setSurface(new Surface(surface));
        }
    }

    public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(@NonNull SurfaceTexture surface) {
        return false;
    }

    public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surface) {
    }
}

