/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.utils.SpUtils;

public class PermissionUtil {
    public static final int DEFAULT = 0;
    public static final int SUCCESS = 1;
    public static final int REFUSE = 2;
    public static final int REFUSE_PERMANENT = 3;
    public static final String ACTION_MANAGE_ALL_FILES_ACCESS_PERMISSION = "android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION";

    public static boolean hasPermissions(@NonNull Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String perm : perms) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0) continue;
            return false;
        }
        return true;
    }

    public static int getPermissionStatus(Activity activity, String permission2) {
        int flag = ActivityCompat.checkSelfPermission((Context)activity, (String)permission2);
        boolean should = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2);
        if (should) {
            return 2;
        }
        if (flag == 0) {
            return 1;
        }
        if (!SpUtils.contains((Context)activity, permission2)) {
            return 0;
        }
        return 3;
    }

    public static boolean isAllGranted(Context context, String[] permissions, int[] grantResults) {
        boolean isAllGranted = true;
        boolean skipPermissionReject = false;
        int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        if (targetSdkVersion >= 34 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_MEDIA_VISUAL_USER_SELECTED") == 0) {
            skipPermissionReject = true;
        }
        if (grantResults.length > 0) {
            for (int i = 0; i < grantResults.length; ++i) {
                if (grantResults[i] == 0) continue;
                if (!skipPermissionReject || !permissions[i].equals("android.permission.READ_MEDIA_IMAGES") && !permissions[i].equals("android.permission.READ_MEDIA_VIDEO")) {
                    isAllGranted = false;
                }
                break;
            }
        } else {
            isAllGranted = false;
        }
        return isAllGranted;
    }

    public static void goIntentSetting(Fragment fragment, int requestCode) {
        try {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            Uri uri = Uri.fromParts((String)"package", (String)fragment.getActivity().getPackageName(), null);
            intent.setData(uri);
            fragment.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

