/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.text.SpannableStringBuilder;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.engine.MediaPlayerEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.OnViewTapListener;
import com.luck.picture.lib.player.AbsController;
import com.luck.picture.lib.player.DefaultAudioPlayerEngine;
import com.luck.picture.lib.player.IMediaPlayer;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.PictureFileUtils;

public class PreviewAudioHolder
extends BasePreviewHolder {
    public TextView tvAudioName;
    public IMediaPlayer mediaPlayer;
    public AbsController controller;
    private final AbsController.OnPlayStateListener playStateListener = new AbsController.OnPlayStateListener(){

        @Override
        public void onPlayState(boolean isPlaying) {
        }
    };
    private final SeekBar.OnSeekBarChangeListener seekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
        }
    };

    public PreviewAudioHolder(@NonNull View itemView) {
        super(itemView);
        this.tvAudioName = (TextView)itemView.findViewById(R.id.tv_audio_name);
        MediaPlayerEngine audioPlayerEngine = this.selectorConfig.audioPlayerEngine != null ? this.selectorConfig.audioPlayerEngine : new DefaultAudioPlayerEngine();
        this.mediaPlayer = audioPlayerEngine.onCreateMediaPlayer(itemView.getContext());
        this.controller = audioPlayerEngine.onCreatePlayerController(itemView.getContext());
        this.attachComponent((ViewGroup)itemView);
    }

    public void attachComponent(ViewGroup group) {
        group.addView((View)this.controller);
    }

    @Override
    protected void findViews(View itemView) {
    }

    @Override
    protected void loadImage(LocalMedia media, int maxWidth, int maxHeight) {
        this.coverImageView.setEnabled(false);
        this.coverImageView.setImageResource(R.drawable.ps_ic_audio_play_cover);
    }

    @Override
    protected void onClickBackPressed() {
        this.coverImageView.setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (PreviewAudioHolder.this.mPreviewEventListener != null) {
                    PreviewAudioHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    @Override
    protected void onLongPressDownload(final LocalMedia media) {
        this.coverImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (PreviewAudioHolder.this.mPreviewEventListener != null) {
                    PreviewAudioHolder.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }

    @Override
    public void bindData(final LocalMedia media, int position) {
        String dataFormat = DateUtils.getYearDataFormat(media.getDateAddedTime());
        String fileSize = PictureFileUtils.formatAccurateUnitFileSize(media.getSize());
        this.loadImage(media, -1, -1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(media.getFileName()).append("\n").append(dataFormat).append(" - ").append(fileSize);
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)stringBuilder.toString());
        String indexOfStr = dataFormat + " - " + fileSize;
        int startIndex = stringBuilder.indexOf(indexOfStr);
        int endOf = startIndex + indexOfStr.length();
        builder.setSpan((Object)new AbsoluteSizeSpan(DensityUtil.dip2px(this.itemView.getContext(), 12.0f)), startIndex, endOf, 17);
        builder.setSpan((Object)new ForegroundColorSpan(-10132123), startIndex, endOf, 17);
        this.tvAudioName.setText((CharSequence)builder);
        this.controller.setDataSource(media);
        this.controller.setIMediaPlayer(this.mediaPlayer);
        this.controller.setOnPlayStateListener(this.playStateListener);
        this.controller.setOnSeekBarChangeListener(this.seekBarChangeListener);
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PreviewAudioHolder.this.mPreviewEventListener != null) {
                    PreviewAudioHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
        this.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PreviewAudioHolder.this.mPreviewEventListener != null) {
                    PreviewAudioHolder.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }

    public void onPlayingAudioState() {
        this.controller.start();
    }

    public void onDefaultAudioState() {
        this.controller.stop(true);
    }

    @Override
    public void onViewAttachedToWindow() {
        this.mediaPlayer.initMediaPlayer();
        this.mediaPlayer.setOnPreparedListener(new IMediaPlayer.OnPreparedListener(){

            @Override
            public void onPrepared(IMediaPlayer mp) {
                PreviewAudioHolder.this.mediaPlayer.start();
                PreviewAudioHolder.this.onPlayingAudioState();
            }
        });
        this.mediaPlayer.setOnCompletionListener(new IMediaPlayer.OnCompletionListener(){

            @Override
            public void onCompletion(IMediaPlayer mp) {
                PreviewAudioHolder.this.mediaPlayer.stop();
                PreviewAudioHolder.this.mediaPlayer.reset();
                PreviewAudioHolder.this.onDefaultAudioState();
            }
        });
        this.mediaPlayer.setOnErrorListener(new IMediaPlayer.OnErrorListener(){

            @Override
            public void onError(IMediaPlayer mp, int what, int extra) {
                PreviewAudioHolder.this.onDefaultAudioState();
            }
        });
    }

    @Override
    public void onViewDetachedFromWindow() {
        this.release();
    }

    @Override
    public void release() {
        this.mediaPlayer.setOnErrorListener(null);
        this.mediaPlayer.setOnCompletionListener(null);
        this.mediaPlayer.setOnPreparedListener(null);
        this.mediaPlayer.release();
        this.controller.setOnPlayStateListener(null);
        this.controller.setOnSeekBarChangeListener(null);
        this.onDefaultAudioState();
    }
}

