/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.PreviewAudioHolder;
import com.luck.picture.lib.adapter.holder.PreviewImageHolder;
import com.luck.picture.lib.adapter.holder.PreviewVideoHolder;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.config.SelectorProviders;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.utils.BitmapUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.MediaUtils;

public abstract class BasePreviewHolder
extends RecyclerView.ViewHolder {
    public static final int ADAPTER_TYPE_IMAGE = 1;
    public static final int ADAPTER_TYPE_VIDEO = 2;
    public static final int ADAPTER_TYPE_AUDIO = 3;
    protected final int screenWidth;
    protected final int screenHeight;
    protected final int screenAppInHeight;
    protected LocalMedia media;
    protected final SelectorConfig selectorConfig = SelectorProviders.getInstance().getSelectorConfig();
    public PhotoView coverImageView;
    protected OnPreviewEventListener mPreviewEventListener;

    public static BasePreviewHolder generate(ViewGroup parent, int viewType, int resource) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(resource, parent, false);
        if (viewType == 2) {
            return new PreviewVideoHolder(itemView);
        }
        if (viewType == 3) {
            return new PreviewAudioHolder(itemView);
        }
        return new PreviewImageHolder(itemView);
    }

    public BasePreviewHolder(@NonNull View itemView) {
        super(itemView);
        this.screenWidth = DensityUtil.getRealScreenWidth(itemView.getContext());
        this.screenHeight = DensityUtil.getScreenHeight(itemView.getContext());
        this.screenAppInHeight = DensityUtil.getRealScreenHeight(itemView.getContext());
        this.coverImageView = (PhotoView)itemView.findViewById(R.id.preview_image);
        this.findViews(itemView);
    }

    protected abstract void findViews(View var1);

    protected abstract void loadImage(LocalMedia var1, int var2, int var3);

    protected abstract void onClickBackPressed();

    protected abstract void onLongPressDownload(LocalMedia var1);

    public void bindData(LocalMedia media, int position) {
        this.media = media;
        int[] size = this.getRealSizeFromMedia(media);
        int[] maxImageSize = BitmapUtils.getMaxImageSize(size[0], size[1]);
        this.loadImage(media, maxImageSize[0], maxImageSize[1]);
        this.setScaleDisplaySize(media);
        this.setCoverScaleType(media);
        this.onClickBackPressed();
        this.onLongPressDownload(media);
    }

    protected int[] getRealSizeFromMedia(LocalMedia media) {
        if (media.isCut() && media.getCropImageWidth() > 0 && media.getCropImageHeight() > 0) {
            return new int[]{media.getCropImageWidth(), media.getCropImageHeight()};
        }
        return new int[]{media.getWidth(), media.getHeight()};
    }

    protected void setCoverScaleType(LocalMedia media) {
        if (MediaUtils.isLongImage(media.getWidth(), media.getHeight())) {
            this.coverImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        } else {
            this.coverImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
    }

    protected void setScaleDisplaySize(LocalMedia media) {
        if (!this.selectorConfig.isPreviewZoomEffect && this.screenWidth < this.screenHeight && media.getWidth() > 0 && media.getHeight() > 0) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.coverImageView.getLayoutParams();
            layoutParams.width = this.screenWidth;
            layoutParams.height = this.screenAppInHeight;
            layoutParams.gravity = 17;
        }
    }

    public void onViewAttachedToWindow() {
    }

    public void onViewDetachedFromWindow() {
    }

    public void resumePausePlay() {
    }

    public boolean isPlaying() {
        return false;
    }

    public void release() {
    }

    public void setOnPreviewEventListener(OnPreviewEventListener listener) {
        this.mPreviewEventListener = listener;
    }

    public static interface OnPreviewEventListener {
        public void onBackPressed();

        public void onPreviewVideoTitle(String var1);

        public void onLongPressDownload(LocalMedia var1);
    }
}

