/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Bundle;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import androidx.viewpager2.widget.MarginPageTransformer;
import androidx.viewpager2.widget.ViewPager2;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PicturePreviewAdapter;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.adapter.holder.PreviewGalleryAdapter;
import com.luck.picture.lib.adapter.holder.PreviewVideoHolder;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.basic.PictureMediaScannerConnection;
import com.luck.picture.lib.config.Crop;
import com.luck.picture.lib.config.InjectResourceSource;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.decoration.HorizontalItemDecoration;
import com.luck.picture.lib.decoration.WrapContentLinearLayoutManager;
import com.luck.picture.lib.dialog.PictureCommonDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.MediaExtraInfo;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.loader.IBridgeMediaLoader;
import com.luck.picture.lib.loader.LocalMediaLoader;
import com.luck.picture.lib.loader.LocalMediaPageLoader;
import com.luck.picture.lib.magical.BuildRecycleItemViewParams;
import com.luck.picture.lib.magical.MagicalView;
import com.luck.picture.lib.magical.OnMagicalViewCallback;
import com.luck.picture.lib.magical.ViewParams;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DownloadFileUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.utils.ToastUtils;
import com.luck.picture.lib.utils.ValueOf;
import com.luck.picture.lib.widget.BottomNavBar;
import com.luck.picture.lib.widget.CompleteSelectView;
import com.luck.picture.lib.widget.PreviewBottomNavBar;
import com.luck.picture.lib.widget.PreviewTitleBar;
import com.luck.picture.lib.widget.TitleBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PictureSelectorPreviewFragment
extends PictureCommonFragment {
    public static final String TAG = PictureSelectorPreviewFragment.class.getSimpleName();
    protected ArrayList<LocalMedia> mData = new ArrayList();
    protected MagicalView magicalView;
    protected ViewPager2 viewPager;
    protected PicturePreviewAdapter viewPageAdapter;
    protected PreviewBottomNavBar bottomNarBar;
    protected PreviewTitleBar titleBar;
    protected boolean isHasMore = true;
    protected int curPosition;
    protected boolean isInternalBottomPreview;
    protected boolean isSaveInstanceState;
    protected String currentAlbum;
    protected boolean isShowCamera;
    protected boolean isExternalPreview;
    protected boolean isDisplayDelete;
    protected boolean isAnimationStart;
    protected int totalNum;
    protected int screenWidth;
    protected int screenHeight;
    protected long mBucketId = -1L;
    protected TextView tvSelected;
    protected TextView tvSelectedWord;
    protected View selectClickArea;
    protected CompleteSelectView completeSelectView;
    protected boolean needScaleBig = true;
    protected boolean needScaleSmall = false;
    protected RecyclerView mGalleryRecycle;
    protected PreviewGalleryAdapter mGalleryAdapter;
    protected List<View> mAnimViews = new ArrayList<View>();
    private boolean isPause = false;
    private final ViewPager2.OnPageChangeCallback pageChangeCallback = new ViewPager2.OnPageChangeCallback(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (PictureSelectorPreviewFragment.this.mData.size() > position) {
                LocalMedia currentMedia = positionOffsetPixels < PictureSelectorPreviewFragment.this.screenWidth / 2 ? PictureSelectorPreviewFragment.this.mData.get(position) : PictureSelectorPreviewFragment.this.mData.get(position + 1);
                PictureSelectorPreviewFragment.this.tvSelected.setSelected(PictureSelectorPreviewFragment.this.isSelected(currentMedia));
                PictureSelectorPreviewFragment.this.notifyGallerySelectMedia(currentMedia);
                PictureSelectorPreviewFragment.this.notifySelectNumberStyle(currentMedia);
            }
        }

        public void onPageSelected(int position) {
            PictureSelectorPreviewFragment.this.curPosition = position;
            PictureSelectorPreviewFragment.this.titleBar.setTitle(PictureSelectorPreviewFragment.this.curPosition + 1 + "/" + PictureSelectorPreviewFragment.this.totalNum);
            if (PictureSelectorPreviewFragment.this.mData.size() > position) {
                LocalMedia currentMedia = PictureSelectorPreviewFragment.this.mData.get(position);
                PictureSelectorPreviewFragment.this.notifySelectNumberStyle(currentMedia);
                if (PictureSelectorPreviewFragment.this.isHasMagicalEffect()) {
                    PictureSelectorPreviewFragment.this.changeMagicalViewParams(position);
                }
                if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isPreviewZoomEffect) {
                    if (PictureSelectorPreviewFragment.this.isInternalBottomPreview && ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isAutoVideoPlay) {
                        PictureSelectorPreviewFragment.this.startAutoVideoPlay(position);
                    } else {
                        PictureSelectorPreviewFragment.this.viewPageAdapter.setVideoPlayButtonUI(position);
                    }
                } else if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isAutoVideoPlay) {
                    PictureSelectorPreviewFragment.this.startAutoVideoPlay(position);
                }
                PictureSelectorPreviewFragment.this.notifyGallerySelectMedia(currentMedia);
                PictureSelectorPreviewFragment.this.bottomNarBar.isDisplayEditor(PictureMimeType.isHasVideo(currentMedia.getMimeType()) || PictureMimeType.isHasAudio(currentMedia.getMimeType()));
                if (!(PictureSelectorPreviewFragment.this.isExternalPreview || PictureSelectorPreviewFragment.this.isInternalBottomPreview || ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isOnlySandboxDir || !((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isPageStrategy || !PictureSelectorPreviewFragment.this.isHasMore || position != PictureSelectorPreviewFragment.this.viewPageAdapter.getItemCount() - 1 - 10 && position != PictureSelectorPreviewFragment.this.viewPageAdapter.getItemCount() - 1)) {
                    PictureSelectorPreviewFragment.this.loadMoreData();
                }
            }
        }
    };

    public static PictureSelectorPreviewFragment newInstance() {
        PictureSelectorPreviewFragment fragment = new PictureSelectorPreviewFragment();
        fragment.setArguments(new Bundle());
        return fragment;
    }

    @Override
    public String getFragmentTag() {
        return TAG;
    }

    public void setInternalPreviewData(boolean isBottomPreview, String currentAlbumName, boolean isShowCamera, int position, int totalNum, int page, long currentBucketId, ArrayList<LocalMedia> data) {
        this.mPage = page;
        this.mBucketId = currentBucketId;
        this.mData = data;
        this.totalNum = totalNum;
        this.curPosition = position;
        this.currentAlbum = currentAlbumName;
        this.isShowCamera = isShowCamera;
        this.isInternalBottomPreview = isBottomPreview;
    }

    public void setExternalPreviewData(int position, int totalNum, ArrayList<LocalMedia> data, boolean isDisplayDelete) {
        this.mData = data;
        this.totalNum = totalNum;
        this.curPosition = position;
        this.isDisplayDelete = isDisplayDelete;
        this.isExternalPreview = true;
    }

    @Override
    public int getResourceId() {
        int layoutResourceId = InjectResourceSource.getLayoutResource(this.getContext(), 2, this.selectorConfig);
        if (layoutResourceId != 0) {
            return layoutResourceId;
        }
        return R.layout.ps_fragment_preview;
    }

    @Override
    public void onSelectedChange(boolean isAddRemove, LocalMedia currentMedia) {
        this.tvSelected.setSelected(this.selectorConfig.getSelectedResult().contains(currentMedia));
        this.bottomNarBar.setSelectedChange();
        this.completeSelectView.setSelectedChange(true);
        this.notifySelectNumberStyle(currentMedia);
        this.notifyPreviewGalleryData(isAddRemove, currentMedia);
    }

    @Override
    public void onCheckOriginalChange() {
        this.bottomNarBar.setOriginalCheck();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.reStartSavedInstance(savedInstanceState);
        this.isSaveInstanceState = savedInstanceState != null;
        this.screenWidth = DensityUtil.getRealScreenWidth(this.getContext());
        this.screenHeight = DensityUtil.getScreenHeight(this.getContext());
        this.titleBar = (PreviewTitleBar)view.findViewById(R.id.title_bar);
        this.tvSelected = (TextView)view.findViewById(R.id.ps_tv_selected);
        this.tvSelectedWord = (TextView)view.findViewById(R.id.ps_tv_selected_word);
        this.selectClickArea = view.findViewById(R.id.select_click_area);
        this.completeSelectView = (CompleteSelectView)view.findViewById(R.id.ps_complete_select);
        this.magicalView = (MagicalView)view.findViewById(R.id.magical);
        this.viewPager = new ViewPager2(this.getContext());
        this.bottomNarBar = (PreviewBottomNavBar)view.findViewById(R.id.bottom_nar_bar);
        this.magicalView.setMagicalContent((View)this.viewPager);
        this.setMagicalViewBackgroundColor();
        this.setMagicalViewAction();
        this.addAminViews(new View[]{this.titleBar, this.tvSelected, this.tvSelectedWord, this.selectClickArea, this.completeSelectView, this.bottomNarBar});
        this.onCreateLoader();
        this.initTitleBar();
        this.initViewPagerData(this.mData);
        if (this.isExternalPreview) {
            this.externalPreviewStyle();
        } else {
            this.initBottomNavBar();
            this.initPreviewSelectGallery((ViewGroup)view);
            this.initComplete();
        }
        this.iniMagicalView();
    }

    public void addAminViews(View ... views) {
        Collections.addAll(this.mAnimViews, views);
    }

    private void setMagicalViewBackgroundColor() {
        SelectMainStyle mainStyle = this.selectorConfig.selectorStyle.getSelectMainStyle();
        if (StyleUtils.checkStyleValidity(mainStyle.getPreviewBackgroundColor())) {
            this.magicalView.setBackgroundColor(mainStyle.getPreviewBackgroundColor());
        } else if (this.selectorConfig.chooseMode == SelectMimeType.ofAudio() || this.mData != null && this.mData.size() > 0 && PictureMimeType.isHasAudio(this.mData.get(0).getMimeType())) {
            this.magicalView.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_white));
        } else {
            this.magicalView.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_black));
        }
    }

    @Override
    public void reStartSavedInstance(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mPage = savedInstanceState.getInt("com.luck.picture.lib.current_page", 1);
            this.mBucketId = savedInstanceState.getLong("com.luck.picture.lib.current_bucketId", -1L);
            this.curPosition = savedInstanceState.getInt("com.luck.picture.lib.current_preview_position", this.curPosition);
            this.isShowCamera = savedInstanceState.getBoolean("com.luck.picture.lib.display_camera", this.isShowCamera);
            this.totalNum = savedInstanceState.getInt("com.luck.picture.lib.current_album_total", this.totalNum);
            this.isExternalPreview = savedInstanceState.getBoolean("com.luck.picture.lib.external_preview", this.isExternalPreview);
            this.isDisplayDelete = savedInstanceState.getBoolean("com.luck.picture.lib.external_preview_display_delete", this.isDisplayDelete);
            this.isInternalBottomPreview = savedInstanceState.getBoolean("com.luck.picture.lib.bottom_preview", this.isInternalBottomPreview);
            this.currentAlbum = savedInstanceState.getString("com.luck.picture.lib.current_album_name", "");
            if (this.mData.size() == 0) {
                this.mData.addAll(new ArrayList<LocalMedia>(this.selectorConfig.selectedPreviewResult));
            }
        }
    }

    @Override
    public void onKeyBackFragmentFinish() {
        this.onKeyDownBackToMin();
    }

    private void iniMagicalView() {
        if (this.isHasMagicalEffect()) {
            float alpha = this.isSaveInstanceState ? 1.0f : 0.0f;
            this.magicalView.setBackgroundAlpha(alpha);
            for (int i = 0; i < this.mAnimViews.size(); ++i) {
                if (this.mAnimViews.get(i) instanceof TitleBar) continue;
                this.mAnimViews.get(i).setAlpha(alpha);
            }
        } else {
            this.magicalView.setBackgroundAlpha(1.0f);
        }
    }

    private boolean isHasMagicalEffect() {
        return !this.isInternalBottomPreview && this.selectorConfig.isPreviewZoomEffect;
    }

    protected void setMagicalViewAction() {
        if (this.isHasMagicalEffect()) {
            this.magicalView.setOnMojitoViewCallback(new OnMagicalViewCallback(){

                @Override
                public void onBeginBackMinAnim() {
                    PictureSelectorPreviewFragment.this.onMojitoBeginBackMinAnim();
                }

                @Override
                public void onBeginMagicalAnimComplete(MagicalView mojitoView, boolean showImmediately) {
                    PictureSelectorPreviewFragment.this.onMojitoBeginAnimComplete(mojitoView, showImmediately);
                }

                @Override
                public void onBackgroundAlpha(float alpha) {
                    PictureSelectorPreviewFragment.this.onMojitoBackgroundAlpha(alpha);
                }

                @Override
                public void onMagicalViewFinish() {
                    PictureSelectorPreviewFragment.this.onMojitoMagicalViewFinish();
                }

                @Override
                public void onBeginBackMinMagicalFinish(boolean isResetSize) {
                    PictureSelectorPreviewFragment.this.onMojitoBeginBackMinFinish(isResetSize);
                }
            });
        }
    }

    protected void onMojitoBeginBackMinAnim() {
        BasePreviewHolder currentHolder = this.viewPageAdapter.getCurrentHolder(this.viewPager.getCurrentItem());
        if (currentHolder == null) {
            return;
        }
        if (currentHolder.coverImageView.getVisibility() == 8) {
            currentHolder.coverImageView.setVisibility(0);
        }
        if (currentHolder instanceof PreviewVideoHolder) {
            PreviewVideoHolder videoHolder = (PreviewVideoHolder)currentHolder;
            if (videoHolder.ivPlayButton.getVisibility() == 0) {
                videoHolder.ivPlayButton.setVisibility(8);
            }
        }
    }

    protected void onMojitoMagicalViewFinish() {
        if (this.isExternalPreview && this.isNormalDefaultEnter() && this.isHasMagicalEffect()) {
            this.onExitPictureSelector();
        } else {
            this.onBackCurrentFragment();
        }
    }

    protected void onMojitoBackgroundAlpha(float alpha) {
        for (int i = 0; i < this.mAnimViews.size(); ++i) {
            if (this.mAnimViews.get(i) instanceof TitleBar) continue;
            this.mAnimViews.get(i).setAlpha(alpha);
        }
    }

    protected void onMojitoBeginBackMinFinish(boolean isResetSize) {
        ViewParams itemViewParams = BuildRecycleItemViewParams.getItemViewParams(this.isShowCamera ? this.curPosition + 1 : this.curPosition);
        if (itemViewParams == null) {
            return;
        }
        BasePreviewHolder currentHolder = this.viewPageAdapter.getCurrentHolder(this.viewPager.getCurrentItem());
        if (currentHolder == null) {
            return;
        }
        currentHolder.coverImageView.getLayoutParams().width = itemViewParams.width;
        currentHolder.coverImageView.getLayoutParams().height = itemViewParams.height;
        currentHolder.coverImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
    }

    protected void onMojitoBeginAnimComplete(MagicalView mojitoView, boolean showImmediately) {
        int realHeight;
        int realWidth;
        BasePreviewHolder currentHolder = this.viewPageAdapter.getCurrentHolder(this.viewPager.getCurrentItem());
        if (currentHolder == null) {
            return;
        }
        LocalMedia media = this.mData.get(this.viewPager.getCurrentItem());
        if (media.isCut() && media.getCropImageWidth() > 0 && media.getCropImageHeight() > 0) {
            realWidth = media.getCropImageWidth();
            realHeight = media.getCropImageHeight();
        } else {
            realWidth = media.getWidth();
            realHeight = media.getHeight();
        }
        if (MediaUtils.isLongImage(realWidth, realHeight)) {
            currentHolder.coverImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        } else {
            currentHolder.coverImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        if (currentHolder instanceof PreviewVideoHolder) {
            PreviewVideoHolder videoHolder = (PreviewVideoHolder)currentHolder;
            if (this.selectorConfig.isAutoVideoPlay) {
                this.startAutoVideoPlay(this.viewPager.getCurrentItem());
            } else if (videoHolder.ivPlayButton.getVisibility() == 8 && !this.isPlaying()) {
                videoHolder.ivPlayButton.setVisibility(0);
            }
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("com.luck.picture.lib.current_page", this.mPage);
        outState.putLong("com.luck.picture.lib.current_bucketId", this.mBucketId);
        outState.putInt("com.luck.picture.lib.current_preview_position", this.curPosition);
        outState.putInt("com.luck.picture.lib.current_album_total", this.totalNum);
        outState.putBoolean("com.luck.picture.lib.external_preview", this.isExternalPreview);
        outState.putBoolean("com.luck.picture.lib.external_preview_display_delete", this.isDisplayDelete);
        outState.putBoolean("com.luck.picture.lib.display_camera", this.isShowCamera);
        outState.putBoolean("com.luck.picture.lib.bottom_preview", this.isInternalBottomPreview);
        outState.putString("com.luck.picture.lib.current_album_name", this.currentAlbum);
        this.selectorConfig.addSelectedPreviewResult(this.mData);
    }

    @Override
    @Nullable
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        if (this.isHasMagicalEffect()) {
            return null;
        }
        PictureWindowAnimationStyle windowAnimationStyle = this.selectorConfig.selectorStyle.getWindowAnimationStyle();
        if (windowAnimationStyle.activityPreviewEnterAnimation != 0 && windowAnimationStyle.activityPreviewExitAnimation != 0) {
            Animation loadAnimation = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)(enter ? windowAnimationStyle.activityPreviewEnterAnimation : windowAnimationStyle.activityPreviewExitAnimation));
            if (enter) {
                this.onEnterFragment();
            } else {
                this.onExitFragment();
            }
            return loadAnimation;
        }
        return super.onCreateAnimation(transit, enter, nextAnim);
    }

    @Override
    public void sendChangeSubSelectPositionEvent(boolean adapterChange) {
        if (this.selectorConfig.selectorStyle.getSelectMainStyle().isPreviewSelectNumberStyle() && this.selectorConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle()) {
            for (int index = 0; index < this.selectorConfig.getSelectCount(); ++index) {
                LocalMedia media = this.selectorConfig.getSelectedResult().get(index);
                media.setNum(index + 1);
            }
        }
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.isHasMagicalEffect() && this.mData.size() > this.curPosition) {
            LocalMedia media = this.mData.get(this.curPosition);
            if (PictureMimeType.isHasVideo(media.getMimeType())) {
                this.getVideoRealSizeFromMedia(media, false, new OnCallbackListener<int[]>(){

                    @Override
                    public void onCall(int[] size) {
                        PictureSelectorPreviewFragment.this.changeViewParams(size);
                    }
                });
            } else {
                this.getImageRealSizeFromMedia(media, false, new OnCallbackListener<int[]>(){

                    @Override
                    public void onCall(int[] size) {
                        PictureSelectorPreviewFragment.this.changeViewParams(size);
                    }
                });
            }
        }
    }

    private void changeViewParams(int[] size) {
        ViewParams viewParams = BuildRecycleItemViewParams.getItemViewParams(this.isShowCamera ? this.curPosition + 1 : this.curPosition);
        if (viewParams == null || size[0] == 0 || size[1] == 0) {
            this.magicalView.setViewParams(0, 0, 0, 0, size[0], size[1]);
            this.magicalView.resetStartNormal(size[0], size[1], false);
        } else {
            this.magicalView.setViewParams(viewParams.left, viewParams.top, viewParams.width, viewParams.height, size[0], size[1]);
            this.magicalView.resetStart();
        }
    }

    @Override
    public void onCreateLoader() {
        if (this.isExternalPreview) {
            return;
        }
        if (this.selectorConfig.loaderFactory != null) {
            this.mLoader = this.selectorConfig.loaderFactory.onCreateLoader();
            if (this.mLoader == null) {
                throw new NullPointerException("No available " + IBridgeMediaLoader.class + " loader found");
            }
        } else {
            this.mLoader = this.selectorConfig.isPageStrategy ? new LocalMediaPageLoader(this.getAppContext(), this.selectorConfig) : new LocalMediaLoader(this.getAppContext(), this.selectorConfig);
        }
    }

    private void loadMoreData() {
        ++this.mPage;
        if (this.selectorConfig.loaderDataEngine != null) {
            this.selectorConfig.loaderDataEngine.loadMoreMediaData(this.getContext(), this.mBucketId, this.mPage, this.selectorConfig.pageSize, this.selectorConfig.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleMoreData(result, isHasMore);
                }
            });
        } else {
            this.mLoader.loadPageMediaData(this.mBucketId, this.mPage, this.selectorConfig.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleMoreData(result, isHasMore);
                }
            });
        }
    }

    private void handleMoreData(List<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.isHasMore = isHasMore;
        if (isHasMore) {
            if (result.size() > 0) {
                int oldStartPosition = this.mData.size();
                this.mData.addAll(result);
                int itemCount = this.mData.size();
                this.viewPageAdapter.notifyItemRangeChanged(oldStartPosition, itemCount);
            } else {
                this.loadMoreData();
            }
        }
    }

    private void initComplete() {
        final SelectMainStyle selectMainStyle = this.selectorConfig.selectorStyle.getSelectMainStyle();
        if (StyleUtils.checkStyleValidity(selectMainStyle.getPreviewSelectBackground())) {
            this.tvSelected.setBackgroundResource(selectMainStyle.getPreviewSelectBackground());
        } else if (StyleUtils.checkStyleValidity(selectMainStyle.getSelectBackground())) {
            this.tvSelected.setBackgroundResource(selectMainStyle.getSelectBackground());
        }
        if (StyleUtils.checkStyleValidity(selectMainStyle.getPreviewSelectTextResId())) {
            this.tvSelectedWord.setText((CharSequence)this.getString(selectMainStyle.getPreviewSelectTextResId()));
        } else if (StyleUtils.checkTextValidity(selectMainStyle.getPreviewSelectText())) {
            this.tvSelectedWord.setText((CharSequence)selectMainStyle.getPreviewSelectText());
        } else {
            this.tvSelectedWord.setText((CharSequence)"");
        }
        if (StyleUtils.checkSizeValidity(selectMainStyle.getPreviewSelectTextSize())) {
            this.tvSelectedWord.setTextSize((float)selectMainStyle.getPreviewSelectTextSize());
        }
        if (StyleUtils.checkStyleValidity(selectMainStyle.getPreviewSelectTextColor())) {
            this.tvSelectedWord.setTextColor(selectMainStyle.getPreviewSelectTextColor());
        }
        if (StyleUtils.checkSizeValidity(selectMainStyle.getPreviewSelectMarginRight())) {
            if (this.tvSelected.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                if (this.tvSelected.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                    ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams();
                    layoutParams.rightMargin = selectMainStyle.getPreviewSelectMarginRight();
                }
            } else if (this.tvSelected.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.tvSelected.getLayoutParams();
                layoutParams.rightMargin = selectMainStyle.getPreviewSelectMarginRight();
            }
        }
        this.completeSelectView.setCompleteSelectViewStyle();
        this.completeSelectView.setSelectedChange(true);
        if (selectMainStyle.isCompleteSelectRelativeTop()) {
            if (this.completeSelectView.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topToTop = R.id.title_bar;
                ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).bottomToBottom = R.id.title_bar;
                if (this.selectorConfig.isPreviewFullScreenMode) {
                    ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
                }
            } else if (this.completeSelectView.getLayoutParams() instanceof RelativeLayout.LayoutParams && this.selectorConfig.isPreviewFullScreenMode) {
                ((RelativeLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
            }
        }
        if (selectMainStyle.isPreviewSelectRelativeBottom()) {
            if (this.tvSelected.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.selectClickArea.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.selectClickArea.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
            }
        } else if (this.selectorConfig.isPreviewFullScreenMode) {
            if (this.tvSelectedWord.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
            } else if (this.tvSelectedWord.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
                ((RelativeLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
            }
        }
        this.completeSelectView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isComplete;
                if (selectMainStyle.isCompleteSelectRelativeTop() && PictureSelectorPreviewFragment.this.selectorConfig.getSelectCount() == 0) {
                    isComplete = PictureSelectorPreviewFragment.this.confirmSelect(PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem()), false) == 0;
                } else {
                    boolean bl = isComplete = PictureSelectorPreviewFragment.this.selectorConfig.getSelectCount() > 0;
                }
                if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isEmptyResultReturn && PictureSelectorPreviewFragment.this.selectorConfig.getSelectCount() == 0) {
                    PictureSelectorPreviewFragment.this.onExitPictureSelector();
                } else if (isComplete) {
                    PictureSelectorPreviewFragment.this.dispatchTransformResult();
                }
            }
        });
    }

    private void initTitleBar() {
        if (this.selectorConfig.selectorStyle.getTitleBarStyle().isHideTitleBar()) {
            this.titleBar.setVisibility(8);
        }
        this.titleBar.setTitleBarStyle();
        this.titleBar.setOnTitleBarListener(new TitleBar.OnTitleBarListener(){

            @Override
            public void onBackPressed() {
                if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                    if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isPreviewZoomEffect) {
                        PictureSelectorPreviewFragment.this.magicalView.backToMin();
                    } else {
                        PictureSelectorPreviewFragment.this.handleExternalPreviewBack();
                    }
                } else if (!PictureSelectorPreviewFragment.this.isInternalBottomPreview && ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isPreviewZoomEffect) {
                    PictureSelectorPreviewFragment.this.magicalView.backToMin();
                } else {
                    PictureSelectorPreviewFragment.this.onBackCurrentFragment();
                }
            }
        });
        this.titleBar.setTitle(this.curPosition + 1 + "/" + this.totalNum);
        this.titleBar.getImageDelete().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PictureSelectorPreviewFragment.this.deletePreview();
            }
        });
        this.selectClickArea.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                    PictureSelectorPreviewFragment.this.deletePreview();
                } else {
                    LocalMedia currentMedia = PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                    int selectResultCode = PictureSelectorPreviewFragment.this.confirmSelect(currentMedia, PictureSelectorPreviewFragment.this.tvSelected.isSelected());
                    if (selectResultCode == 0) {
                        if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.onSelectAnimListener != null) {
                            ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.onSelectAnimListener.onSelectAnim((View)PictureSelectorPreviewFragment.this.tvSelected);
                        } else {
                            PictureSelectorPreviewFragment.this.tvSelected.startAnimation(AnimationUtils.loadAnimation((Context)PictureSelectorPreviewFragment.this.getContext(), (int)R.anim.ps_anim_modal_in));
                        }
                    }
                }
            }
        });
        this.tvSelected.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PictureSelectorPreviewFragment.this.selectClickArea.performClick();
            }
        });
    }

    protected void initPreviewSelectGallery(ViewGroup group) {
        SelectMainStyle selectMainStyle = this.selectorConfig.selectorStyle.getSelectMainStyle();
        if (selectMainStyle.isPreviewDisplaySelectGallery()) {
            this.mGalleryRecycle = new RecyclerView(this.getContext());
            if (StyleUtils.checkStyleValidity(selectMainStyle.getAdapterPreviewGalleryBackgroundResource())) {
                this.mGalleryRecycle.setBackgroundResource(selectMainStyle.getAdapterPreviewGalleryBackgroundResource());
            } else {
                this.mGalleryRecycle.setBackgroundResource(R.drawable.ps_preview_gallery_bg);
            }
            group.addView((View)this.mGalleryRecycle);
            ViewGroup.LayoutParams layoutParams = this.mGalleryRecycle.getLayoutParams();
            if (layoutParams instanceof ConstraintLayout.LayoutParams) {
                ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)layoutParams;
                params.width = -1;
                params.height = -2;
                params.bottomToTop = R.id.bottom_nar_bar;
                params.startToStart = 0;
                params.endToEnd = 0;
            }
            WrapContentLinearLayoutManager layoutManager = new WrapContentLinearLayoutManager(this.getContext()){

                public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
                    super.smoothScrollToPosition(recyclerView, state, position);
                    LinearSmoothScroller smoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

                        protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                            return 300.0f / (float)displayMetrics.densityDpi;
                        }
                    };
                    smoothScroller.setTargetPosition(position);
                    this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
                }
            };
            RecyclerView.ItemAnimator itemAnimator = this.mGalleryRecycle.getItemAnimator();
            if (itemAnimator != null) {
                ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
            }
            if (this.mGalleryRecycle.getItemDecorationCount() == 0) {
                this.mGalleryRecycle.addItemDecoration((RecyclerView.ItemDecoration)new HorizontalItemDecoration(Integer.MAX_VALUE, DensityUtil.dip2px(this.getContext(), 6.0f)));
            }
            layoutManager.setOrientation(0);
            this.mGalleryRecycle.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            if (this.selectorConfig.getSelectCount() > 0) {
                this.mGalleryRecycle.setLayoutAnimation(AnimationUtils.loadLayoutAnimation((Context)this.getContext(), (int)R.anim.ps_anim_layout_fall_enter));
            }
            this.mGalleryAdapter = new PreviewGalleryAdapter(this.selectorConfig, this.isInternalBottomPreview);
            this.notifyGallerySelectMedia(this.mData.get(this.curPosition));
            this.mGalleryRecycle.setAdapter((RecyclerView.Adapter)this.mGalleryAdapter);
            this.mGalleryAdapter.setItemClickListener(new PreviewGalleryAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(int position, LocalMedia media, View v) {
                    String albumName;
                    if (position == -1) {
                        return;
                    }
                    String string2 = albumName = TextUtils.isEmpty((CharSequence)((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.defaultAlbumName) ? PictureSelectorPreviewFragment.this.getString(R.string.ps_camera_roll) : ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.defaultAlbumName;
                    if (PictureSelectorPreviewFragment.this.isInternalBottomPreview || TextUtils.equals((CharSequence)PictureSelectorPreviewFragment.this.currentAlbum, (CharSequence)albumName) || TextUtils.equals((CharSequence)media.getParentFolderName(), (CharSequence)PictureSelectorPreviewFragment.this.currentAlbum)) {
                        int newPosition;
                        int n = PictureSelectorPreviewFragment.this.isInternalBottomPreview ? position : (newPosition = PictureSelectorPreviewFragment.this.isShowCamera ? media.position - 1 : media.position);
                        if (newPosition == PictureSelectorPreviewFragment.this.viewPager.getCurrentItem() && media.isChecked()) {
                            return;
                        }
                        LocalMedia item = PictureSelectorPreviewFragment.this.viewPageAdapter.getItem(newPosition);
                        if (!(item == null || TextUtils.equals((CharSequence)media.getPath(), (CharSequence)item.getPath()) && media.getId() == item.getId())) {
                            return;
                        }
                        if (PictureSelectorPreviewFragment.this.viewPager.getAdapter() != null) {
                            PictureSelectorPreviewFragment.this.viewPager.setAdapter(null);
                            PictureSelectorPreviewFragment.this.viewPager.setAdapter((RecyclerView.Adapter)PictureSelectorPreviewFragment.this.viewPageAdapter);
                        }
                        PictureSelectorPreviewFragment.this.viewPager.setCurrentItem(newPosition, false);
                        PictureSelectorPreviewFragment.this.notifyGallerySelectMedia(media);
                        PictureSelectorPreviewFragment.this.viewPager.post(new Runnable(){

                            @Override
                            public void run() {
                                if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isPreviewZoomEffect) {
                                    PictureSelectorPreviewFragment.this.viewPageAdapter.setVideoPlayButtonUI(newPosition);
                                }
                            }
                        });
                    }
                }
            });
            if (this.selectorConfig.getSelectCount() > 0) {
                this.mGalleryRecycle.setVisibility(0);
            } else {
                this.mGalleryRecycle.setVisibility(4);
            }
            this.addAminViews(new View[]{this.mGalleryRecycle});
            final ItemTouchHelper mItemTouchHelper = new ItemTouchHelper(new ItemTouchHelper.Callback(){

                public boolean isLongPressDragEnabled() {
                    return true;
                }

                public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
                }

                public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
                    viewHolder.itemView.setAlpha(0.7f);
                    return 13.makeMovementFlags((int)12, (int)0);
                }

                public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
                    try {
                        int fromPosition = viewHolder.getAbsoluteAdapterPosition();
                        int toPosition = target.getAbsoluteAdapterPosition();
                        if (fromPosition < toPosition) {
                            for (int i = fromPosition; i < toPosition; ++i) {
                                Collections.swap(PictureSelectorPreviewFragment.this.mGalleryAdapter.getData(), i, i + 1);
                                Collections.swap(PictureSelectorPreviewFragment.this.selectorConfig.getSelectedResult(), i, i + 1);
                                if (!PictureSelectorPreviewFragment.this.isInternalBottomPreview) continue;
                                Collections.swap(PictureSelectorPreviewFragment.this.mData, i, i + 1);
                            }
                        } else {
                            for (int i = fromPosition; i > toPosition; --i) {
                                Collections.swap(PictureSelectorPreviewFragment.this.mGalleryAdapter.getData(), i, i - 1);
                                Collections.swap(PictureSelectorPreviewFragment.this.selectorConfig.getSelectedResult(), i, i - 1);
                                if (!PictureSelectorPreviewFragment.this.isInternalBottomPreview) continue;
                                Collections.swap(PictureSelectorPreviewFragment.this.mData, i, i - 1);
                            }
                        }
                        PictureSelectorPreviewFragment.this.mGalleryAdapter.notifyItemMoved(fromPosition, toPosition);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return true;
                }

                public void onChildDraw(@NonNull Canvas c, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
                    if (PictureSelectorPreviewFragment.this.needScaleBig) {
                        PictureSelectorPreviewFragment.this.needScaleBig = false;
                        AnimatorSet animatorSet = new AnimatorSet();
                        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleX", (float[])new float[]{1.0f, 1.1f}), ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleY", (float[])new float[]{1.0f, 1.1f})});
                        animatorSet.setDuration(50L);
                        animatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
                        animatorSet.start();
                        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                PictureSelectorPreviewFragment.this.needScaleSmall = true;
                            }
                        });
                    }
                    super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
                }

                public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int actionState) {
                    super.onSelectedChanged(viewHolder, actionState);
                }

                public long getAnimationDuration(@NonNull RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
                    return super.getAnimationDuration(recyclerView, animationType, animateDx, animateDy);
                }

                public void clearView(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
                    viewHolder.itemView.setAlpha(1.0f);
                    if (PictureSelectorPreviewFragment.this.needScaleSmall) {
                        PictureSelectorPreviewFragment.this.needScaleSmall = false;
                        AnimatorSet animatorSet = new AnimatorSet();
                        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleX", (float[])new float[]{1.1f, 1.0f}), ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleY", (float[])new float[]{1.1f, 1.0f})});
                        animatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
                        animatorSet.setDuration(50L);
                        animatorSet.start();
                        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                PictureSelectorPreviewFragment.this.needScaleBig = true;
                            }
                        });
                    }
                    super.clearView(recyclerView, viewHolder);
                    PictureSelectorPreviewFragment.this.mGalleryAdapter.notifyItemChanged(viewHolder.getAbsoluteAdapterPosition());
                    if (PictureSelectorPreviewFragment.this.isInternalBottomPreview) {
                        int position = PictureSelectorPreviewFragment.this.mGalleryAdapter.getLastCheckPosition();
                        if (PictureSelectorPreviewFragment.this.viewPager.getCurrentItem() != position && position != -1) {
                            if (PictureSelectorPreviewFragment.this.viewPager.getAdapter() != null) {
                                PictureSelectorPreviewFragment.this.viewPager.setAdapter(null);
                                PictureSelectorPreviewFragment.this.viewPager.setAdapter((RecyclerView.Adapter)PictureSelectorPreviewFragment.this.viewPageAdapter);
                            }
                            PictureSelectorPreviewFragment.this.viewPager.setCurrentItem(position, false);
                        }
                    }
                    if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle() && !ActivityCompatHelper.isDestroy((Activity)PictureSelectorPreviewFragment.this.getActivity())) {
                        List fragments = PictureSelectorPreviewFragment.this.getActivity().getSupportFragmentManager().getFragments();
                        for (int i = 0; i < fragments.size(); ++i) {
                            Fragment fragment = (Fragment)fragments.get(i);
                            if (!(fragment instanceof PictureCommonFragment)) continue;
                            ((PictureCommonFragment)fragment).sendChangeSubSelectPositionEvent(true);
                        }
                    }
                }
            });
            mItemTouchHelper.attachToRecyclerView(this.mGalleryRecycle);
            this.mGalleryAdapter.setItemLongClickListener(new PreviewGalleryAdapter.OnItemLongClickListener(){

                @Override
                public void onItemLongClick(RecyclerView.ViewHolder holder, int position, View v) {
                    Vibrator vibrator = (Vibrator)PictureSelectorPreviewFragment.this.getActivity().getSystemService("vibrator");
                    vibrator.vibrate(50L);
                    if (PictureSelectorPreviewFragment.this.mGalleryAdapter.getItemCount() != ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.maxSelectNum) {
                        mItemTouchHelper.startDrag(holder);
                        return;
                    }
                    if (holder.getLayoutPosition() != PictureSelectorPreviewFragment.this.mGalleryAdapter.getItemCount() - 1) {
                        mItemTouchHelper.startDrag(holder);
                    }
                }
            });
        }
    }

    private void notifyGallerySelectMedia(LocalMedia currentMedia) {
        if (this.mGalleryAdapter != null && this.selectorConfig.selectorStyle.getSelectMainStyle().isPreviewDisplaySelectGallery()) {
            this.mGalleryAdapter.isSelectMedia(currentMedia);
        }
    }

    private void notifyPreviewGalleryData(boolean isAddRemove, LocalMedia currentMedia) {
        if (this.mGalleryAdapter != null && this.selectorConfig.selectorStyle.getSelectMainStyle().isPreviewDisplaySelectGallery()) {
            if (this.mGalleryRecycle.getVisibility() == 4) {
                this.mGalleryRecycle.setVisibility(0);
            }
            if (isAddRemove) {
                if (this.selectorConfig.selectionMode == 1) {
                    this.mGalleryAdapter.clear();
                }
                this.mGalleryAdapter.addGalleryData(currentMedia);
                this.mGalleryRecycle.smoothScrollToPosition(this.mGalleryAdapter.getItemCount() - 1);
            } else {
                this.mGalleryAdapter.removeGalleryData(currentMedia);
                if (this.selectorConfig.getSelectCount() == 0) {
                    this.mGalleryRecycle.setVisibility(4);
                }
            }
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void deletePreview() {
        if (this.isDisplayDelete && this.selectorConfig.onExternalPreviewEventListener != null) {
            this.selectorConfig.onExternalPreviewEventListener.onPreviewDelete(this.viewPager.getCurrentItem());
            int currentItem = this.viewPager.getCurrentItem();
            this.mData.remove(currentItem);
            if (this.mData.size() == 0) {
                this.handleExternalPreviewBack();
                return;
            }
            this.titleBar.setTitle(this.getString(R.string.ps_preview_image_num, new Object[]{this.curPosition + 1, this.mData.size()}));
            this.totalNum = this.mData.size();
            this.curPosition = currentItem;
            if (this.viewPager.getAdapter() != null) {
                this.viewPager.setAdapter(null);
                this.viewPager.setAdapter((RecyclerView.Adapter)this.viewPageAdapter);
            }
            this.viewPager.setCurrentItem(this.curPosition, false);
        }
    }

    private void handleExternalPreviewBack() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (this.selectorConfig.isPreviewFullScreenMode) {
                this.hideFullScreenStatusBar();
            }
            this.onExitPictureSelector();
        }
    }

    @Override
    public void onExitFragment() {
        if (this.selectorConfig.isPreviewFullScreenMode) {
            this.hideFullScreenStatusBar();
        }
    }

    private void initBottomNavBar() {
        this.bottomNarBar.setBottomNavBarStyle();
        this.bottomNarBar.setSelectedChange();
        this.bottomNarBar.setOnBottomNavBarListener(new BottomNavBar.OnBottomNavBarListener(){

            @Override
            public void onEditImage() {
                if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.onEditMediaEventListener != null) {
                    LocalMedia media = PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                    ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.onEditMediaEventListener.onStartMediaEdit(PictureSelectorPreviewFragment.this, media, 696);
                }
            }

            @Override
            public void onCheckOriginalChange() {
                PictureSelectorPreviewFragment.this.sendSelectedOriginalChangeEvent();
            }

            @Override
            public void onFirstCheckOriginalSelectedChange() {
                int currentItem = PictureSelectorPreviewFragment.this.viewPager.getCurrentItem();
                if (PictureSelectorPreviewFragment.this.mData.size() > currentItem) {
                    LocalMedia media = PictureSelectorPreviewFragment.this.mData.get(currentItem);
                    PictureSelectorPreviewFragment.this.confirmSelect(media, false);
                }
            }
        });
    }

    private void externalPreviewStyle() {
        this.titleBar.getImageDelete().setVisibility(this.isDisplayDelete ? 0 : 8);
        this.tvSelected.setVisibility(8);
        this.bottomNarBar.setVisibility(8);
        this.completeSelectView.setVisibility(8);
    }

    protected PicturePreviewAdapter createAdapter() {
        return new PicturePreviewAdapter(this.selectorConfig);
    }

    public PicturePreviewAdapter getAdapter() {
        return this.viewPageAdapter;
    }

    public ViewPager2 getViewPager2() {
        return this.viewPager;
    }

    private void initViewPagerData(ArrayList<LocalMedia> data) {
        this.viewPageAdapter = this.createAdapter();
        this.viewPageAdapter.setData(data);
        this.viewPageAdapter.setOnPreviewEventListener(new MyOnPreviewEventListener());
        this.viewPager.setOrientation(0);
        this.viewPager.setAdapter((RecyclerView.Adapter)this.viewPageAdapter);
        this.selectorConfig.selectedPreviewResult.clear();
        if (data.size() == 0 || this.curPosition >= data.size() || this.curPosition < 0) {
            this.onKeyBackFragmentFinish();
            return;
        }
        LocalMedia media = data.get(this.curPosition);
        this.bottomNarBar.isDisplayEditor(PictureMimeType.isHasVideo(media.getMimeType()) || PictureMimeType.isHasAudio(media.getMimeType()));
        this.tvSelected.setSelected(this.selectorConfig.getSelectedResult().contains(data.get(this.viewPager.getCurrentItem())));
        this.viewPager.registerOnPageChangeCallback(this.pageChangeCallback);
        this.viewPager.setPageTransformer((ViewPager2.PageTransformer)new MarginPageTransformer(DensityUtil.dip2px(this.getAppContext(), 3.0f)));
        this.viewPager.setCurrentItem(this.curPosition, false);
        this.sendChangeSubSelectPositionEvent(false);
        this.notifySelectNumberStyle(data.get(this.curPosition));
        this.startZoomEffect(media);
    }

    protected void startZoomEffect(LocalMedia media) {
        if (this.isSaveInstanceState || this.isInternalBottomPreview) {
            return;
        }
        if (this.selectorConfig.isPreviewZoomEffect) {
            this.viewPager.post(new Runnable(){

                @Override
                public void run() {
                    PictureSelectorPreviewFragment.this.viewPageAdapter.setCoverScaleType(PictureSelectorPreviewFragment.this.curPosition);
                }
            });
            if (PictureMimeType.isHasVideo(media.getMimeType())) {
                this.getVideoRealSizeFromMedia(media, !PictureMimeType.isHasHttp(media.getAvailablePath()), new OnCallbackListener<int[]>(){

                    @Override
                    public void onCall(int[] size) {
                        PictureSelectorPreviewFragment.this.start(size);
                    }
                });
            } else {
                this.getImageRealSizeFromMedia(media, !PictureMimeType.isHasHttp(media.getAvailablePath()), new OnCallbackListener<int[]>(){

                    @Override
                    public void onCall(int[] size) {
                        PictureSelectorPreviewFragment.this.start(size);
                    }
                });
            }
        }
    }

    private void start(final int[] size) {
        this.magicalView.changeRealScreenHeight(size[0], size[1], false);
        ViewParams viewParams = BuildRecycleItemViewParams.getItemViewParams(this.isShowCamera ? this.curPosition + 1 : this.curPosition);
        if (viewParams == null || size[0] == 0 && size[1] == 0) {
            this.viewPager.post(new Runnable(){

                @Override
                public void run() {
                    PictureSelectorPreviewFragment.this.magicalView.startNormal(size[0], size[1], false);
                }
            });
            this.magicalView.setBackgroundAlpha(1.0f);
            for (int i = 0; i < this.mAnimViews.size(); ++i) {
                this.mAnimViews.get(i).setAlpha(1.0f);
            }
        } else {
            this.magicalView.setViewParams(viewParams.left, viewParams.top, viewParams.width, viewParams.height, size[0], size[1]);
            this.magicalView.start(false);
        }
        ObjectAnimator.ofFloat((Object)this.viewPager, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(50L).start();
    }

    private void onKeyDownBackToMin() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (this.isExternalPreview) {
                if (this.selectorConfig.isPreviewZoomEffect) {
                    this.magicalView.backToMin();
                } else {
                    this.onExitPictureSelector();
                }
            } else if (this.isInternalBottomPreview) {
                this.onBackCurrentFragment();
            } else if (this.selectorConfig.isPreviewZoomEffect) {
                this.magicalView.backToMin();
            } else {
                this.onBackCurrentFragment();
            }
        }
    }

    private void previewFullScreenMode() {
        if (this.isAnimationStart) {
            return;
        }
        final boolean isAnimInit = this.titleBar.getTranslationY() == 0.0f;
        AnimatorSet set = new AnimatorSet();
        float titleBarForm = isAnimInit ? 0.0f : (float)(-this.titleBar.getHeight());
        float titleBarTo = isAnimInit ? (float)(-this.titleBar.getHeight()) : 0.0f;
        float alphaForm = isAnimInit ? 1.0f : 0.0f;
        float alphaTo = isAnimInit ? 0.0f : 1.0f;
        for (int i = 0; i < this.mAnimViews.size(); ++i) {
            View view = this.mAnimViews.get(i);
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{alphaForm, alphaTo})});
            if (!(view instanceof TitleBar)) continue;
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{titleBarForm, titleBarTo})});
        }
        set.setDuration(350L);
        set.start();
        this.isAnimationStart = true;
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            @SuppressLint(value={"WrongConstant"})
            public void onAnimationEnd(Animator animation) {
                PictureSelectorPreviewFragment.this.isAnimationStart = false;
                if (SdkVersionUtils.isP() && PictureSelectorPreviewFragment.this.isAdded()) {
                    Window window = PictureSelectorPreviewFragment.this.requireActivity().getWindow();
                    WindowManager.LayoutParams lp = window.getAttributes();
                    if (isAnimInit) {
                        lp.flags |= 0x400;
                        lp.layoutInDisplayCutoutMode = 1;
                        window.setAttributes(lp);
                        window.addFlags(512);
                    } else {
                        lp.flags &= 0xFFFFFBFF;
                        window.setAttributes(lp);
                        window.clearFlags(512);
                    }
                }
            }
        });
        if (isAnimInit) {
            this.showFullScreenStatusBar();
        } else {
            this.hideFullScreenStatusBar();
        }
    }

    private void showFullScreenStatusBar() {
        for (int i = 0; i < this.mAnimViews.size(); ++i) {
            this.mAnimViews.get(i).setEnabled(false);
        }
        this.bottomNarBar.getEditor().setEnabled(false);
    }

    private void hideFullScreenStatusBar() {
        for (int i = 0; i < this.mAnimViews.size(); ++i) {
            this.mAnimViews.get(i).setEnabled(true);
        }
        this.bottomNarBar.getEditor().setEnabled(true);
    }

    private void onExternalLongPressDownload(final LocalMedia media) {
        if (this.selectorConfig.onExternalPreviewEventListener != null && !this.selectorConfig.onExternalPreviewEventListener.onLongPressDownload(this.getContext(), media)) {
            String content = PictureMimeType.isHasAudio(media.getMimeType()) || PictureMimeType.isUrlHasAudio(media.getAvailablePath()) ? this.getString(R.string.ps_prompt_audio_content) : (PictureMimeType.isHasVideo(media.getMimeType()) || PictureMimeType.isUrlHasVideo(media.getAvailablePath()) ? this.getString(R.string.ps_prompt_video_content) : this.getString(R.string.ps_prompt_image_content));
            PictureCommonDialog dialog = PictureCommonDialog.showDialog(this.getContext(), this.getString(R.string.ps_prompt), content);
            dialog.setOnDialogEventListener(new PictureCommonDialog.OnDialogEventListener(){

                @Override
                public void onConfirm() {
                    String path = media.getAvailablePath();
                    if (PictureMimeType.isHasHttp(path)) {
                        PictureSelectorPreviewFragment.this.showLoading();
                    }
                    DownloadFileUtils.saveLocalFile(PictureSelectorPreviewFragment.this.getContext(), path, media.getMimeType(), new OnCallbackListener<String>(){

                        @Override
                        public void onCall(String realPath) {
                            PictureSelectorPreviewFragment.this.dismissLoading();
                            if (TextUtils.isEmpty((CharSequence)realPath)) {
                                String errorMsg = PictureMimeType.isHasAudio(media.getMimeType()) ? PictureSelectorPreviewFragment.this.getString(R.string.ps_save_audio_error) : (PictureMimeType.isHasVideo(media.getMimeType()) ? PictureSelectorPreviewFragment.this.getString(R.string.ps_save_video_error) : PictureSelectorPreviewFragment.this.getString(R.string.ps_save_image_error));
                                ToastUtils.showToast(PictureSelectorPreviewFragment.this.getContext(), errorMsg);
                            } else {
                                new PictureMediaScannerConnection((Context)PictureSelectorPreviewFragment.this.getActivity(), realPath);
                                ToastUtils.showToast(PictureSelectorPreviewFragment.this.getContext(), PictureSelectorPreviewFragment.this.getString(R.string.ps_save_success) + "\n" + realPath);
                            }
                        }
                    });
                }
            });
        }
    }

    private void startAutoVideoPlay(final int position) {
        this.viewPager.post(new Runnable(){

            @Override
            public void run() {
                PictureSelectorPreviewFragment.this.viewPageAdapter.startAutoVideoPlay(position);
            }
        });
    }

    private void changeMagicalViewParams(final int position) {
        LocalMedia media = this.mData.get(position);
        if (PictureMimeType.isHasVideo(media.getMimeType())) {
            this.getVideoRealSizeFromMedia(media, false, new OnCallbackListener<int[]>(){

                @Override
                public void onCall(int[] size) {
                    PictureSelectorPreviewFragment.this.setMagicalViewParams(size[0], size[1], position);
                }
            });
        } else {
            this.getImageRealSizeFromMedia(media, false, new OnCallbackListener<int[]>(){

                @Override
                public void onCall(int[] size) {
                    PictureSelectorPreviewFragment.this.setMagicalViewParams(size[0], size[1], position);
                }
            });
        }
    }

    private void setMagicalViewParams(int imageWidth, int imageHeight, int position) {
        this.magicalView.changeRealScreenHeight(imageWidth, imageHeight, true);
        ViewParams viewParams = BuildRecycleItemViewParams.getItemViewParams(this.isShowCamera ? position + 1 : position);
        if (viewParams == null || imageWidth == 0 || imageHeight == 0) {
            this.magicalView.setViewParams(0, 0, 0, 0, imageWidth, imageHeight);
        } else {
            this.magicalView.setViewParams(viewParams.left, viewParams.top, viewParams.width, viewParams.height, imageWidth, imageHeight);
        }
    }

    private void getImageRealSizeFromMedia(final LocalMedia media, boolean resize, final OnCallbackListener<int[]> call) {
        int realHeight;
        int realWidth;
        boolean isReturnNow = true;
        if (MediaUtils.isLongImage(media.getWidth(), media.getHeight())) {
            realWidth = this.screenWidth;
            realHeight = this.screenHeight;
        } else {
            realWidth = media.getWidth();
            realHeight = media.getHeight();
            if (resize && (realWidth <= 0 || realHeight <= 0 || realWidth > realHeight) && this.selectorConfig.isSyncWidthAndHeight) {
                isReturnNow = false;
                this.viewPager.setAlpha(0.0f);
                MediaUtils.getImageSize(this.getContext(), media.getAvailablePath(), new OnCallbackListener<MediaExtraInfo>(){

                    @Override
                    public void onCall(MediaExtraInfo extraInfo) {
                        if (extraInfo.getWidth() > 0) {
                            media.setWidth(extraInfo.getWidth());
                        }
                        if (extraInfo.getHeight() > 0) {
                            media.setHeight(extraInfo.getHeight());
                        }
                        if (call != null) {
                            call.onCall(new int[]{media.getWidth(), media.getHeight()});
                        }
                    }
                });
            }
        }
        if (media.isCut() && media.getCropImageWidth() > 0 && media.getCropImageHeight() > 0) {
            realWidth = media.getCropImageWidth();
            realHeight = media.getCropImageHeight();
        }
        if (isReturnNow) {
            call.onCall(new int[]{realWidth, realHeight});
        }
    }

    private void getVideoRealSizeFromMedia(final LocalMedia media, boolean resize, final OnCallbackListener<int[]> call) {
        boolean isReturnNow = true;
        if (resize && (media.getWidth() <= 0 || media.getHeight() <= 0 || media.getWidth() > media.getHeight()) && this.selectorConfig.isSyncWidthAndHeight) {
            isReturnNow = false;
            this.viewPager.setAlpha(0.0f);
            MediaUtils.getVideoSize(this.getContext(), media.getAvailablePath(), new OnCallbackListener<MediaExtraInfo>(){

                @Override
                public void onCall(MediaExtraInfo extraInfo) {
                    if (extraInfo.getWidth() > 0) {
                        media.setWidth(extraInfo.getWidth());
                    }
                    if (extraInfo.getHeight() > 0) {
                        media.setHeight(extraInfo.getHeight());
                    }
                    if (call != null) {
                        call.onCall(new int[]{media.getWidth(), media.getHeight()});
                    }
                }
            });
        }
        if (isReturnNow) {
            call.onCall(new int[]{media.getWidth(), media.getHeight()});
        }
    }

    public void notifySelectNumberStyle(LocalMedia currentMedia) {
        if (this.selectorConfig.selectorStyle.getSelectMainStyle().isPreviewSelectNumberStyle() && this.selectorConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle()) {
            this.tvSelected.setText((CharSequence)"");
            for (int i = 0; i < this.selectorConfig.getSelectCount(); ++i) {
                LocalMedia media = this.selectorConfig.getSelectedResult().get(i);
                if (!TextUtils.equals((CharSequence)media.getPath(), (CharSequence)currentMedia.getPath()) && media.getId() != currentMedia.getId()) continue;
                currentMedia.setNum(media.getNum());
                media.setPosition(currentMedia.getPosition());
                this.tvSelected.setText((CharSequence)ValueOf.toString(currentMedia.getNum()));
            }
        }
    }

    protected boolean isSelected(LocalMedia media) {
        return this.selectorConfig.getSelectedResult().contains(media);
    }

    @Override
    public void onEditMedia(Intent data) {
        if (this.mData.size() > this.viewPager.getCurrentItem()) {
            LocalMedia currentMedia = this.mData.get(this.viewPager.getCurrentItem());
            Uri output = Crop.getOutput(data);
            currentMedia.setCutPath(output != null ? output.getPath() : "");
            currentMedia.setCropImageWidth(Crop.getOutputImageWidth(data));
            currentMedia.setCropImageHeight(Crop.getOutputImageHeight(data));
            currentMedia.setCropOffsetX(Crop.getOutputImageOffsetX(data));
            currentMedia.setCropOffsetY(Crop.getOutputImageOffsetY(data));
            currentMedia.setCropResultAspectRatio(Crop.getOutputCropAspectRatio(data));
            currentMedia.setCut(!TextUtils.isEmpty((CharSequence)currentMedia.getCutPath()));
            currentMedia.setCustomData(Crop.getOutputCustomExtraData(data));
            currentMedia.setEditorImage(currentMedia.isCut());
            currentMedia.setSandboxPath(currentMedia.getCutPath());
            if (this.selectorConfig.getSelectedResult().contains(currentMedia)) {
                LocalMedia exitsMedia = currentMedia.getCompareLocalMedia();
                if (exitsMedia != null) {
                    exitsMedia.setCutPath(currentMedia.getCutPath());
                    exitsMedia.setCut(currentMedia.isCut());
                    exitsMedia.setEditorImage(currentMedia.isEditorImage());
                    exitsMedia.setCustomData(currentMedia.getCustomData());
                    exitsMedia.setSandboxPath(currentMedia.getCutPath());
                    exitsMedia.setCropImageWidth(Crop.getOutputImageWidth(data));
                    exitsMedia.setCropImageHeight(Crop.getOutputImageHeight(data));
                    exitsMedia.setCropOffsetX(Crop.getOutputImageOffsetX(data));
                    exitsMedia.setCropOffsetY(Crop.getOutputImageOffsetY(data));
                    exitsMedia.setCropResultAspectRatio(Crop.getOutputCropAspectRatio(data));
                }
                this.sendFixedSelectedChangeEvent(currentMedia);
            } else {
                this.confirmSelect(currentMedia, false);
            }
            this.viewPageAdapter.notifyItemChanged(this.viewPager.getCurrentItem());
            this.notifyGallerySelectMedia(currentMedia);
        }
    }

    @Override
    protected void onExitPictureSelector() {
        if (this.viewPageAdapter != null) {
            this.viewPageAdapter.destroy();
        }
        super.onExitPictureSelector();
    }

    public void onResume() {
        super.onResume();
        if (this.isPause) {
            this.resumePausePlay();
            this.isPause = false;
        }
    }

    public void onPause() {
        super.onPause();
        if (this.isPlaying()) {
            this.resumePausePlay();
            this.isPause = true;
        }
    }

    private void resumePausePlay() {
        BasePreviewHolder holder;
        if (this.viewPageAdapter != null && (holder = this.viewPageAdapter.getCurrentHolder(this.viewPager.getCurrentItem())) != null) {
            holder.resumePausePlay();
        }
    }

    private boolean isPlaying() {
        return this.viewPageAdapter != null && this.viewPageAdapter.isPlaying(this.viewPager.getCurrentItem());
    }

    @Override
    public void onDestroy() {
        if (this.viewPageAdapter != null) {
            this.viewPageAdapter.destroy();
        }
        if (this.viewPager != null) {
            this.viewPager.unregisterOnPageChangeCallback(this.pageChangeCallback);
        }
        super.onDestroy();
    }

    private class MyOnPreviewEventListener
    implements BasePreviewHolder.OnPreviewEventListener {
        private MyOnPreviewEventListener() {
        }

        @Override
        public void onBackPressed() {
            if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isPreviewFullScreenMode) {
                PictureSelectorPreviewFragment.this.previewFullScreenMode();
            } else if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isPreviewZoomEffect) {
                    PictureSelectorPreviewFragment.this.magicalView.backToMin();
                } else {
                    PictureSelectorPreviewFragment.this.handleExternalPreviewBack();
                }
            } else if (!PictureSelectorPreviewFragment.this.isInternalBottomPreview && ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isPreviewZoomEffect) {
                PictureSelectorPreviewFragment.this.magicalView.backToMin();
            } else {
                PictureSelectorPreviewFragment.this.onBackCurrentFragment();
            }
        }

        @Override
        public void onPreviewVideoTitle(String videoName) {
            if (TextUtils.isEmpty((CharSequence)videoName)) {
                PictureSelectorPreviewFragment.this.titleBar.setTitle(PictureSelectorPreviewFragment.this.curPosition + 1 + "/" + PictureSelectorPreviewFragment.this.totalNum);
            } else {
                PictureSelectorPreviewFragment.this.titleBar.setTitle(videoName);
            }
        }

        @Override
        public void onLongPressDownload(LocalMedia media) {
            if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).selectorConfig.isHidePreviewDownload) {
                return;
            }
            if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                PictureSelectorPreviewFragment.this.onExternalLongPressDownload(media);
            }
        }
    }
}

