/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.magical;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public class MagicalViewWrapper {
    private final ViewGroup.MarginLayoutParams params;
    private final View viewWrapper;

    public MagicalViewWrapper(View view) {
        this.viewWrapper = view;
        this.params = (ViewGroup.MarginLayoutParams)this.viewWrapper.getLayoutParams();
        if (this.params instanceof LinearLayout.LayoutParams) {
            ((LinearLayout.LayoutParams)this.params).gravity = 0x800003;
        }
    }

    public int getWidth() {
        return this.params.width;
    }

    public int getHeight() {
        return this.params.height;
    }

    public void setWidth(float width) {
        this.params.width = Math.round(width);
        this.viewWrapper.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public void setHeight(float height) {
        this.params.height = Math.round(height);
        this.viewWrapper.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public void setMarginTop(int m) {
        this.params.topMargin = m;
        this.viewWrapper.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public void setMarginBottom(int m) {
        this.params.bottomMargin = m;
        this.viewWrapper.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public int getMarginTop() {
        return this.params.topMargin;
    }

    public void setMarginRight(int mr) {
        this.params.rightMargin = mr;
        this.viewWrapper.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public void setMarginLeft(int mr) {
        this.params.leftMargin = mr;
        this.viewWrapper.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public int getMarginRight() {
        return this.params.rightMargin;
    }

    public int getMarginLeft() {
        return this.params.leftMargin;
    }

    public int getMarginBottom() {
        return this.params.bottomMargin;
    }
}

