/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.config;

import com.luck.picture.lib.config.SelectorConfig;
import java.util.LinkedList;

public class SelectorProviders {
    private final LinkedList<SelectorConfig> selectionConfigsQueue = new LinkedList();
    private static volatile SelectorProviders selectorProviders;

    public void addSelectorConfigQueue(SelectorConfig config) {
        this.selectionConfigsQueue.add(config);
    }

    public SelectorConfig getSelectorConfig() {
        return this.selectionConfigsQueue.size() > 0 ? this.selectionConfigsQueue.getLast() : null;
    }

    public void destroy() {
        SelectorConfig selectorConfig = this.getSelectorConfig();
        if (selectorConfig != null) {
            selectorConfig.destroy();
            this.selectionConfigsQueue.remove(selectorConfig);
        }
    }

    public void reset() {
        for (int i = 0; i < this.selectionConfigsQueue.size(); ++i) {
            SelectorConfig selectorConfig = this.selectionConfigsQueue.get(i);
            if (selectorConfig == null) continue;
            selectorConfig.destroy();
        }
        this.selectionConfigsQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SelectorProviders getInstance() {
        if (selectorProviders != null) return selectorProviders;
        Class<SelectorProviders> clazz = SelectorProviders.class;
        synchronized (SelectorProviders.class) {
            if (selectorProviders != null) return selectorProviders;
            selectorProviders = new SelectorProviders();
            // ** MonitorExit[var0] (shouldn't be in output)
            return selectorProviders;
        }
    }
}

