/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.luck.picture.lib.basic.PictureSelectionCameraModel;
import com.luck.picture.lib.basic.PictureSelectionModel;
import com.luck.picture.lib.basic.PictureSelectionPreviewModel;
import com.luck.picture.lib.basic.PictureSelectionQueryModel;
import com.luck.picture.lib.basic.PictureSelectionSystemModel;
import com.luck.picture.lib.entity.LocalMedia;
import java.lang.ref.SoftReference;
import java.util.ArrayList;

public final class PictureSelector {
    private final SoftReference<Activity> mActivity;
    private final SoftReference<Fragment> mFragment;

    private PictureSelector(Activity activity) {
        this(activity, null);
    }

    private PictureSelector(Fragment fragment) {
        this((Activity)fragment.getActivity(), fragment);
    }

    private PictureSelector(Activity activity, Fragment fragment) {
        this.mActivity = new SoftReference<Activity>(activity);
        this.mFragment = new SoftReference<Fragment>(fragment);
    }

    public static PictureSelector create(Context context) {
        return new PictureSelector((Activity)context);
    }

    public static PictureSelector create(AppCompatActivity activity) {
        return new PictureSelector((Activity)activity);
    }

    public static PictureSelector create(FragmentActivity activity) {
        return new PictureSelector((Activity)activity);
    }

    public static PictureSelector create(Fragment fragment) {
        return new PictureSelector(fragment);
    }

    public PictureSelectionModel openGallery(int chooseMode) {
        return new PictureSelectionModel(this, chooseMode);
    }

    public PictureSelectionCameraModel openCamera(int chooseMode) {
        return new PictureSelectionCameraModel(this, chooseMode);
    }

    public PictureSelectionSystemModel openSystemGallery(int chooseMode) {
        return new PictureSelectionSystemModel(this, chooseMode);
    }

    public PictureSelectionQueryModel dataSource(int selectMimeType) {
        return new PictureSelectionQueryModel(this, selectMimeType);
    }

    public PictureSelectionPreviewModel openPreview() {
        return new PictureSelectionPreviewModel(this);
    }

    public static Intent putIntentResult(ArrayList<LocalMedia> data) {
        return new Intent().putParcelableArrayListExtra("extra_result_media", data);
    }

    public static ArrayList<LocalMedia> obtainSelectorList(Intent intent) {
        if (intent == null) {
            return new ArrayList<LocalMedia>();
        }
        ArrayList result = intent.getParcelableArrayListExtra("extra_result_media");
        return result != null ? result : new ArrayList();
    }

    @Nullable
    Activity getActivity() {
        return this.mActivity.get();
    }

    @Nullable
    Fragment getFragment() {
        return this.mFragment != null ? this.mFragment.get() : null;
    }
}

