/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.config.SelectorProviders;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.style.BottomNavBarStyle;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.PictureFileUtils;
import com.luck.picture.lib.utils.StyleUtils;

public class BottomNavBar
extends RelativeLayout
implements View.OnClickListener {
    protected TextView tvPreview;
    protected TextView tvImageEditor;
    private CheckBox originalCheckbox;
    protected SelectorConfig config;
    protected OnBottomNavBarListener bottomNavBarListener;

    public BottomNavBar(Context context) {
        super(context);
        this.init();
    }

    public BottomNavBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BottomNavBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void init() {
        this.inflateLayout();
        this.setClickable(true);
        this.setFocusable(true);
        this.config = SelectorProviders.getInstance().getSelectorConfig();
        this.tvPreview = (TextView)this.findViewById(R.id.ps_tv_preview);
        this.tvImageEditor = (TextView)this.findViewById(R.id.ps_tv_editor);
        this.originalCheckbox = (CheckBox)this.findViewById(R.id.cb_original);
        this.tvPreview.setOnClickListener((View.OnClickListener)this);
        this.tvImageEditor.setVisibility(8);
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_grey));
        this.originalCheckbox.setChecked(this.config.isCheckOriginalImage);
        this.originalCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
                BottomNavBar.this.config.isCheckOriginalImage = isChecked;
                BottomNavBar.this.originalCheckbox.setChecked(BottomNavBar.this.config.isCheckOriginalImage);
                if (BottomNavBar.this.bottomNavBarListener != null) {
                    BottomNavBar.this.bottomNavBarListener.onCheckOriginalChange();
                    if (isChecked && BottomNavBar.this.config.getSelectCount() == 0) {
                        BottomNavBar.this.bottomNavBarListener.onFirstCheckOriginalSelectedChange();
                    }
                }
            }
        });
        this.handleLayoutUI();
    }

    protected void inflateLayout() {
        BottomNavBar.inflate((Context)this.getContext(), (int)R.layout.ps_bottom_nav_bar, (ViewGroup)this);
    }

    protected void handleLayoutUI() {
    }

    public void setBottomNavBarStyle() {
        int originalTextColor;
        int originalTextSize;
        String originalText;
        int originalDrawableLeft;
        int editorTextColor;
        int editorTextSize;
        String editorText;
        String bottomPreviewText;
        int previewTextSize;
        int previewNormalTextColor;
        int narBarHeight;
        if (this.config.isDirectReturnSingle) {
            this.setVisibility(8);
            return;
        }
        PictureSelectorStyle selectorStyle = this.config.selectorStyle;
        BottomNavBarStyle bottomBarStyle = selectorStyle.getBottomBarStyle();
        if (this.config.isOriginalControl) {
            int originalTextColor2;
            int originalTextSize2;
            String bottomOriginalText;
            this.originalCheckbox.setVisibility(0);
            int originalDrawableLeft2 = bottomBarStyle.getBottomOriginalDrawableLeft();
            if (StyleUtils.checkStyleValidity(originalDrawableLeft2)) {
                this.originalCheckbox.setButtonDrawable(originalDrawableLeft2);
            }
            if (StyleUtils.checkTextValidity(bottomOriginalText = bottomBarStyle.getBottomOriginalText())) {
                this.originalCheckbox.setText((CharSequence)bottomOriginalText);
            }
            if (StyleUtils.checkSizeValidity(originalTextSize2 = bottomBarStyle.getBottomOriginalTextSize())) {
                this.originalCheckbox.setTextSize((float)originalTextSize2);
            }
            if (StyleUtils.checkStyleValidity(originalTextColor2 = bottomBarStyle.getBottomOriginalTextColor())) {
                this.originalCheckbox.setTextColor(originalTextColor2);
            }
        }
        this.getLayoutParams().height = StyleUtils.checkSizeValidity(narBarHeight = bottomBarStyle.getBottomNarBarHeight()) ? narBarHeight : DensityUtil.dip2px(this.getContext(), 46.0f);
        int backgroundColor = bottomBarStyle.getBottomNarBarBackgroundColor();
        if (StyleUtils.checkStyleValidity(backgroundColor)) {
            this.setBackgroundColor(backgroundColor);
        }
        if (StyleUtils.checkStyleValidity(previewNormalTextColor = bottomBarStyle.getBottomPreviewNormalTextColor())) {
            this.tvPreview.setTextColor(previewNormalTextColor);
        }
        if (StyleUtils.checkSizeValidity(previewTextSize = bottomBarStyle.getBottomPreviewNormalTextSize())) {
            this.tvPreview.setTextSize((float)previewTextSize);
        }
        if (StyleUtils.checkTextValidity(bottomPreviewText = bottomBarStyle.getBottomPreviewNormalText())) {
            this.tvPreview.setText((CharSequence)bottomPreviewText);
        }
        if (StyleUtils.checkTextValidity(editorText = bottomBarStyle.getBottomEditorText())) {
            this.tvImageEditor.setText((CharSequence)editorText);
        }
        if (StyleUtils.checkSizeValidity(editorTextSize = bottomBarStyle.getBottomEditorTextSize())) {
            this.tvImageEditor.setTextSize((float)editorTextSize);
        }
        if (StyleUtils.checkStyleValidity(editorTextColor = bottomBarStyle.getBottomEditorTextColor())) {
            this.tvImageEditor.setTextColor(editorTextColor);
        }
        if (StyleUtils.checkStyleValidity(originalDrawableLeft = bottomBarStyle.getBottomOriginalDrawableLeft())) {
            this.originalCheckbox.setButtonDrawable(originalDrawableLeft);
        }
        if (StyleUtils.checkTextValidity(originalText = bottomBarStyle.getBottomOriginalText())) {
            this.originalCheckbox.setText((CharSequence)originalText);
        }
        if (StyleUtils.checkSizeValidity(originalTextSize = bottomBarStyle.getBottomOriginalTextSize())) {
            this.originalCheckbox.setTextSize((float)originalTextSize);
        }
        if (StyleUtils.checkStyleValidity(originalTextColor = bottomBarStyle.getBottomOriginalTextColor())) {
            this.originalCheckbox.setTextColor(originalTextColor);
        }
    }

    public void setOriginalCheck() {
        this.originalCheckbox.setChecked(this.config.isCheckOriginalImage);
    }

    public void setSelectedChange() {
        this.calculateFileTotalSize();
        PictureSelectorStyle selectorStyle = this.config.selectorStyle;
        BottomNavBarStyle bottomBarStyle = selectorStyle.getBottomBarStyle();
        if (this.config.getSelectCount() > 0) {
            this.tvPreview.setEnabled(true);
            int previewSelectTextColor = bottomBarStyle.getBottomPreviewSelectTextColor();
            if (StyleUtils.checkStyleValidity(previewSelectTextColor)) {
                this.tvPreview.setTextColor(previewSelectTextColor);
            } else {
                this.tvPreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_fa632d));
            }
            String previewSelectText = bottomBarStyle.getBottomPreviewSelectText();
            if (StyleUtils.checkTextValidity(previewSelectText)) {
                if (StyleUtils.checkTextFormatValidity(previewSelectText)) {
                    this.tvPreview.setText((CharSequence)String.format(previewSelectText, this.config.getSelectCount()));
                } else {
                    this.tvPreview.setText((CharSequence)previewSelectText);
                }
            } else {
                this.tvPreview.setText((CharSequence)this.getContext().getString(R.string.ps_preview_num, new Object[]{this.config.getSelectCount()}));
            }
        } else {
            this.tvPreview.setEnabled(false);
            int previewNormalTextColor = bottomBarStyle.getBottomPreviewNormalTextColor();
            if (StyleUtils.checkStyleValidity(previewNormalTextColor)) {
                this.tvPreview.setTextColor(previewNormalTextColor);
            } else {
                this.tvPreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_9b));
            }
            String previewText = bottomBarStyle.getBottomPreviewNormalText();
            if (StyleUtils.checkTextValidity(previewText)) {
                this.tvPreview.setText((CharSequence)previewText);
            } else {
                this.tvPreview.setText((CharSequence)this.getContext().getString(R.string.ps_preview));
            }
        }
    }

    private void calculateFileTotalSize() {
        if (this.config.isOriginalControl) {
            long totalSize = 0L;
            for (int i = 0; i < this.config.getSelectCount(); ++i) {
                LocalMedia media = this.config.getSelectedResult().get(i);
                totalSize += media.getSize();
            }
            if (totalSize > 0L) {
                String fileSize = PictureFileUtils.formatAccurateUnitFileSize(totalSize);
                this.originalCheckbox.setText((CharSequence)this.getContext().getString(R.string.ps_original_image, new Object[]{fileSize}));
            } else {
                this.originalCheckbox.setText((CharSequence)this.getContext().getString(R.string.ps_default_original_image));
            }
        } else {
            this.originalCheckbox.setText((CharSequence)this.getContext().getString(R.string.ps_default_original_image));
        }
    }

    public void onClick(View view) {
        if (this.bottomNavBarListener == null) {
            return;
        }
        int id2 = view.getId();
        if (id2 == R.id.ps_tv_preview) {
            this.bottomNavBarListener.onPreview();
        }
    }

    public void setOnBottomNavBarListener(OnBottomNavBarListener listener) {
        this.bottomNavBarListener = listener;
    }

    public static class OnBottomNavBarListener {
        public void onPreview() {
        }

        public void onEditImage() {
        }

        public void onCheckOriginalChange() {
        }

        public void onFirstCheckOriginalSelectedChange() {
        }
    }
}

