/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.content.Context;
import android.graphics.ColorFilter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.adapter.holder.AudioViewHolder;
import com.luck.picture.lib.adapter.holder.CameraViewHolder;
import com.luck.picture.lib.adapter.holder.ImageViewHolder;
import com.luck.picture.lib.adapter.holder.VideoViewHolder;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.AnimUtils;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.util.ArrayList;

public class BaseRecyclerMediaHolder
extends RecyclerView.ViewHolder {
    public ImageView ivPicture;
    public TextView tvCheck;
    public View btnCheck;
    public Context mContext;
    public SelectorConfig selectorConfig;
    public boolean isSelectNumberStyle;
    public boolean isHandleMask;
    private ColorFilter defaultColorFilter;
    private ColorFilter selectColorFilter;
    private ColorFilter maskWhiteColorFilter;
    private PictureImageGridAdapter.OnItemClickListener listener;

    public static BaseRecyclerMediaHolder generate(ViewGroup parent, int viewType, int resource, SelectorConfig config) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(resource, parent, false);
        switch (viewType) {
            case 1: {
                return new CameraViewHolder(itemView);
            }
            case 3: {
                return new VideoViewHolder(itemView, config);
            }
            case 4: {
                return new AudioViewHolder(itemView, config);
            }
        }
        return new ImageViewHolder(itemView, config);
    }

    public BaseRecyclerMediaHolder(@NonNull View itemView) {
        super(itemView);
    }

    public BaseRecyclerMediaHolder(@NonNull View itemView, SelectorConfig config) {
        super(itemView);
        int[] selectStyleGravity;
        int adapterSelectBackground;
        int textColor;
        this.selectorConfig = config;
        this.mContext = itemView.getContext();
        this.defaultColorFilter = StyleUtils.getColorFilter(this.mContext, R.color.ps_color_20);
        this.selectColorFilter = StyleUtils.getColorFilter(this.mContext, R.color.ps_color_80);
        this.maskWhiteColorFilter = StyleUtils.getColorFilter(this.mContext, R.color.ps_color_half_white);
        SelectMainStyle selectMainStyle = this.selectorConfig.selectorStyle.getSelectMainStyle();
        this.isSelectNumberStyle = selectMainStyle.isSelectNumberStyle();
        this.ivPicture = (ImageView)itemView.findViewById(R.id.ivPicture);
        this.tvCheck = (TextView)itemView.findViewById(R.id.tvCheck);
        this.btnCheck = itemView.findViewById(R.id.btnCheck);
        if (config.selectionMode == 1 && config.isDirectReturnSingle) {
            this.tvCheck.setVisibility(8);
            this.btnCheck.setVisibility(8);
        } else {
            this.tvCheck.setVisibility(0);
            this.btnCheck.setVisibility(0);
        }
        this.isHandleMask = !config.isDirectReturnSingle && (config.selectionMode == 1 || config.selectionMode == 2);
        int textSize = selectMainStyle.getAdapterSelectTextSize();
        if (StyleUtils.checkSizeValidity(textSize)) {
            this.tvCheck.setTextSize((float)textSize);
        }
        if (StyleUtils.checkStyleValidity(textColor = selectMainStyle.getAdapterSelectTextColor())) {
            this.tvCheck.setTextColor(textColor);
        }
        if (StyleUtils.checkStyleValidity(adapterSelectBackground = selectMainStyle.getSelectBackground())) {
            this.tvCheck.setBackgroundResource(adapterSelectBackground);
        }
        if (StyleUtils.checkArrayValidity(selectStyleGravity = selectMainStyle.getAdapterSelectStyleGravity())) {
            int clickArea;
            if (this.tvCheck.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
                ((RelativeLayout.LayoutParams)this.tvCheck.getLayoutParams()).removeRule(21);
                for (int i : selectStyleGravity) {
                    ((RelativeLayout.LayoutParams)this.tvCheck.getLayoutParams()).addRule(i);
                }
            }
            if (this.btnCheck.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
                ((RelativeLayout.LayoutParams)this.btnCheck.getLayoutParams()).removeRule(21);
                for (int i : selectStyleGravity) {
                    ((RelativeLayout.LayoutParams)this.btnCheck.getLayoutParams()).addRule(i);
                }
            }
            if (StyleUtils.checkSizeValidity(clickArea = selectMainStyle.getAdapterSelectClickArea())) {
                ViewGroup.LayoutParams clickAreaParams = this.btnCheck.getLayoutParams();
                clickAreaParams.width = clickArea;
                clickAreaParams.height = clickArea;
            }
        }
    }

    public void bindData(final LocalMedia media, final int position) {
        media.position = this.getAbsoluteAdapterPosition();
        this.selectedMedia(this.isSelected(media));
        if (this.isSelectNumberStyle) {
            this.notifySelectNumberStyle(media);
        }
        if (this.isHandleMask && this.selectorConfig.isMaxSelectEnabledMask) {
            this.dispatchHandleMask(media);
        }
        String path = media.getPath();
        if (media.isEditorImage()) {
            path = media.getCutPath();
        }
        this.loadCover(path);
        this.tvCheck.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BaseRecyclerMediaHolder.this.btnCheck.performClick();
            }
        });
        this.btnCheck.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (media.isMaxSelectEnabledMask() || BaseRecyclerMediaHolder.this.listener == null) {
                    return;
                }
                int resultCode = BaseRecyclerMediaHolder.this.listener.onSelected((View)BaseRecyclerMediaHolder.this.tvCheck, position, media);
                if (resultCode == -1) {
                    return;
                }
                if (resultCode == 0) {
                    if (BaseRecyclerMediaHolder.this.selectorConfig.isSelectZoomAnim) {
                        if (BaseRecyclerMediaHolder.this.selectorConfig.onItemSelectAnimListener != null) {
                            BaseRecyclerMediaHolder.this.selectorConfig.onItemSelectAnimListener.onSelectItemAnim((View)BaseRecyclerMediaHolder.this.ivPicture, true);
                        } else {
                            AnimUtils.selectZoom((View)BaseRecyclerMediaHolder.this.ivPicture);
                        }
                    }
                } else if (resultCode == 1 && BaseRecyclerMediaHolder.this.selectorConfig.isSelectZoomAnim && BaseRecyclerMediaHolder.this.selectorConfig.onItemSelectAnimListener != null) {
                    BaseRecyclerMediaHolder.this.selectorConfig.onItemSelectAnimListener.onSelectItemAnim((View)BaseRecyclerMediaHolder.this.ivPicture, false);
                }
                BaseRecyclerMediaHolder.this.selectedMedia(BaseRecyclerMediaHolder.this.isSelected(media));
            }
        });
        this.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (BaseRecyclerMediaHolder.this.listener != null) {
                    BaseRecyclerMediaHolder.this.listener.onItemLongClick(v, position);
                }
                return false;
            }
        });
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isPreview;
                if (media.isMaxSelectEnabledMask() || BaseRecyclerMediaHolder.this.listener == null) {
                    return;
                }
                boolean bl = isPreview = PictureMimeType.isHasImage(media.getMimeType()) && BaseRecyclerMediaHolder.this.selectorConfig.isEnablePreviewImage || BaseRecyclerMediaHolder.this.selectorConfig.isDirectReturnSingle || PictureMimeType.isHasVideo(media.getMimeType()) && (BaseRecyclerMediaHolder.this.selectorConfig.isEnablePreviewVideo || BaseRecyclerMediaHolder.this.selectorConfig.selectionMode == 1) || PictureMimeType.isHasAudio(media.getMimeType()) && (BaseRecyclerMediaHolder.this.selectorConfig.isEnablePreviewAudio || BaseRecyclerMediaHolder.this.selectorConfig.selectionMode == 1);
                if (isPreview) {
                    BaseRecyclerMediaHolder.this.listener.onItemClick((View)BaseRecyclerMediaHolder.this.tvCheck, position, media);
                } else {
                    BaseRecyclerMediaHolder.this.btnCheck.performClick();
                }
            }
        });
    }

    protected void loadCover(String path) {
        if (this.selectorConfig.imageEngine != null) {
            this.selectorConfig.imageEngine.loadGridImage(this.ivPicture.getContext(), path, this.ivPicture);
        }
    }

    private void dispatchHandleMask(LocalMedia media) {
        boolean isEnabledMask = false;
        if (this.selectorConfig.getSelectCount() > 0 && !this.selectorConfig.getSelectedResult().contains(media)) {
            if (this.selectorConfig.isWithVideoImage) {
                isEnabledMask = this.selectorConfig.selectionMode == 1 ? this.selectorConfig.getSelectCount() == Integer.MAX_VALUE : this.selectorConfig.getSelectCount() == this.selectorConfig.maxSelectNum;
            } else if (PictureMimeType.isHasVideo(this.selectorConfig.getResultFirstMimeType())) {
                int maxSelectNum = this.selectorConfig.selectionMode == 1 ? Integer.MAX_VALUE : (this.selectorConfig.maxVideoSelectNum > 0 ? this.selectorConfig.maxVideoSelectNum : this.selectorConfig.maxSelectNum);
                isEnabledMask = this.selectorConfig.getSelectCount() == maxSelectNum || PictureMimeType.isHasImage(media.getMimeType());
            } else {
                int maxSelectNum = this.selectorConfig.selectionMode == 1 ? Integer.MAX_VALUE : this.selectorConfig.maxSelectNum;
                boolean bl = isEnabledMask = this.selectorConfig.getSelectCount() == maxSelectNum || PictureMimeType.isHasVideo(media.getMimeType());
            }
        }
        if (isEnabledMask) {
            this.ivPicture.setColorFilter(this.maskWhiteColorFilter);
            media.setMaxSelectEnabledMask(true);
        } else {
            media.setMaxSelectEnabledMask(false);
        }
    }

    private void selectedMedia(boolean isChecked) {
        if (this.tvCheck.isSelected() != isChecked) {
            this.tvCheck.setSelected(isChecked);
        }
        if (this.selectorConfig.isDirectReturnSingle) {
            this.ivPicture.setColorFilter(this.defaultColorFilter);
        } else {
            this.ivPicture.setColorFilter(isChecked ? this.selectColorFilter : this.defaultColorFilter);
        }
    }

    private boolean isSelected(LocalMedia currentMedia) {
        LocalMedia compare;
        ArrayList<LocalMedia> selectedResult = this.selectorConfig.getSelectedResult();
        boolean isSelected = selectedResult.contains(currentMedia);
        if (isSelected && (compare = currentMedia.getCompareLocalMedia()) != null && compare.isEditorImage()) {
            currentMedia.setCutPath(compare.getCutPath());
            currentMedia.setCut(!TextUtils.isEmpty((CharSequence)compare.getCutPath()));
            currentMedia.setEditorImage(compare.isEditorImage());
        }
        return isSelected;
    }

    private void notifySelectNumberStyle(LocalMedia currentMedia) {
        this.tvCheck.setText((CharSequence)"");
        for (int i = 0; i < this.selectorConfig.getSelectCount(); ++i) {
            LocalMedia media = this.selectorConfig.getSelectedResult().get(i);
            if (!TextUtils.equals((CharSequence)media.getPath(), (CharSequence)currentMedia.getPath()) && media.getId() != currentMedia.getId()) continue;
            currentMedia.setNum(media.getNum());
            media.setPosition(currentMedia.getPosition());
            this.tvCheck.setText((CharSequence)ValueOf.toString(currentMedia.getNum()));
        }
    }

    public void setOnItemClickListener(PictureImageGridAdapter.OnItemClickListener listener) {
        this.listener = listener;
    }
}

