/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.immersive;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.ViewCompat;
import com.luck.picture.lib.immersive.LightStatusBarUtils;
import com.luck.picture.lib.utils.DensityUtil;

public class ImmersiveManager {
    private static final String TAG_FAKE_STATUS_BAR_VIEW = "TAG_FAKE_STATUS_BAR_VIEW";
    private static final String TAG_MARGIN_ADDED = "TAG_MARGIN_ADDED";
    private static final String TAG_NAVIGATION_BAR_VIEW = "TAG_NAVIGATION_BAR_VIEW";

    public static void immersiveAboveAPI23(AppCompatActivity baseActivity, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        ImmersiveManager.immersiveAboveAPI23(baseActivity, false, false, statusBarColor, navigationBarColor, isDarkStatusBarIcon);
    }

    public static void immersiveAboveAPI23(AppCompatActivity baseActivity, boolean isMarginStatusBar, boolean isMarginNavigationBar, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        try {
            Window window = baseActivity.getWindow();
            if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
                if (isDarkStatusBarIcon) {
                    ImmersiveManager.initBarBelowLOLLIPOP((Activity)baseActivity);
                } else {
                    window.setFlags(0x4000000, 0x4000000);
                }
            } else if (Build.VERSION.SDK_INT >= 21) {
                if (isMarginStatusBar && isMarginNavigationBar) {
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.setLightStatusBar((Activity)baseActivity, true, true, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else if (!isMarginStatusBar && !isMarginNavigationBar) {
                    if (Build.VERSION.SDK_INT < 23 && isDarkStatusBarIcon) {
                        ImmersiveManager.initBarBelowLOLLIPOP((Activity)baseActivity);
                    } else {
                        window.requestFeature(1);
                        window.clearFlags(0xC000000);
                        LightStatusBarUtils.setLightStatusBar((Activity)baseActivity, false, false, statusBarColor == 0, isDarkStatusBarIcon);
                        window.addFlags(Integer.MIN_VALUE);
                    }
                } else if (!isMarginStatusBar) {
                    window.requestFeature(1);
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.setLightStatusBar((Activity)baseActivity, false, true, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else {
                    return;
                }
                window.setStatusBarColor(statusBarColor);
                window.setNavigationBarColor(navigationBarColor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void translucentStatusBar(Activity activity, boolean isDarkStatusBarBlack) {
        Window window = activity.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0x4000000);
        window.setStatusBarColor(0);
        View decor = window.getDecorView();
        if (Build.VERSION.SDK_INT >= 23) {
            if (isDarkStatusBarBlack) {
                decor.setSystemUiVisibility(9472);
            } else {
                window.getDecorView().setSystemUiVisibility(1280);
            }
        } else if (isDarkStatusBarBlack) {
            ImmersiveManager.initBarBelowLOLLIPOP(activity);
        } else {
            window.getDecorView().setSystemUiVisibility(1280);
        }
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            mChildView.setFitsSystemWindows(false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
    }

    private static void initBarBelowLOLLIPOP(Activity activity) {
        Window mWindow = activity.getWindow();
        mWindow.addFlags(0x4000000);
        ImmersiveManager.setupStatusBarView(activity);
        if (DensityUtil.isNavBarVisible((Context)activity)) {
            mWindow.addFlags(0x8000000);
            ImmersiveManager.setupNavBarView(activity);
        }
    }

    private static void setupStatusBarView(Activity activity) {
        Window mWindow = activity.getWindow();
        View statusBarView = mWindow.getDecorView().findViewWithTag((Object)TAG_FAKE_STATUS_BAR_VIEW);
        if (statusBarView == null) {
            statusBarView = new View((Context)activity);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, DensityUtil.getStatusBarHeight((Context)activity));
            params.gravity = 48;
            statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
            statusBarView.setVisibility(0);
            statusBarView.setTag((Object)TAG_MARGIN_ADDED);
            ((ViewGroup)mWindow.getDecorView()).addView(statusBarView);
        }
        statusBarView.setBackgroundColor(0);
    }

    private static void setupNavBarView(Activity activity) {
        FrameLayout.LayoutParams params;
        Window window = activity.getWindow();
        View navigationBarView = window.getDecorView().findViewWithTag((Object)TAG_NAVIGATION_BAR_VIEW);
        if (navigationBarView == null) {
            navigationBarView = new View((Context)activity);
            navigationBarView.setTag((Object)TAG_NAVIGATION_BAR_VIEW);
            ((ViewGroup)window.getDecorView()).addView(navigationBarView);
        }
        if (DensityUtil.isNavigationAtBottom(activity)) {
            params = new FrameLayout.LayoutParams(-1, DensityUtil.getNavigationBarHeight((Context)activity));
            params.gravity = 80;
        } else {
            params = new FrameLayout.LayoutParams(DensityUtil.getNavigationBarWidth((Context)activity), -1);
            params.gravity = 0x800005;
        }
        navigationBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        navigationBarView.setBackgroundColor(0);
        navigationBarView.setVisibility(0);
    }
}

