/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnRequestPermissionListener;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionConfig;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.ToastUtils;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorSystemFragment
extends PictureCommonFragment {
    public static final String TAG = PictureSelectorSystemFragment.class.getSimpleName();
    private ActivityResultLauncher<String> mDocMultipleLauncher;
    private ActivityResultLauncher<String> mDocSingleLauncher;
    private ActivityResultLauncher<String> mContentsLauncher;
    private ActivityResultLauncher<String> mContentLauncher;

    public static PictureSelectorSystemFragment newInstance() {
        return new PictureSelectorSystemFragment();
    }

    @Override
    public String getFragmentTag() {
        return TAG;
    }

    @Override
    public int getResourceId() {
        return R.layout.ps_empty;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.createSystemContracts();
        if (PermissionChecker.isCheckReadStorage(this.config.chooseMode, this.getContext())) {
            this.openSystemAlbum();
        } else {
            final String[] readPermissionArray = PermissionConfig.getReadPermissionArray(this.config.chooseMode);
            this.onPermissionExplainEvent(true, readPermissionArray);
            if (PictureSelectionConfig.onPermissionsEventListener != null) {
                this.onApplyPermissionsEvent(-2, readPermissionArray);
            } else {
                PermissionChecker.getInstance().requestPermissions((Fragment)this, readPermissionArray, new PermissionResultCallback(){

                    @Override
                    public void onGranted() {
                        PictureSelectorSystemFragment.this.openSystemAlbum();
                    }

                    @Override
                    public void onDenied() {
                        PictureSelectorSystemFragment.this.handlePermissionDenied(readPermissionArray);
                    }
                });
            }
        }
    }

    @Override
    public void onApplyPermissionsEvent(int event, String[] permissionArray) {
        if (event == -2) {
            PictureSelectionConfig.onPermissionsEventListener.requestPermission(this, PermissionConfig.getReadPermissionArray(this.config.chooseMode), new OnRequestPermissionListener(){

                @Override
                public void onCall(String[] permissionArray, boolean isResult) {
                    if (isResult) {
                        PictureSelectorSystemFragment.this.openSystemAlbum();
                    } else {
                        PictureSelectorSystemFragment.this.handlePermissionDenied(permissionArray);
                    }
                }
            });
        }
    }

    private void openSystemAlbum() {
        this.onPermissionExplainEvent(false, null);
        if (this.config.selectionMode == 1) {
            if (this.config.chooseMode == SelectMimeType.ofAll()) {
                this.mDocSingleLauncher.launch((Object)"image/*,video/*");
            } else {
                this.mContentLauncher.launch((Object)this.getInput());
            }
        } else if (this.config.chooseMode == SelectMimeType.ofAll()) {
            this.mDocMultipleLauncher.launch((Object)"image/*,video/*");
        } else {
            this.mContentsLauncher.launch((Object)this.getInput());
        }
    }

    private void createSystemContracts() {
        if (this.config.selectionMode == 1) {
            if (this.config.chooseMode == SelectMimeType.ofAll()) {
                this.createSingleDocuments();
            } else {
                this.createContent();
            }
        } else if (this.config.chooseMode == SelectMimeType.ofAll()) {
            this.createMultipleDocuments();
        } else {
            this.createMultipleContents();
        }
    }

    private void createMultipleDocuments() {
        this.mDocMultipleLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContract<String, List<Uri>>(){

            public List<Uri> parseResult(int resultCode, @Nullable Intent intent) {
                ArrayList<Uri> result = new ArrayList<Uri>();
                if (intent == null) {
                    return result;
                }
                if (intent.getClipData() != null) {
                    ClipData clipData = intent.getClipData();
                    int itemCount = clipData.getItemCount();
                    for (int i = 0; i < itemCount; ++i) {
                        ClipData.Item item = clipData.getItemAt(i);
                        Uri uri = item.getUri();
                        result.add(uri);
                    }
                } else if (intent.getData() != null) {
                    result.add(intent.getData());
                }
                return result;
            }

            @NonNull
            public Intent createIntent(@NonNull Context context, String mimeTypes) {
                Intent intent = new Intent("android.intent.action.PICK");
                intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
                intent.setType(mimeTypes);
                return intent;
            }
        }, (ActivityResultCallback)new ActivityResultCallback<List<Uri>>(){

            public void onActivityResult(List<Uri> result) {
                if (result == null || result.size() == 0) {
                    PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                } else {
                    for (int i = 0; i < result.size(); ++i) {
                        LocalMedia media = PictureSelectorSystemFragment.this.buildLocalMedia(result.get(i).toString());
                        media.setPath(SdkVersionUtils.isQ() ? media.getPath() : media.getRealPath());
                        SelectedManager.addSelectResult(media);
                    }
                    PictureSelectorSystemFragment.this.dispatchTransformResult();
                }
            }
        });
    }

    private void createSingleDocuments() {
        this.mDocSingleLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContract<String, Uri>(){

            public Uri parseResult(int resultCode, @Nullable Intent intent) {
                if (intent == null) {
                    return null;
                }
                return intent.getData();
            }

            @NonNull
            public Intent createIntent(@NonNull Context context, String mimeTypes) {
                Intent intent = new Intent("android.intent.action.PICK");
                intent.setType(mimeTypes);
                return intent;
            }
        }, (ActivityResultCallback)new ActivityResultCallback<Uri>(){

            public void onActivityResult(Uri result) {
                if (result == null) {
                    PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                } else {
                    LocalMedia media = PictureSelectorSystemFragment.this.buildLocalMedia(result.toString());
                    media.setPath(SdkVersionUtils.isQ() ? media.getPath() : media.getRealPath());
                    int selectResultCode = PictureSelectorSystemFragment.this.confirmSelect(media, false);
                    if (selectResultCode == 0) {
                        PictureSelectorSystemFragment.this.dispatchTransformResult();
                    } else {
                        PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                    }
                }
            }
        });
    }

    private void createMultipleContents() {
        this.mContentsLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContract<String, List<Uri>>(){

            public List<Uri> parseResult(int resultCode, @Nullable Intent intent) {
                ArrayList<Uri> result = new ArrayList<Uri>();
                if (intent == null) {
                    return result;
                }
                if (intent.getClipData() != null) {
                    ClipData clipData = intent.getClipData();
                    int itemCount = clipData.getItemCount();
                    for (int i = 0; i < itemCount; ++i) {
                        ClipData.Item item = clipData.getItemAt(i);
                        Uri uri = item.getUri();
                        result.add(uri);
                    }
                } else if (intent.getData() != null) {
                    result.add(intent.getData());
                }
                return result;
            }

            @NonNull
            public Intent createIntent(@NonNull Context context, String mimeType) {
                Intent intent = TextUtils.equals((CharSequence)"video/*", (CharSequence)mimeType) ? new Intent("android.intent.action.PICK", MediaStore.Video.Media.EXTERNAL_CONTENT_URI) : (TextUtils.equals((CharSequence)"audio/*", (CharSequence)mimeType) ? new Intent("android.intent.action.PICK", MediaStore.Audio.Media.EXTERNAL_CONTENT_URI) : new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI));
                intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
                return intent;
            }
        }, (ActivityResultCallback)new ActivityResultCallback<List<Uri>>(){

            public void onActivityResult(List<Uri> result) {
                if (result == null || result.size() == 0) {
                    PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                } else {
                    for (int i = 0; i < result.size(); ++i) {
                        LocalMedia media = PictureSelectorSystemFragment.this.buildLocalMedia(result.get(i).toString());
                        media.setPath(SdkVersionUtils.isQ() ? media.getPath() : media.getRealPath());
                        SelectedManager.addSelectResult(media);
                    }
                    PictureSelectorSystemFragment.this.dispatchTransformResult();
                }
            }
        });
    }

    private void createContent() {
        this.mContentLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContract<String, Uri>(){

            public Uri parseResult(int resultCode, @Nullable Intent intent) {
                if (intent == null) {
                    return null;
                }
                return intent.getData();
            }

            @NonNull
            public Intent createIntent(@NonNull Context context, String mimeType) {
                Intent intent = TextUtils.equals((CharSequence)"video/*", (CharSequence)mimeType) ? new Intent("android.intent.action.PICK", MediaStore.Video.Media.EXTERNAL_CONTENT_URI) : (TextUtils.equals((CharSequence)"audio/*", (CharSequence)mimeType) ? new Intent("android.intent.action.PICK", MediaStore.Audio.Media.EXTERNAL_CONTENT_URI) : new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI));
                return intent;
            }
        }, (ActivityResultCallback)new ActivityResultCallback<Uri>(){

            public void onActivityResult(Uri result) {
                if (result == null) {
                    PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                } else {
                    LocalMedia media = PictureSelectorSystemFragment.this.buildLocalMedia(result.toString());
                    media.setPath(SdkVersionUtils.isQ() ? media.getPath() : media.getRealPath());
                    int selectResultCode = PictureSelectorSystemFragment.this.confirmSelect(media, false);
                    if (selectResultCode == 0) {
                        PictureSelectorSystemFragment.this.dispatchTransformResult();
                    } else {
                        PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                    }
                }
            }
        });
    }

    private String getInput() {
        if (this.config.chooseMode == SelectMimeType.ofVideo()) {
            return "video/*";
        }
        if (this.config.chooseMode == SelectMimeType.ofAudio()) {
            return "audio/*";
        }
        return "image/*";
    }

    @Override
    public void handlePermissionSettingResult(String[] permissions) {
        this.onPermissionExplainEvent(false, null);
        boolean isCheckReadStorage = PictureSelectionConfig.onPermissionsEventListener != null ? PictureSelectionConfig.onPermissionsEventListener.hasPermissions(this, permissions) : PermissionChecker.isCheckReadStorage(this.config.chooseMode, this.getContext());
        if (isCheckReadStorage) {
            this.openSystemAlbum();
        } else {
            ToastUtils.showToast(this.getContext(), this.getString(R.string.ps_jurisdiction));
            this.onKeyBackFragmentFinish();
        }
        PermissionConfig.CURRENT_REQUEST_PERMISSION = new String[0];
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 0) {
            this.onKeyBackFragmentFinish();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mDocMultipleLauncher != null) {
            this.mDocMultipleLauncher.unregister();
        }
        if (this.mDocSingleLauncher != null) {
            this.mDocSingleLauncher.unregister();
        }
        if (this.mContentsLauncher != null) {
            this.mContentsLauncher.unregister();
        }
        if (this.mContentLauncher != null) {
            this.mContentLauncher.unregister();
        }
    }
}

