/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.activity.result.ActivityResultLauncher;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.PictureSelectorFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.IBridgeLoaderFactory;
import com.luck.picture.lib.basic.IBridgePictureBehavior;
import com.luck.picture.lib.basic.IBridgeViewLifecycle;
import com.luck.picture.lib.basic.InterpolatorFactory;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.basic.PictureSelectorSupporterActivity;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.engine.CompressEngine;
import com.luck.picture.lib.engine.CompressFileEngine;
import com.luck.picture.lib.engine.CropEngine;
import com.luck.picture.lib.engine.CropFileEngine;
import com.luck.picture.lib.engine.ExtendLoaderEngine;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.engine.SandboxFileEngine;
import com.luck.picture.lib.engine.UriToFileTransformEngine;
import com.luck.picture.lib.engine.VideoPlayerEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnBitmapWatermarkEventListener;
import com.luck.picture.lib.interfaces.OnCameraInterceptListener;
import com.luck.picture.lib.interfaces.OnCustomLoadingListener;
import com.luck.picture.lib.interfaces.OnGridItemSelectAnimListener;
import com.luck.picture.lib.interfaces.OnInjectLayoutResourceListener;
import com.luck.picture.lib.interfaces.OnMediaEditInterceptListener;
import com.luck.picture.lib.interfaces.OnPermissionDeniedListener;
import com.luck.picture.lib.interfaces.OnPermissionDescriptionListener;
import com.luck.picture.lib.interfaces.OnPermissionsInterceptListener;
import com.luck.picture.lib.interfaces.OnPreviewInterceptListener;
import com.luck.picture.lib.interfaces.OnQueryFilterListener;
import com.luck.picture.lib.interfaces.OnRecordAudioInterceptListener;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.interfaces.OnSelectAnimListener;
import com.luck.picture.lib.interfaces.OnSelectFilterListener;
import com.luck.picture.lib.interfaces.OnSelectLimitTipsListener;
import com.luck.picture.lib.interfaces.OnVideoThumbnailEventListener;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PictureSelectionModel {
    private final PictureSelectionConfig selectionConfig;
    private final PictureSelector selector;

    public PictureSelectionModel(PictureSelector selector, int chooseMode) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
        this.selectionConfig.chooseMode = chooseMode;
        this.setMaxVideoSelectNum(this.selectionConfig.maxVideoSelectNum);
    }

    public PictureSelectionModel setSelectorUIStyle(PictureSelectorStyle uiStyle) {
        if (uiStyle != null) {
            PictureSelectionConfig.selectorStyle = uiStyle;
        }
        return this;
    }

    public PictureSelectionModel setLanguage(int language) {
        this.selectionConfig.language = language;
        return this;
    }

    public PictureSelectionModel setImageEngine(ImageEngine engine) {
        PictureSelectionConfig.imageEngine = engine;
        return this;
    }

    public PictureSelectionModel setVideoPlayerEngine(VideoPlayerEngine engine) {
        PictureSelectionConfig.videoPlayerEngine = engine;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setCompressEngine(CompressEngine engine) {
        PictureSelectionConfig.compressEngine = engine;
        this.selectionConfig.isCompressEngine = true;
        return this;
    }

    public PictureSelectionModel setCompressEngine(CompressFileEngine engine) {
        PictureSelectionConfig.compressFileEngine = engine;
        this.selectionConfig.isCompressEngine = true;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setCropEngine(CropEngine engine) {
        PictureSelectionConfig.cropEngine = engine;
        return this;
    }

    public PictureSelectionModel setCropEngine(CropFileEngine engine) {
        PictureSelectionConfig.cropFileEngine = engine;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setSandboxFileEngine(SandboxFileEngine engine) {
        if (SdkVersionUtils.isQ()) {
            PictureSelectionConfig.sandboxFileEngine = engine;
            this.selectionConfig.isSandboxFileEngine = true;
        } else {
            this.selectionConfig.isSandboxFileEngine = false;
        }
        return this;
    }

    public PictureSelectionModel setSandboxFileEngine(UriToFileTransformEngine engine) {
        if (SdkVersionUtils.isQ()) {
            PictureSelectionConfig.uriToFileTransformEngine = engine;
            this.selectionConfig.isSandboxFileEngine = true;
        } else {
            this.selectionConfig.isSandboxFileEngine = false;
        }
        return this;
    }

    @Deprecated
    public PictureSelectionModel setExtendLoaderEngine(ExtendLoaderEngine engine) {
        PictureSelectionConfig.loaderDataEngine = engine;
        this.selectionConfig.isLoaderDataEngine = true;
        return this;
    }

    public PictureSelectionModel setLoaderFactoryEngine(IBridgeLoaderFactory loaderFactory) {
        PictureSelectionConfig.loaderFactory = loaderFactory;
        this.selectionConfig.isLoaderFactoryEngine = true;
        return this;
    }

    public PictureSelectionModel setMagicalEffectInterpolator(InterpolatorFactory interpolatorFactory) {
        PictureSelectionConfig.interpolatorFactory = interpolatorFactory;
        return this;
    }

    public PictureSelectionModel setCameraInterceptListener(OnCameraInterceptListener listener) {
        PictureSelectionConfig.onCameraInterceptListener = listener;
        return this;
    }

    public PictureSelectionModel setRecordAudioInterceptListener(OnRecordAudioInterceptListener listener) {
        PictureSelectionConfig.onRecordAudioListener = listener;
        return this;
    }

    public PictureSelectionModel setPreviewInterceptListener(OnPreviewInterceptListener listener) {
        PictureSelectionConfig.onPreviewInterceptListener = listener;
        return this;
    }

    public PictureSelectionModel setInjectLayoutResourceListener(OnInjectLayoutResourceListener listener) {
        this.selectionConfig.isInjectLayoutResource = listener != null;
        PictureSelectionConfig.onLayoutResourceListener = listener;
        return this;
    }

    public PictureSelectionModel setEditMediaInterceptListener(OnMediaEditInterceptListener listener) {
        PictureSelectionConfig.onEditMediaEventListener = listener;
        return this;
    }

    public PictureSelectionModel setPermissionsInterceptListener(OnPermissionsInterceptListener listener) {
        PictureSelectionConfig.onPermissionsEventListener = listener;
        return this;
    }

    public PictureSelectionModel setPermissionDescriptionListener(OnPermissionDescriptionListener listener) {
        PictureSelectionConfig.onPermissionDescriptionListener = listener;
        return this;
    }

    public PictureSelectionModel setPermissionDeniedListener(OnPermissionDeniedListener listener) {
        PictureSelectionConfig.onPermissionDeniedListener = listener;
        return this;
    }

    public PictureSelectionModel setSelectLimitTipsListener(OnSelectLimitTipsListener listener) {
        PictureSelectionConfig.onSelectLimitTipsListener = listener;
        return this;
    }

    public PictureSelectionModel setSelectFilterListener(OnSelectFilterListener listener) {
        PictureSelectionConfig.onSelectFilterListener = listener;
        return this;
    }

    public PictureSelectionModel setQueryFilterListener(OnQueryFilterListener listener) {
        PictureSelectionConfig.onQueryFilterListener = listener;
        return this;
    }

    public PictureSelectionModel setGridItemSelectAnimListener(OnGridItemSelectAnimListener listener) {
        PictureSelectionConfig.onItemSelectAnimListener = listener;
        return this;
    }

    public PictureSelectionModel setSelectAnimListener(OnSelectAnimListener listener) {
        PictureSelectionConfig.onSelectAnimListener = listener;
        return this;
    }

    public PictureSelectionModel setAddBitmapWatermarkListener(OnBitmapWatermarkEventListener listener) {
        if (this.selectionConfig.chooseMode != SelectMimeType.ofAudio()) {
            PictureSelectionConfig.onBitmapWatermarkListener = listener;
        }
        return this;
    }

    public PictureSelectionModel setVideoThumbnailListener(OnVideoThumbnailEventListener listener) {
        if (this.selectionConfig.chooseMode != SelectMimeType.ofAudio()) {
            PictureSelectionConfig.onVideoThumbnailEventListener = listener;
        }
        return this;
    }

    public PictureSelectionModel setCustomLoadingListener(OnCustomLoadingListener listener) {
        PictureSelectionConfig.onCustomLoadingListener = listener;
        return this;
    }

    public PictureSelectionModel isCameraForegroundService(boolean isForeground) {
        this.selectionConfig.isCameraForegroundService = isForeground;
        return this;
    }

    public PictureSelectionModel setRequestedOrientation(int requestedOrientation) {
        this.selectionConfig.requestedOrientation = requestedOrientation;
        return this;
    }

    public PictureSelectionModel setSelectionMode(int selectionMode) {
        this.selectionConfig.selectionMode = selectionMode;
        this.selectionConfig.maxSelectNum = this.selectionConfig.selectionMode == 1 ? 1 : this.selectionConfig.maxSelectNum;
        return this;
    }

    public PictureSelectionModel isWithSelectVideoImage(boolean isWithVideoImage) {
        this.selectionConfig.isWithVideoImage = this.selectionConfig.chooseMode == SelectMimeType.ofAll() && isWithVideoImage;
        return this;
    }

    public PictureSelectionModel setOfAllCameraType(int ofAllCameraType) {
        this.selectionConfig.ofAllCameraType = ofAllCameraType;
        return this;
    }

    public PictureSelectionModel isMaxSelectEnabledMask(boolean isMaxSelectEnabledMask) {
        this.selectionConfig.isMaxSelectEnabledMask = isMaxSelectEnabledMask;
        return this;
    }

    public PictureSelectionModel isOriginalControl(boolean isOriginalControl) {
        this.selectionConfig.isOriginalControl = isOriginalControl;
        return this;
    }

    public PictureSelectionModel isSyncCover(boolean isSyncCover) {
        this.selectionConfig.isSyncCover = isSyncCover;
        return this;
    }

    public PictureSelectionModel setMaxSelectNum(int maxSelectNum) {
        this.selectionConfig.maxSelectNum = this.selectionConfig.selectionMode == 1 ? 1 : maxSelectNum;
        return this;
    }

    public PictureSelectionModel setMinSelectNum(int minSelectNum) {
        this.selectionConfig.minSelectNum = minSelectNum;
        return this;
    }

    public PictureSelectionModel isAutomaticTitleRecyclerTop(boolean isAutomaticTitleRecyclerTop) {
        this.selectionConfig.isAutomaticTitleRecyclerTop = isAutomaticTitleRecyclerTop;
        return this;
    }

    public PictureSelectionModel isDirectReturnSingle(boolean isDirectReturn) {
        if (isDirectReturn) {
            this.selectionConfig.isFastSlidingSelect = false;
        }
        this.selectionConfig.isDirectReturnSingle = this.selectionConfig.selectionMode == 1 && isDirectReturn;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, int pageSize) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.pageSize = pageSize < 10 ? 60 : pageSize;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, boolean isFilterInvalidFile) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.isFilterInvalidFile = isFilterInvalidFile;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, int pageSize, boolean isFilterInvalidFile) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.pageSize = pageSize < 10 ? 60 : pageSize;
        this.selectionConfig.isFilterInvalidFile = isFilterInvalidFile;
        return this;
    }

    public PictureSelectionModel setAttachViewLifecycle(IBridgeViewLifecycle viewLifecycle) {
        PictureSelectionConfig.viewLifecycle = viewLifecycle;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setVideoQuality(int videoQuality) {
        this.selectionConfig.videoQuality = videoQuality;
        return this;
    }

    public PictureSelectionModel setDefaultAlbumName(String defaultAlbumName) {
        this.selectionConfig.defaultAlbumName = defaultAlbumName;
        return this;
    }

    public PictureSelectionModel setCameraImageFormat(String imageFormat) {
        this.selectionConfig.cameraImageFormat = imageFormat;
        return this;
    }

    public PictureSelectionModel setCameraImageFormatForQ(String imageFormat) {
        this.selectionConfig.cameraImageFormatForQ = imageFormat;
        return this;
    }

    public PictureSelectionModel setCameraVideoFormat(String videoFormat) {
        this.selectionConfig.cameraVideoFormat = videoFormat;
        return this;
    }

    public PictureSelectionModel setCameraVideoFormatForQ(String videoFormat) {
        this.selectionConfig.cameraVideoFormatForQ = videoFormat;
        return this;
    }

    public PictureSelectionModel setFilterVideoMaxSecond(int videoMaxSecond) {
        this.selectionConfig.filterVideoMaxSecond = videoMaxSecond * 1000;
        return this;
    }

    public PictureSelectionModel setFilterVideoMinSecond(int videoMinSecond) {
        this.selectionConfig.filterVideoMinSecond = videoMinSecond * 1000;
        return this;
    }

    public PictureSelectionModel setSelectMaxDurationSecond(int maxDurationSecond) {
        this.selectionConfig.selectMaxDurationSecond = maxDurationSecond * 1000;
        return this;
    }

    public PictureSelectionModel setSelectMinDurationSecond(int minDurationSecond) {
        this.selectionConfig.selectMinDurationSecond = minDurationSecond * 1000;
        return this;
    }

    public PictureSelectionModel setRecordVideoMaxSecond(int maxSecond) {
        this.selectionConfig.recordVideoMaxSecond = maxSecond;
        return this;
    }

    public PictureSelectionModel setMaxVideoSelectNum(int maxVideoSelectNum) {
        this.selectionConfig.maxVideoSelectNum = this.selectionConfig.chooseMode == SelectMimeType.ofVideo() ? 0 : maxVideoSelectNum;
        return this;
    }

    public PictureSelectionModel setMinVideoSelectNum(int minVideoSelectNum) {
        this.selectionConfig.minVideoSelectNum = minVideoSelectNum;
        return this;
    }

    public PictureSelectionModel setMinAudioSelectNum(int minAudioSelectNum) {
        this.selectionConfig.minAudioSelectNum = minAudioSelectNum;
        return this;
    }

    public PictureSelectionModel setRecordVideoMinSecond(int minSecond) {
        this.selectionConfig.recordVideoMinSecond = minSecond;
        return this;
    }

    public PictureSelectionModel setImageSpanCount(int imageSpanCount) {
        this.selectionConfig.imageSpanCount = imageSpanCount;
        return this;
    }

    public PictureSelectionModel isEmptyResultReturn(boolean isEmptyReturn) {
        this.selectionConfig.isEmptyResultReturn = isEmptyReturn;
        return this;
    }

    public PictureSelectionModel isQuickCapture(boolean isQuickCapture) {
        this.selectionConfig.isQuickCapture = isQuickCapture;
        return this;
    }

    public PictureSelectionModel isDisplayCamera(boolean isDisplayCamera) {
        this.selectionConfig.isDisplayCamera = isDisplayCamera;
        return this;
    }

    public PictureSelectionModel setOutputCameraDir(String outPutCameraDir) {
        this.selectionConfig.outPutCameraDir = outPutCameraDir;
        return this;
    }

    public PictureSelectionModel setOutputAudioDir(String outPutAudioDir) {
        this.selectionConfig.outPutAudioDir = outPutAudioDir;
        return this;
    }

    public PictureSelectionModel setOutputCameraImageFileName(String fileName) {
        this.selectionConfig.outPutCameraImageFileName = fileName;
        return this;
    }

    public PictureSelectionModel setOutputCameraVideoFileName(String fileName) {
        this.selectionConfig.outPutCameraVideoFileName = fileName;
        return this;
    }

    public PictureSelectionModel setOutputAudioFileName(String fileName) {
        this.selectionConfig.outPutAudioFileName = fileName;
        return this;
    }

    public PictureSelectionModel setQuerySandboxDir(String dir) {
        this.selectionConfig.sandboxDir = dir;
        return this;
    }

    public PictureSelectionModel isOnlyObtainSandboxDir(boolean isOnlySandboxDir) {
        this.selectionConfig.isOnlySandboxDir = isOnlySandboxDir;
        return this;
    }

    public PictureSelectionModel isDisplayTimeAxis(boolean isDisplayTimeAxis) {
        this.selectionConfig.isDisplayTimeAxis = isDisplayTimeAxis;
        return this;
    }

    public PictureSelectionModel setFilterMaxFileSize(long fileKbSize) {
        this.selectionConfig.filterMaxFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionModel setFilterMinFileSize(long fileKbSize) {
        this.selectionConfig.filterMinFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionModel setSelectMaxFileSize(long fileKbSize) {
        this.selectionConfig.selectMaxFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionModel setSelectMinFileSize(long fileKbSize) {
        this.selectionConfig.selectMinFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionModel setQueryOnlyMimeType(String ... mimeTypes) {
        if (mimeTypes != null && mimeTypes.length > 0) {
            this.selectionConfig.queryOnlyList.addAll(Arrays.asList(mimeTypes));
        }
        return this;
    }

    public PictureSelectionModel setSkipCropMimeType(String ... mimeTypes) {
        if (mimeTypes != null && mimeTypes.length > 0) {
            this.selectionConfig.skipCropList.addAll(Arrays.asList(mimeTypes));
        }
        return this;
    }

    public PictureSelectionModel setQuerySortOrder(String sortOrder) {
        if (!TextUtils.isEmpty((CharSequence)sortOrder)) {
            this.selectionConfig.sortOrder = sortOrder;
        }
        return this;
    }

    public PictureSelectionModel isGif(boolean isGif) {
        this.selectionConfig.isGif = isGif;
        return this;
    }

    public PictureSelectionModel isWebp(boolean isWebp) {
        this.selectionConfig.isWebp = isWebp;
        return this;
    }

    public PictureSelectionModel isBmp(boolean isBmp) {
        this.selectionConfig.isBmp = isBmp;
        return this;
    }

    public PictureSelectionModel isPreviewFullScreenMode(boolean isFullScreenModel) {
        this.selectionConfig.isPreviewFullScreenMode = isFullScreenModel;
        return this;
    }

    public PictureSelectionModel isPreviewZoomEffect(boolean isPreviewZoomEffect) {
        this.selectionConfig.isPreviewZoomEffect = this.selectionConfig.chooseMode == SelectMimeType.ofAudio() ? false : isPreviewZoomEffect;
        return this;
    }

    public PictureSelectionModel isEnableVideoSize(boolean isEnableVideoSize) {
        this.selectionConfig.isEnableVideoSize = isEnableVideoSize;
        return this;
    }

    public PictureSelectionModel isPreviewAudio(boolean isPreviewAudio) {
        this.selectionConfig.isEnablePreviewAudio = isPreviewAudio;
        return this;
    }

    public PictureSelectionModel isPreviewImage(boolean isPreviewImage) {
        this.selectionConfig.isEnablePreviewImage = isPreviewImage;
        return this;
    }

    public PictureSelectionModel isPreviewVideo(boolean isPreviewVideo) {
        this.selectionConfig.isEnablePreviewVideo = isPreviewVideo;
        return this;
    }

    public PictureSelectionModel isAutoVideoPlay(boolean isAutoPlay) {
        this.selectionConfig.isAutoVideoPlay = isAutoPlay;
        return this;
    }

    public PictureSelectionModel isLoopAutoVideoPlay(boolean isLoopAutoPlay) {
        this.selectionConfig.isLoopAutoPlay = isLoopAutoPlay;
        return this;
    }

    public PictureSelectionModel isVideoPauseResumePlay(boolean isPauseResumePlay) {
        this.selectionConfig.isPauseResumePlay = isPauseResumePlay;
        return this;
    }

    public PictureSelectionModel isPageSyncAlbumCount(boolean isPageSyncAsCount) {
        this.selectionConfig.isPageSyncAsCount = isPageSyncAsCount;
        return this;
    }

    public PictureSelectionModel isOriginalSkipCompress(boolean isOriginalSkipCompress) {
        this.selectionConfig.isOriginalSkipCompress = isOriginalSkipCompress;
        return this;
    }

    public PictureSelectionModel isFilterSizeDuration(boolean isFilterSizeDuration) {
        this.selectionConfig.isFilterSizeDuration = isFilterSizeDuration;
        return this;
    }

    public PictureSelectionModel isFastSlidingSelect(boolean isFastSlidingSelect) {
        this.selectionConfig.isFastSlidingSelect = this.selectionConfig.isDirectReturnSingle ? false : isFastSlidingSelect;
        return this;
    }

    public PictureSelectionModel isOpenClickSound(boolean isClickSound) {
        this.selectionConfig.isOpenClickSound = isClickSound;
        return this;
    }

    public PictureSelectionModel isCameraAroundState(boolean isCameraAroundState) {
        this.selectionConfig.isCameraAroundState = isCameraAroundState;
        return this;
    }

    public PictureSelectionModel isCameraRotateImage(boolean isCameraRotateImage) {
        this.selectionConfig.isCameraRotateImage = isCameraRotateImage;
        return this;
    }

    public PictureSelectionModel isSelectZoomAnim(boolean isSelectZoomAnim) {
        this.selectionConfig.isSelectZoomAnim = isSelectZoomAnim;
        return this;
    }

    public PictureSelectionModel setSelectedData(List<LocalMedia> selectedList) {
        if (selectedList == null) {
            return this;
        }
        if (this.selectionConfig.selectionMode == 1 && this.selectionConfig.isDirectReturnSingle) {
            SelectedManager.clearSelectResult();
        } else {
            SelectedManager.addAllSelectResult(new ArrayList<LocalMedia>(selectedList));
        }
        return this;
    }

    public PictureSelectionModel setRecyclerAnimationMode(int animationMode) {
        this.selectionConfig.animationMode = animationMode;
        return this;
    }

    public void forResult(OnResultCallbackListener<LocalMedia> call) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (call == null) {
                throw new NullPointerException("OnResultCallbackListener cannot be null");
            }
            this.selectionConfig.isResultListenerBack = true;
            this.selectionConfig.isActivityResultBack = false;
            PictureSelectionConfig.onResultCallListener = call;
            if (PictureSelectionConfig.imageEngine == null && this.selectionConfig.chooseMode != SelectMimeType.ofAudio()) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            Intent intent = new Intent((Context)activity, PictureSelectorSupporterActivity.class);
            activity.startActivity(intent);
            PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
            activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.ps_anim_fade_in);
        }
    }

    public void forResult(int requestCode) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            this.selectionConfig.isResultListenerBack = false;
            this.selectionConfig.isActivityResultBack = true;
            if (PictureSelectionConfig.imageEngine == null && this.selectionConfig.chooseMode != SelectMimeType.ofAudio()) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            Intent intent = new Intent((Context)activity, PictureSelectorSupporterActivity.class);
            Fragment fragment = this.selector.getFragment();
            if (fragment != null) {
                fragment.startActivityForResult(intent, requestCode);
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
            PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
            activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.ps_anim_fade_in);
        }
    }

    public void forResult(ActivityResultLauncher<Intent> launcher) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (launcher == null) {
                throw new NullPointerException("ActivityResultLauncher cannot be null");
            }
            this.selectionConfig.isResultListenerBack = false;
            this.selectionConfig.isActivityResultBack = true;
            if (PictureSelectionConfig.imageEngine == null && this.selectionConfig.chooseMode != SelectMimeType.ofAudio()) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            Intent intent = new Intent((Context)activity, PictureSelectorSupporterActivity.class);
            launcher.launch((Object)intent);
            PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
            activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.ps_anim_fade_in);
        }
    }

    public PictureSelectorFragment build() {
        Activity activity = this.selector.getActivity();
        if (activity == null) {
            throw new NullPointerException("Activity cannot be null");
        }
        if (!(activity instanceof IBridgePictureBehavior)) {
            throw new NullPointerException("Use only build PictureSelectorFragment,Activity or Fragment interface needs to be implemented " + IBridgePictureBehavior.class);
        }
        this.selectionConfig.isResultListenerBack = false;
        this.selectionConfig.isActivityResultBack = true;
        PictureSelectionConfig.onResultCallListener = null;
        return new PictureSelectorFragment();
    }

    public PictureSelectorFragment buildLaunch(int containerViewId, OnResultCallbackListener<LocalMedia> call) {
        Activity activity = this.selector.getActivity();
        if (activity == null) {
            throw new NullPointerException("Activity cannot be null");
        }
        if (call == null) {
            throw new NullPointerException("OnResultCallbackListener cannot be null");
        }
        this.selectionConfig.isResultListenerBack = true;
        this.selectionConfig.isActivityResultBack = false;
        PictureSelectionConfig.onResultCallListener = call;
        FragmentManager fragmentManager = null;
        if (activity instanceof AppCompatActivity) {
            fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
        } else if (activity instanceof FragmentActivity) {
            fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
        }
        if (fragmentManager == null) {
            throw new NullPointerException("FragmentManager cannot be null");
        }
        PictureSelectorFragment selectorFragment = new PictureSelectorFragment();
        Fragment fragment = fragmentManager.findFragmentByTag(selectorFragment.getFragmentTag());
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
        fragmentManager.beginTransaction().add(containerViewId, (Fragment)selectorFragment, selectorFragment.getFragmentTag()).addToBackStack(selectorFragment.getFragmentTag()).commitAllowingStateLoss();
        return selectorFragment;
    }
}

