/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import com.luck.picture.lib.R;
import com.luck.picture.lib.utils.ValueOf;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    @SuppressLint(value={"SimpleDateFormat"})
    private static final SimpleDateFormat SF = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    @SuppressLint(value={"SimpleDateFormat"})
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM");
    @SuppressLint(value={"SimpleDateFormat"})
    private static final SimpleDateFormat SDF_YEAR = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static long getCurrentTimeMillis() {
        String timeToString = ValueOf.toString(System.currentTimeMillis());
        return ValueOf.toLong(timeToString.length() > 10 ? timeToString.substring(0, 10) : timeToString);
    }

    public static String getDataFormat(Context context, long time) {
        long l = time = String.valueOf(time).length() > 10 ? time : time * 1000L;
        if (DateUtils.isThisWeek(time)) {
            return context.getString(R.string.ps_current_week);
        }
        if (DateUtils.isThisMonth(time)) {
            return context.getString(R.string.ps_current_month);
        }
        return SDF.format(time);
    }

    public static String getYearDataFormat(long time) {
        time = String.valueOf(time).length() > 10 ? time : time * 1000L;
        return SDF_YEAR.format(time);
    }

    private static boolean isThisWeek(long time) {
        Calendar calendar = Calendar.getInstance();
        int currentWeek = calendar.get(3);
        calendar.setTime(new Date(time));
        int paramWeek = calendar.get(3);
        return paramWeek == currentWeek;
    }

    public static boolean isThisMonth(long time) {
        Date date = new Date(time);
        String param = SDF.format(date);
        String now = SDF.format(new Date());
        return param.equals(now);
    }

    public static long millisecondToSecond(long duration) {
        duration = Math.abs(duration);
        long totalSeconds = (duration + 500L) / 1000L;
        return totalSeconds * 1000L;
    }

    public static int dateDiffer(long d) {
        try {
            long l1 = DateUtils.getCurrentTimeMillis();
            long interval = l1 - d;
            return (int)Math.abs(interval);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String formatDurationTime(long timeMs) {
        String prefix = timeMs < 0L ? "-" : "";
        timeMs = Math.abs(timeMs);
        long repair = timeMs + 500L;
        long totalSeconds = repair > 500L && repair < 1000L ? 1L : repair / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        return hours > 0L ? String.format(Locale.getDefault(), "%s%d:%02d:%02d", prefix, hours, minutes, seconds) : String.format(Locale.getDefault(), "%s%02d:%02d", prefix, minutes, seconds);
    }

    public static String getCreateFileName(String prefix) {
        long millis = System.currentTimeMillis();
        return prefix + SF.format(millis);
    }

    public static String getCreateFileName() {
        long millis = System.currentTimeMillis();
        return SF.format(millis);
    }

    public static String cdTime(long sTime, long eTime) {
        long diff = eTime - sTime;
        return diff > 1000L ? diff / 1000L + "\u79d2" : diff + "\u6beb\u79d2";
    }
}

