/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import com.luck.picture.lib.basic.PictureContentResolver;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.utils.PictureFileUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    private static final int ARGB_8888_MEMORY_BYTE = 4;
    private static final int MAX_BITMAP_SIZE = 0x6400000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateImage(Context context, String path) {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        Bitmap bitmap = null;
        try {
            int degree = BitmapUtils.readPictureDegree(context, path);
            if (degree > 0) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                if (PictureMimeType.isContent(path)) {
                    inputStream = PictureContentResolver.getContentResolverOpenInputStream(context, Uri.parse((String)path));
                    BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                } else {
                    BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                }
                options.inSampleSize = BitmapUtils.computeSize(options.outWidth, options.outHeight);
                options.inJustDecodeBounds = false;
                if (PictureMimeType.isContent(path)) {
                    inputStream = PictureContentResolver.getContentResolverOpenInputStream(context, Uri.parse((String)path));
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                } else {
                    bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                }
                if (bitmap != null) {
                    bitmap = BitmapUtils.rotatingImage(bitmap, degree);
                    outputStream = PictureMimeType.isContent(path) ? (FileOutputStream)PictureContentResolver.getContentResolverOpenOutputStream(context, Uri.parse((String)path)) : new FileOutputStream(path);
                    BitmapUtils.saveBitmapFile(bitmap, outputStream);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PictureFileUtils.close(inputStream);
            PictureFileUtils.close(outputStream);
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
        }
    }

    public static Bitmap rotatingImage(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBitmapFile(Bitmap bitmap, FileOutputStream fos) {
        ByteArrayOutputStream stream = null;
        try {
            stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fos);
            fos.write(stream.toByteArray());
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PictureFileUtils.close(fos);
            PictureFileUtils.close(stream);
        }
    }

    /*
     * Exception decompiling
     */
    public static int readPictureDegree(Context context, String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int[] getMaxImageSize(int imageWidth, int imageHeight) {
        int maxWidth = -1;
        int maxHeight = -1;
        if (imageWidth == 0 && imageHeight == 0) {
            return new int[]{maxWidth, maxHeight};
        }
        int inSampleSize = BitmapUtils.computeSize(imageWidth, imageHeight);
        long totalMemory = BitmapUtils.getTotalMemory();
        boolean decodeAttemptSuccess = false;
        while (!decodeAttemptSuccess) {
            maxWidth = imageWidth / inSampleSize;
            maxHeight = imageHeight / inSampleSize;
            int bitmapSize = maxWidth * maxHeight * 4;
            if ((long)bitmapSize > totalMemory) {
                inSampleSize *= 2;
                continue;
            }
            decodeAttemptSuccess = true;
        }
        return new int[]{maxWidth, maxHeight};
    }

    public static long getTotalMemory() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        return totalMemory > 0x6400000L ? 0x6400000L : totalMemory;
    }

    public static int computeSize(int srcWidth, int srcHeight) {
        srcWidth = srcWidth % 2 == 1 ? srcWidth + 1 : srcWidth;
        srcHeight = srcHeight % 2 == 1 ? srcHeight + 1 : srcHeight;
        int longSide = Math.max(srcWidth, srcHeight);
        int shortSide = Math.min(srcWidth, srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            if (longSide < 1664) {
                return 1;
            }
            if (longSide < 4990) {
                return 2;
            }
            if (longSide > 4990 && longSide < 10240) {
                return 4;
            }
            return longSide / 1280;
        }
        if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        return (int)Math.ceil((double)longSide / (1280.0 / (double)scale));
    }
}

