/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.obj.pool;

import java.util.LinkedList;

public final class ObjectPools {

    public static class SynchronizedPool<T>
    extends SimpleObjectPool<T> {
        private final Object mLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T acquire() {
            Object object = this.mLock;
            synchronized (object) {
                return super.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release(T obj) {
            Object object = this.mLock;
            synchronized (object) {
                return super.release(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            Object object = this.mLock;
            synchronized (object) {
                super.destroy();
            }
        }
    }

    public static class SimpleObjectPool<T>
    implements Pool<T> {
        private final LinkedList<T> mPool = new LinkedList();

        @Override
        public T acquire() {
            return this.mPool.poll();
        }

        @Override
        public boolean release(T obj) {
            if (this.isInPool(obj)) {
                return false;
            }
            return this.mPool.add(obj);
        }

        @Override
        public void destroy() {
            this.mPool.clear();
        }

        private boolean isInPool(T obj) {
            return this.mPool.contains(obj);
        }
    }

    public static interface Pool<T> {
        public T acquire();

        public boolean release(T var1);

        public void destroy();
    }
}

